package com.dahuatech.icc.brm.model.v202010.card;

import com.dahuatech.hutool.http.Method;
import com.dahuatech.icc.brm.constant.BrmConstant;
import com.dahuatech.icc.exception.ClientException;
import com.dahuatech.icc.oauth.http.AbstractIccRequest;

/**
 * 卡片详情查看
 *
 * @author 232676
 * @since 1.0.0 2020/11/9 11:19
 */
public class BrmCardQueryRequest extends AbstractIccRequest<BrmCardQueryResponse> {

  public BrmCardQueryRequest(String cardNumber) throws ClientException {
    super(BrmConstant.url(BrmConstant.BRM_URL_CARD_DETAIL_REST_GET, cardNumber), Method.GET);
  }

  @Override
  public Class<BrmCardQueryResponse> getResponseClass() {
    return BrmCardQueryResponse.class;
  }
}
