package com.dahuatech.icc.brm.model.v202010.card;

import com.dahuatech.hutool.http.Method;
import com.dahuatech.icc.brm.constant.BrmConstant;
import com.dahuatech.icc.exception.ClientException;
import com.dahuatech.icc.oauth.http.AbstractIccRequest;

import java.util.List;

/**
 * 卡片回收
 *
 * @author 237417
 * @since 1.0.0 2021/03/01
 */
public class BrmCardReturnRequest extends AbstractIccRequest<BrmCardReturnResponse> {

    private List<Long> cardIds;
    private List<String> cardNumbers;

    public BrmCardReturnRequest() throws ClientException {
        super(BrmConstant.url(BrmConstant.BRM_URL_CARD_RETURN_PUT), Method.PUT);
    }

    @Override
    public Class<BrmCardReturnResponse> getResponseClass() {
        return BrmCardReturnResponse.class;
    }

    public List<Long> getCardIds() {
        return cardIds;
    }

    public void setCardIds(List<Long> cardIds) {
        this.cardIds = cardIds;
        putBodyParameter("cardIds", cardIds);
    }

    public List<String> getCardNumbers() {
        return cardNumbers;
    }

    public void setCardNumbers(List<String> cardNumbers) {
        this.cardNumbers = cardNumbers;
        putBodyParameter("cardNumbers", cardNumbers);
    }
}
