package com.dahuatech.icc.brm.model.v202010.department;

import com.dahuatech.hutool.http.Method;
import com.dahuatech.icc.brm.constant.BrmConstant;
import com.dahuatech.icc.exception.ClientException;
import com.dahuatech.icc.oauth.http.AbstractIccRequest;

/**
 * 部门ID生成
 *
 * @author 232676
 * @since 1.0.0 2020/11/5 11:27
 */
public class BrmDeptGenIdRequest extends AbstractIccRequest<BrmDeptGenIdResponse> {

  public BrmDeptGenIdRequest(Integer count) throws ClientException {
    super(BrmConstant.url(BrmConstant.BRM_URL_DEPT_BATCH_GEN_ID_GET), Method.GET);
    form("count", count);
  }

  @Override
  public Class<BrmDeptGenIdResponse> getResponseClass() {
    return BrmDeptGenIdResponse.class;
  }
}
