package com.dahuatech.icc.brm.model.v202010.department;

import com.dahuatech.hutool.http.Method;
import com.dahuatech.icc.brm.constant.BrmConstant;
import com.dahuatech.icc.exception.ClientException;
import com.dahuatech.icc.oauth.http.AbstractIccRequest;

/**
 * 部门详情
 *
 * @author 232676
 * @since 1.0.0 2020/11/5 11:27
 */
public class BrmDeptQueryRequest extends AbstractIccRequest<BrmDeptQueryResponse> {

  public BrmDeptQueryRequest(Long deptId) throws ClientException {
    super(BrmConstant.url(BrmConstant.BRM_URL_DEPT_DETAIL_REST_GET, deptId), Method.GET);
  }

  @Override
  public Class<BrmDeptQueryResponse> getResponseClass() {
    return BrmDeptQueryResponse.class;
  }
}
