package com.dahuatech.icc.brm.model.v202010.device;

import com.dahuatech.hutool.http.Method;
import com.dahuatech.icc.brm.constant.BrmConstant;
import com.dahuatech.icc.exception.ClientException;
import com.dahuatech.icc.oauth.http.AbstractIccRequest;

/**
 * 设备详情查询
 *
 * @author 232676
 * @since 1.0.0 2020/11/9 11:19
 */
public class BrmDeviceQueryRequest extends AbstractIccRequest<BrmDeviceQueryResponse> {

  public BrmDeviceQueryRequest(String deviceCode) throws ClientException {
    super(BrmConstant.url(BrmConstant.BRM_URL_DEVICE_DETAIL_GET, deviceCode), Method.GET);
  }

  @Override
  public Class<BrmDeviceQueryResponse> getResponseClass() {
    return BrmDeviceQueryResponse.class;
  }
}
