package com.dahuatech.icc.brm.model.v202010.person;

import com.dahuatech.hutool.http.Method;
import com.dahuatech.icc.brm.constant.BrmConstant;
import com.dahuatech.icc.exception.ClientException;
import com.dahuatech.icc.oauth.http.AbstractIccRequest;

/**
 * @author 237417
 * @since 1.0.0 2020/03/02
 */
public class BrmPersonBatchGenIdRequest extends AbstractIccRequest<BrmPersonBatchGenIdResponse> {


    public BrmPersonBatchGenIdRequest(Integer count) throws ClientException {
        super(BrmConstant.url(BrmConstant.BRM_URL_PERSON_BATCH_GEN_ID_GET), Method.GET);
        form("count", count);
    }

    @Override
    public Class<BrmPersonBatchGenIdResponse> getResponseClass() {
        return BrmPersonBatchGenIdResponse.class;
    }
}
