package com.dahuatech.icc.brm.model.v202010.person;

import com.dahuatech.hutool.http.Method;
import com.dahuatech.icc.brm.constant.BrmConstant;
import com.dahuatech.icc.exception.ClientException;
import com.dahuatech.icc.oauth.http.AbstractIccRequest;

import java.util.List;

/**
 * 人员删除
 *
 * @author 232676
 * @since 1.0.0 2020/11/9 11:19
 */
public class BrmPersonDelRequest extends AbstractIccRequest<BrmPersonDelResponse> {

  private List<Long> ids;

  private BrmPersonDelRequest(Builder builder) throws ClientException {
    super(BrmConstant.url(BrmConstant.BRM_URL_PERSON_DEL_POST), Method.POST);
    this.ids = builder.ids;
    putBodyParameter("ids", ids);
  }

  public static Builder builder() {
    return new Builder();
  }

  @Override
  public Class<BrmPersonDelResponse> getResponseClass() {
    return BrmPersonDelResponse.class;
  }

  public List<Long> getIds() {
    return ids;
  }

  public void setIds(List<Long> ids) {
    this.ids = ids;
    putBodyParameter("ids", ids);
  }

  public static class Builder {
    private List<Long> ids;

    public Builder ids(List<Long> ids) {
      this.ids = ids;
      return this;
    }

    public BrmPersonDelRequest build() throws ClientException {
      return new BrmPersonDelRequest(this);
    }
  }
}
