package com.dahuatech.icc.brm.model.v202010.person;

import com.dahuatech.hutool.http.Method;
import com.dahuatech.icc.brm.constant.BrmConstant;
import com.dahuatech.icc.exception.ClientException;
import com.dahuatech.icc.oauth.http.AbstractIccRequest;

/**
 * 人员详情
 *
 * @author 232676
 * @since 1.0.0 2020/11/9 11:19
 */
public class BrmPersonQueryByIdCardRequest
    extends AbstractIccRequest<BrmPersonQueryByIdCardResponse> {

  public BrmPersonQueryByIdCardRequest(String idCard) throws ClientException {
    super(BrmConstant.url(BrmConstant.BRM_URL_PERSON_QUERY_BY_ID_CARD_GET), Method.GET);
    form("paperNumber", idCard);
  }

  @Override
  public Class<BrmPersonQueryByIdCardResponse> getResponseClass() {
    return BrmPersonQueryByIdCardResponse.class;
  }
}
