package com.dahuatech.icc.brm.model.v202010.person;

import com.dahuatech.hutool.http.Method;
import com.dahuatech.icc.brm.constant.BrmConstant;
import com.dahuatech.icc.exception.ClientException;
import com.dahuatech.icc.oauth.http.AbstractIccRequest;

/**
 * 人员详情
 *
 * @author 232676
 * @since 1.0.0 2020/11/9 11:19
 */
public class BrmPersonQueryRequest extends AbstractIccRequest<BrmPersonQueryResponse> {

  public BrmPersonQueryRequest(Long id) throws ClientException {
    super(BrmConstant.url(BrmConstant.BRM_URL_PERSON_DETAIL_REST_GET, id), Method.GET);
  }

  @Override
  public Class<BrmPersonQueryResponse> getResponseClass() {
    return BrmPersonQueryResponse.class;
  }
}
