package com.dahuatech.icc.brm.model.v202010.user;

import com.dahuatech.hutool.http.Method;
import com.dahuatech.icc.brm.constant.BrmConstant;
import com.dahuatech.icc.exception.ClientException;
import com.dahuatech.icc.oauth.http.AbstractIccRequest;

public class BrmUserDeleteRequest
        extends AbstractIccRequest<BrmUserDeleteResponse> {

    /** 用户ID数组 */
    private String ids;

    private BrmUserDeleteRequest(BrmUserDeleteRequest.Builder builder) throws ClientException {
        super(BrmConstant.url(BrmConstant.BRM_URL_USER_DEL_DELETE), Method.DELETE);
        this.ids = builder.ids;
        putBodyParameter("ids", ids);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Class<BrmUserDeleteResponse> getResponseClass() {
        return BrmUserDeleteResponse.class;
    }

    public String getIds() {
        return ids;
    }

    public void setIds(String ids) {
        this.ids = ids;
        putBodyParameter("ids", ids);
    }

    public static class Builder {
        /** 部门Id */
        private String ids;

        public Builder ids(String ids) {
            this.ids = ids;
            return this;
        }

        public BrmUserDeleteRequest build() throws ClientException {
            return new BrmUserDeleteRequest(this);
        }
    }
}
