package com.dahuatech.icc.brm.model.v202010.user;

import com.dahuatech.hutool.http.Method;
import com.dahuatech.icc.brm.constant.BrmConstant;
import com.dahuatech.icc.exception.ClientException;
import com.dahuatech.icc.oauth.http.AbstractIccRequest;

/**
 * 用户详情查看
 *
 * @author 232676
 * @since 1.0.0 2020-10-24 20:59:11
 */
public class BrmUserDetailRequest extends AbstractIccRequest<BrmUserDetailResponse> {

  public BrmUserDetailRequest(Long userId) throws ClientException {
    super(BrmConstant.url(BrmConstant.BRM_URL_USER_DETAIL_REST_GET, userId), Method.GET);
  }

  @Override
  public Class<BrmUserDetailResponse> getResponseClass() {
    return BrmUserDetailResponse.class;
  }
}
