/*
 * Decompiled with CFR 0.152.
 */
package com.dahuatech.icc.brm.model.v202010.role;

import com.dahuatech.hutool.http.Method;
import com.dahuatech.icc.brm.constant.BrmConstant;
import com.dahuatech.icc.brm.model.v202010.role.BrmRoleAddResponse;
import com.dahuatech.icc.exception.ClientException;
import com.dahuatech.icc.oauth.http.AbstractIccRequest;
import java.util.List;
import java.util.Set;

public class BrmRoleAddRequest
extends AbstractIccRequest<BrmRoleAddResponse> {
    private String roleName;
    private Integer roleGrade;
    private String ownerCode;
    private String memo;
    private Integer defaultRole;
    private List<MenuInfo> menus;
    private Boolean allMenus;
    private Set<String> organizations;
    private Set<Long> departments;

    public BrmRoleAddRequest(Builder builder) throws ClientException {
        super(BrmConstant.url("/evo-apigw/evo-brm/%s/role"), Method.POST);
        this.roleName = builder.roleName;
        this.roleGrade = builder.roleGrade;
        this.memo = builder.memo;
        this.ownerCode = builder.ownerCode;
        this.defaultRole = builder.defaultRole;
        this.menus = builder.menus;
        this.allMenus = builder.allMenus;
        this.organizations = builder.organizations;
        this.departments = builder.departments;
        this.putBodyParameter("roleName", this.roleName);
        this.putBodyParameter("roleGrade", this.roleGrade);
        this.putBodyParameter("memo", this.memo);
        this.putBodyParameter("ownerCode", this.ownerCode);
        this.putBodyParameter("defaultRole", this.defaultRole);
        this.putBodyParameter("menus", this.menus);
        this.putBodyParameter("allMenus", this.allMenus);
        this.putBodyParameter("organization", this.organizations);
        this.putBodyParameter("departments", this.departments);
    }

    public static Builder builder() {
        return new Builder();
    }

    public Class<BrmRoleAddResponse> getResponseClass() {
        return BrmRoleAddResponse.class;
    }

    public String getRoleName() {
        return this.roleName;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
        this.putBodyParameter("roleName", roleName);
    }

    public Integer getRoleGrade() {
        return this.roleGrade;
    }

    public void setRoleGrade(Integer roleGrade) {
        this.roleGrade = roleGrade;
        this.putBodyParameter("roleGrade", roleGrade);
    }

    public String getOwnerCode() {
        return this.ownerCode;
    }

    public void setOwnerCode(String ownerCode) {
        this.ownerCode = ownerCode;
        this.putBodyParameter("ownerCode", ownerCode);
    }

    public String getMemo() {
        return this.memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
        this.putBodyParameter("memo", memo);
    }

    public Integer getDefaultRole() {
        return this.defaultRole;
    }

    public void setDefaultRole(Integer defaultRole) {
        this.defaultRole = defaultRole;
        this.putBodyParameter("defaultRole", defaultRole);
    }

    public List<MenuInfo> getMenus() {
        return this.menus;
    }

    public void setMenus(List<MenuInfo> menus) {
        this.menus = menus;
        this.putBodyParameter("menus", menus);
    }

    public Boolean getAllMenus() {
        return this.allMenus;
    }

    public void setAllMenus(Boolean allMenus) {
        this.allMenus = allMenus;
        this.putBodyParameter("allMenus", allMenus);
    }

    public Set<String> getOrganizations() {
        return this.organizations;
    }

    public void setOrganizations(Set<String> organizations) {
        this.organizations = organizations;
        this.putBodyParameter("organization", organizations);
    }

    public Set<Long> getDepartments() {
        return this.departments;
    }

    public void setDepartments(Set<Long> departments) {
        this.departments = departments;
        this.putBodyParameter("departments", departments);
    }

    public String toString() {
        return "BrmRoleAddRequest{roleName='" + this.roleName + '\'' + ", roleGrade=" + this.roleGrade + ", ownerCode='" + this.ownerCode + '\'' + ", memo='" + this.memo + '\'' + ", defaultRole=" + this.defaultRole + ", menus=" + this.menus + ", allMenus=" + this.allMenus + ", organizations=" + this.organizations + ", departments=" + this.departments + '}';
    }

    public static class Builder {
        private String roleName;
        private Integer roleGrade;
        private String ownerCode;
        private String memo;
        private Integer defaultRole;
        private List<MenuInfo> menus;
        private Boolean allMenus;
        private Set<String> organizations;
        private Set<Long> departments;

        public Builder roleName(String roleName) {
            this.roleName = roleName;
            return this;
        }

        public Builder roleGrade(Integer roleGrade) {
            this.roleGrade = roleGrade;
            return this;
        }

        public Builder owenCode(String ownerCode) {
            this.ownerCode = ownerCode;
            return this;
        }

        public Builder memo(String memo) {
            this.memo = memo;
            return this;
        }

        public Builder defaultRole(Integer defaultRole) {
            this.defaultRole = defaultRole;
            return this;
        }

        public Builder menus(List<MenuInfo> menus) {
            this.menus = menus;
            return this;
        }

        public Builder allMenus(Boolean allMenus) {
            this.allMenus = allMenus;
            return this;
        }

        public Builder organizations(Set<String> organizations) {
            this.organizations = organizations;
            return this;
        }

        public Builder departments(Set<Long> departments) {
            this.departments = departments;
            return this;
        }

        public BrmRoleAddRequest build() throws ClientException {
            return new BrmRoleAddRequest(this);
        }
    }

    public static class MenuInfo {
        private List<String> menuCode;
        private Integer terminal;

        public List<String> getMenuCode() {
            return this.menuCode;
        }

        public void setMenuCode(List<String> menuCode) {
            this.menuCode = menuCode;
        }

        public Integer getTerminal() {
            return this.terminal;
        }

        public void setTerminal(Integer terminal) {
            this.terminal = terminal;
        }
    }
}

