/*
 * Decompiled with CFR 0.152.
 */
package com.dahuatech.hutool.core.date;

import com.dahuatech.hutool.core.date.DateUnit;
import com.dahuatech.hutool.core.date.DateUtil;
import java.io.Serializable;

public class TimeInterval
implements Serializable {
    private static final long serialVersionUID = 1L;
    private long time;
    private boolean isNano;

    public TimeInterval() {
        this(false);
    }

    public TimeInterval(boolean isNano) {
        this.isNano = isNano;
        this.start();
    }

    public long start() {
        this.time = DateUtil.current(this.isNano);
        return this.time;
    }

    public long intervalRestart() {
        long now = DateUtil.current(this.isNano);
        long d = now - this.time;
        this.time = now;
        return d;
    }

    public TimeInterval restart() {
        this.time = DateUtil.current(this.isNano);
        return this;
    }

    public long interval() {
        return DateUtil.current(this.isNano) - this.time;
    }

    public String intervalPretty() {
        return DateUtil.formatBetween(this.intervalMs());
    }

    public long intervalMs() {
        return this.isNano ? this.interval() / 1000000L : this.interval();
    }

    public long intervalSecond() {
        return this.intervalMs() / DateUnit.SECOND.getMillis();
    }

    public long intervalMinute() {
        return this.intervalMs() / DateUnit.MINUTE.getMillis();
    }

    public long intervalHour() {
        return this.intervalMs() / DateUnit.HOUR.getMillis();
    }

    public long intervalDay() {
        return this.intervalMs() / DateUnit.DAY.getMillis();
    }

    public long intervalWeek() {
        return this.intervalMs() / DateUnit.WEEK.getMillis();
    }
}

