/*
 * Decompiled with CFR 0.152.
 */
package com.dahuatech.hutool.http.useragent;

import com.dahuatech.hutool.core.collection.CollUtil;
import com.dahuatech.hutool.core.util.ReUtil;
import com.dahuatech.hutool.http.useragent.UserAgentInfo;
import java.util.List;
import java.util.regex.Pattern;

public class Browser
extends UserAgentInfo {
    public static final Browser Unknown = new Browser("Unknown", null, null);
    public static final String Other_Version = "[\\/ ]([\\d\\w\\.\\-]+)";
    public static final List<Browser> browers = CollUtil.newArrayList(new Browser("MSEdge", "Edge", "edge\\/([\\d\\w\\.\\-]+)"), new Browser("Chrome", "chrome", "chrome\\/([\\d\\w\\.\\-]+)"), new Browser("Firefox", "firefox", "[\\/ ]([\\d\\w\\.\\-]+)"), new Browser("IEMobile", "iemobile", "[\\/ ]([\\d\\w\\.\\-]+)"), new Browser("Safari", "safari", "version\\/([\\d\\w\\.\\-]+)"), new Browser("Opera", "opera", "[\\/ ]([\\d\\w\\.\\-]+)"), new Browser("Konqueror", "konqueror", "[\\/ ]([\\d\\w\\.\\-]+)"), new Browser("PS3", "playstation 3", "([\\d\\w\\.\\-]+)\\)\\s*$"), new Browser("PSP", "playstation portable", "([\\d\\w\\.\\-]+)\\)?\\s*$"), new Browser("Lotus", "lotus.notes", "Lotus-Notes\\/([\\w.]+)"), new Browser("Thunderbird", "thunderbird", "[\\/ ]([\\d\\w\\.\\-]+)"), new Browser("Netscape", "netscape", "[\\/ ]([\\d\\w\\.\\-]+)"), new Browser("Seamonkey", "seamonkey", "[\\/ ]([\\d\\w\\.\\-]+)"), new Browser("Outlook", "microsoft.outlook", "[\\/ ]([\\d\\w\\.\\-]+)"), new Browser("Evolution", "evolution", "[\\/ ]([\\d\\w\\.\\-]+)"), new Browser("MSIE", "msie", "msie ([\\d\\w\\.\\-]+)"), new Browser("MSIE11", "rv:11", "rv:([\\d\\w\\.\\-]+)"), new Browser("Gabble", "Gabble", "Gabble\\/([\\d\\w\\.\\-]+)"), new Browser("Yammer Desktop", "AdobeAir", "([\\d\\w\\.\\-]+)\\/Yammer"), new Browser("Yammer Mobile", "Yammer[\\s]+([\\d\\w\\.\\-]+)", "Yammer[\\s]+([\\d\\w\\.\\-]+)"), new Browser("Apache HTTP Client", "Apache\\\\-HttpClient", "Apache\\-HttpClient\\/([\\d\\w\\.\\-]+)"), new Browser("BlackBerry", "BlackBerry", "BlackBerry[\\d]+\\/([\\d\\w\\.\\-]+)"));
    private Pattern versionPattern;

    public Browser(String name, String regex, String versionRegex) {
        super(name, regex);
        if (Other_Version.equals(versionRegex)) {
            versionRegex = name + versionRegex;
        }
        if (null != versionRegex) {
            this.versionPattern = Pattern.compile(versionRegex, 2);
        }
    }

    public String getVersion(String userAgentString) {
        return ReUtil.getGroup1(this.versionPattern, (CharSequence)userAgentString);
    }

    public boolean isMobile() {
        return "PSP".equals(this.getName());
    }
}

