/*
 * Decompiled with CFR 0.152.
 */
package com.dahuatech.icc.oauth.http;

import com.dahuatech.hutool.http.ContentType;
import com.dahuatech.hutool.http.HttpRequest;
import com.dahuatech.hutool.http.HttpResponse;
import com.dahuatech.hutool.http.Method;
import com.dahuatech.hutool.log.Log;
import com.dahuatech.hutool.log.LogFactory;
import com.dahuatech.icc.exception.ClientException;
import com.dahuatech.icc.oauth.http.AbstractHttpRequest;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class IccHttpHttpRequest
extends AbstractHttpRequest {
    private static final Log logger = LogFactory.get();
    protected final Map<String, Object> bodyParameters = new HashMap<String, Object>();
    protected HttpRequest httpRequest;
    protected Map<String, Object> form;
    private String url;
    private Method method;
    private String body;
    private Map<String, String> header;
    private boolean needAuth = Boolean.TRUE;

    public IccHttpHttpRequest(String url, Method method) throws ClientException {
        this.url = url;
        this.method = method;
        this.form = new HashMap<String, Object>();
        this.header = new HashMap<String, String>();
        this.httpRequest = new HttpRequest(url).method(method);
    }

    public IccHttpHttpRequest() {
    }

    public IccHttpHttpRequest(String url, Method method, boolean needAuth) {
        this.url = url;
        this.method = method;
        this.form = new HashMap<String, Object>();
        this.header = new HashMap<String, String>();
        this.needAuth = needAuth;
        this.httpRequest = new HttpRequest(url).method(method);
    }

    public IccHttpHttpRequest(String url, Method method, boolean needAuth, String body) throws ClientException {
        this.url = url;
        this.method = method;
        this.form = new HashMap<String, Object>();
        this.header = new HashMap<String, String>();
        this.body = body;
        this.needAuth = needAuth;
        this.httpRequest = new HttpRequest(url).method(method).body(body).contentType(ContentType.JSON.toString());
    }

    public IccHttpHttpRequest(String url, Method method, boolean needAuth, Map<String, Object> form) throws ClientException {
        this.url = url;
        this.method = method;
        this.form = form;
        this.header = new HashMap<String, String>();
        this.needAuth = needAuth;
        this.httpRequest = new HttpRequest(url).method(method).body(this.body);
    }

    public IccHttpHttpRequest(String url, Method method, String body) throws ClientException {
        this.url = url;
        this.method = method;
        this.form = new HashMap<String, Object>();
        this.header = new HashMap<String, String>();
        this.body = body;
        this.httpRequest = new HttpRequest(url).method(method).body(body).contentType(ContentType.JSON.toString());
    }

    public IccHttpHttpRequest(String url, Method method, Map<String, Object> form) throws ClientException {
        this.url = url;
        this.method = method;
        this.form = form;
        this.header = new HashMap<String, String>();
        this.httpRequest = new HttpRequest(url).method(method).form(form);
    }

    public IccHttpHttpRequest(String url) throws ClientException {
        this.url = url;
        this.method = Method.GET;
        this.form = new HashMap<String, Object>();
        this.header = new HashMap<String, String>();
        this.httpRequest = new HttpRequest(url).method(this.method);
    }

    public static void main(String[] args) {
        System.out.println(ContentType.FORM_URLENCODED.toString());
    }

    public IccHttpHttpRequest post(String url) {
        this.url = url;
        this.method = Method.POST;
        this.httpRequest.setUrl(url).method(this.method);
        return this;
    }

    public IccHttpHttpRequest get(String url) {
        this.url = url;
        this.method = Method.GET;
        this.httpRequest.setUrl(url).method(this.method);
        return this;
    }

    public IccHttpHttpRequest body(String body) {
        this.body = body;
        this.httpRequest.body(body);
        return this;
    }

    public IccHttpHttpRequest header(String name, String value) {
        this.header.put(name, value);
        this.httpRequest.header(name, value);
        return this;
    }

    public IccHttpHttpRequest form(String name, Object value) {
        this.form.put(name, value);
        this.httpRequest.form(name, value);
        return this;
    }

    public IccHttpHttpRequest form(Map<String, Object> formParam) {
        this.form.putAll(formParam);
        this.httpRequest.form(formParam);
        return this;
    }

    public String execute() {
        HttpResponse response = this.httpRequest.execute();
        String resultBody = response.body();
        if (response.getStatus() != 200) {
            logger.warn("request url [{}] an unexpected error ,origin response {}", new Object[]{this.httpRequest.getUrl(), resultBody});
        }
        return resultBody;
    }

    public HttpResponse executeResponse() {
        HttpResponse httpResponse = this.httpRequest.execute();
        if (httpResponse.getStatus() != 200) {
            logger.warn("request url [{}] an unexpected error ,result code {}", new Object[]{this.httpRequest.getUrl(), httpResponse.getStatus()});
        }
        return httpResponse;
    }

    @Override
    HttpRequest signRequest(IccHttpHttpRequest request) {
        return null;
    }

    public HttpRequest getHttpRequest() {
        return this.httpRequest;
    }

    public void setHttpRequest(HttpRequest httpRequest) {
        this.httpRequest = httpRequest;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
        this.httpRequest.setUrl(url);
    }

    public Method getMethod() {
        return this.method;
    }

    public void setMethod(Method method) {
        this.method = method;
        this.httpRequest.setMethod(method);
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
        this.httpRequest.body(body);
    }

    public Map<String, Object> getForm() {
        return this.form;
    }

    public void setForm(Map<String, Object> form) {
        this.form = form;
        this.httpRequest.form(form);
    }

    public Map<String, String> getHeader() {
        return this.header;
    }

    public void setHeader(Map<String, String> header) {
        this.header = header;
        if (header != null && !header.isEmpty()) {
            Iterator<String> it = header.keySet().iterator();
            while (it.hasNext()) {
                this.httpRequest.header(it.next(), header.get(it.next()));
            }
        }
    }

    public boolean isNeedAuth() {
        return this.needAuth;
    }

    public void setNeedAuth(boolean needAuth) {
        this.needAuth = needAuth;
    }

    public Map<String, Object> getBodyParameters() {
        return this.bodyParameters;
    }
}

