/*
 * Decompiled with CFR 0.152.
 */
package com.dahuatech.icc.oauth.constant;

import com.dahuatech.icc.oauth.profile.IccProfile;

public class OauthConstant {
    public static final String SYSTEM_NAME = "evo-oauth";
    public static final String OAUTH_URL_PUBLIC_KEY_GET = "/evo-apigw/evo-oauth/%s/oauth/public-key";
    public static final String OAUTH_URL_PWD_AUTH_POST = "/evo-apigw/evo-oauth/%s/oauth/extend/token";
    public static final String OAUTH_URL_REFRESH_TOKEN_POST = "/evo-apigw/evo-oauth/%s/oauth/extend/refresh/token";
    public static final String OAUTH_URL_CHECK_TOKEN_POST = "/evo-apigw/evo-oauth/oauth/check_token";
    public static final String OAUTH_URL_CLIENT_AUTH = "/evo-apigw/evo-oauth/oauth/token";
    public static final String OAUTH_URL_LOGOUT_GET = "/evo-apigw/evo-oauth/%s/oauth/logout";
    public static final String OAUTH_URL_PWD_RESET_PUT = "/evo-apigw/evo-oauth/%s/oauth/reset/password";
    public static final String OAUTH_URL_PWD_CHECK_POST = "/evo-apigw/evo-oauth/%s/oauth/check/password";
    public static final String OAUTH_URL_PWD_CHANGE_POST = "/evo-apigw/evo-oauth/%s/oauth/change/password";
    public static final String BRM_URL_KEEP_ALIVE_POST = "/evo-apigw/evo-brm/%s/user/keepalive";
    public static String version = "1.0.0";
    private static boolean initVersionFromBrm = Boolean.FALSE;

    public static String brmUrl(String url) {
        String brmName = "evo-brm";
        String brmVersion = "1.0.0";
        if (!initVersionFromBrm && IccProfile.systemVersionMap.containsKey(brmName)) {
            brmVersion = IccProfile.systemVersionMap.get(brmName);
            initVersionFromBrm = true;
        }
        return String.format(IccProfile.URL_SCHEME + url, brmVersion);
    }

    public static String url(String url) {
        if (!initVersionFromBrm && IccProfile.systemVersionMap.containsKey(SYSTEM_NAME)) {
            version = IccProfile.systemVersionMap.get(SYSTEM_NAME);
            initVersionFromBrm = true;
        }
        return String.format(IccProfile.URL_SCHEME + url, version);
    }

    public static enum ClientType {
        WEB(1),
        CLIENT(2),
        APP(3);

        private int clientType;

        private ClientType(int clientType) {
            this.clientType = clientType;
        }

        public int getClientType() {
            return this.clientType;
        }
    }
}

