/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.dataConvertion.accessor.BaseAccessor;
import dm.jdbc.dataConvertion.binder.DmBinder;
import dm.jdbc.dataConvertion.binder.DmOutParamBinder;
import dm.jdbc.dbaccess.DBError;
import dm.jdbc.dbaccess.DmdbCSI;
import dm.jdbc.desc.DmSvcConf;
import dm.jdbc.desc.ParameterDesc;
import dm.jdbc.driver.DmdbColumn;
import dm.jdbc.driver.DmdbConnection_bs;
import dm.jdbc.driver.DmdbInfo;
import dm.jdbc.driver.DmdbPreparedStatement_bs;
import dm.jdbc.driver.DmdbResultSet_bs;
import dm.jdbc.driver.DmdbStatement_bs;
import dm.jdbc.driver.DmdbType;
import dm.jdbc.util.StringUtil;
import dm.sql.DmdbIntervalDT;
import dm.sql.DmdbIntervalYM;
import dm.sql.DmdbTimestamp;
import dm.sql.TypeDescriptor;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DmdbCallableStatement_bs
extends DmdbPreparedStatement_bs
implements CallableStatement {
    boolean wasNullFlag = false;
    ArrayList<DmdbColumn[]> colsInfo = null;
    short resultsCount = 0;
    private BaseAccessor[] outParamAccessor;

    void initializeReuseCallableStmt(DmdbConnection_bs conn, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        super.initializeReusePreparedStmt(conn, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        this.type = 2;
    }

    DmdbCallableStatement_bs(DmdbConnection_bs conn, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        super(conn, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        this.type = 2;
    }

    @Override
    void initialize(String sql) throws SQLException {
        this.outParamAccessor = null;
        super.initialize(sql);
        if (this.m_paramsDesc != null && this.m_paramsDesc.length > 0) {
            this.outParamAccessor = new BaseAccessor[this.m_paramsDesc.length];
            int i = 0;
            while (i < this.m_paramsDesc.length) {
                if (this.m_paramsDesc[i].getIOType() == 1 || this.m_paramsDesc[i].getIOType() == 2) {
                    this.outParamAccessor[i] = BaseAccessor.getInstance(this.m_paramsDesc[i], this.connection, this.getMaxFieldSize());
                }
                ++i;
            }
        }
    }

    @Override
    public synchronized void registerOutParameter(int parameterIndex, int sqlType) throws SQLException {
        this.regOutParam(parameterIndex, sqlType);
        if (sqlType == 50 || sqlType == -10) {
            this.resultsCount = (short)(this.resultsCount + 1);
        }
    }

    @Override
    public synchronized void registerOutParameter(int parameterIndex, int sqlType, int scale) throws SQLException {
        this.regOutParam(parameterIndex, sqlType, scale);
        if (sqlType == 50 || sqlType == -10) {
            this.resultsCount = (short)(this.resultsCount + 1);
        }
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.wasNullFlag;
    }

    @Override
    public String getString(int parameterIndex) throws SQLException {
        this.checkOutParam(parameterIndex);
        this.wasNullFlag = this.outParamAccessor[parameterIndex - 1].isWasNull();
        if (this.wasNullFlag) {
            return null;
        }
        return this.outParamAccessor[parameterIndex - 1].getString();
    }

    @Override
    public boolean getBoolean(int parameterIndex) throws SQLException {
        this.checkOutParam(parameterIndex);
        this.wasNullFlag = this.outParamAccessor[parameterIndex - 1].isWasNull();
        if (this.wasNullFlag) {
            return false;
        }
        return this.outParamAccessor[parameterIndex - 1].getBoolean();
    }

    @Override
    public byte getByte(int parameterIndex) throws SQLException {
        this.checkOutParam(parameterIndex);
        this.wasNullFlag = this.outParamAccessor[parameterIndex - 1].isWasNull();
        if (this.wasNullFlag) {
            return 0;
        }
        return this.outParamAccessor[parameterIndex - 1].getByte();
    }

    @Override
    public short getShort(int parameterIndex) throws SQLException {
        this.checkOutParam(parameterIndex);
        this.wasNullFlag = this.outParamAccessor[parameterIndex - 1].isWasNull();
        if (this.wasNullFlag) {
            return 0;
        }
        return this.outParamAccessor[parameterIndex - 1].getShort();
    }

    @Override
    public int getInt(int parameterIndex) throws SQLException {
        this.checkOutParam(parameterIndex);
        this.wasNullFlag = this.outParamAccessor[parameterIndex - 1].isWasNull();
        if (this.wasNullFlag) {
            return 0;
        }
        return this.outParamAccessor[parameterIndex - 1].getInt();
    }

    @Override
    public long getLong(int parameterIndex) throws SQLException {
        this.checkOutParam(parameterIndex);
        this.wasNullFlag = this.outParamAccessor[parameterIndex - 1].isWasNull();
        if (this.wasNullFlag) {
            return 0L;
        }
        return this.outParamAccessor[parameterIndex - 1].getLong();
    }

    @Override
    public float getFloat(int parameterIndex) throws SQLException {
        this.checkOutParam(parameterIndex);
        this.wasNullFlag = this.outParamAccessor[parameterIndex - 1].isWasNull();
        if (this.wasNullFlag) {
            return 0.0f;
        }
        return this.outParamAccessor[parameterIndex - 1].getFloat();
    }

    @Override
    public double getDouble(int parameterIndex) throws SQLException {
        this.checkOutParam(parameterIndex);
        this.wasNullFlag = this.outParamAccessor[parameterIndex - 1].isWasNull();
        if (this.wasNullFlag) {
            return 0.0;
        }
        return this.outParamAccessor[parameterIndex - 1].getDouble();
    }

    @Override
    public BigDecimal getBigDecimal(int parameterIndex, int scale) throws SQLException {
        this.checkOutParam(parameterIndex);
        BigDecimal bd = this.getBigDecimalWithServerDefinedScale(parameterIndex);
        if (bd == null) {
            return null;
        }
        return bd.setScale(scale, 4);
    }

    @Override
    public byte[] getBytes(int parameterIndex) throws SQLException {
        this.checkOutParam(parameterIndex);
        this.wasNullFlag = this.outParamAccessor[parameterIndex - 1].isWasNull();
        if (this.wasNullFlag) {
            return null;
        }
        return this.outParamAccessor[parameterIndex - 1].getBytes();
    }

    @Override
    public Date getDate(int parameterIndex) throws SQLException {
        this.checkOutParam(parameterIndex);
        this.wasNullFlag = this.outParamAccessor[parameterIndex - 1].isWasNull();
        if (this.wasNullFlag) {
            return null;
        }
        return this.outParamAccessor[parameterIndex - 1].getDate();
    }

    @Override
    public Time getTime(int parameterIndex) throws SQLException {
        this.checkOutParam(parameterIndex);
        this.wasNullFlag = this.outParamAccessor[parameterIndex - 1].isWasNull();
        if (this.wasNullFlag) {
            return null;
        }
        return this.outParamAccessor[parameterIndex - 1].getTime();
    }

    @Override
    public Timestamp getTimestamp(int parameterIndex) throws SQLException {
        this.checkOutParam(parameterIndex);
        this.wasNullFlag = this.outParamAccessor[parameterIndex - 1].isWasNull();
        if (this.wasNullFlag) {
            return null;
        }
        return this.outParamAccessor[parameterIndex - 1].getTimestamp();
    }

    @Override
    public Object getObject(int parameterIndex) throws SQLException {
        return this.getObjectInner(parameterIndex, this.connection.getTypeMap());
    }

    public ResultSet getCursor(String parameterName) throws SQLException {
        int parameterIndex = this.getParamIndex(parameterName);
        return this.getCursor(parameterIndex);
    }

    public ResultSet getCursor(int parameterIndex) throws SQLException {
        int sqlType;
        this.checkOutParam(parameterIndex);
        if (!this.m_curRow[parameterIndex - 1].isHasSqlType()) {
            DBError.throwSQLException(6048);
        }
        if ((sqlType = this.m_curRow[parameterIndex - 1].getSqlType()) != 50 && sqlType != -10) {
            DBError.throwSQLException(20006);
        }
        DmdbStatement_bs destStmt = this.m_curRow[parameterIndex - 1].getCursorStmt();
        DmdbCSI.getMoreResult(destStmt, (short)1);
        DmdbResultSet_bs rs = destStmt.getResultSetPrivate(2);
        return rs;
    }

    @Override
    public BigDecimal getBigDecimal(int parameterIndex) throws SQLException {
        this.checkOutParam(parameterIndex);
        BigDecimal bd = this.getBigDecimalWithServerDefinedScale(parameterIndex);
        if (bd == null) {
            return null;
        }
        if (this.m_curRow[parameterIndex - 1].isHasSqlScale()) {
            int scale = this.m_curRow[parameterIndex - 1].getSqlScale();
            return bd.setScale(scale, 4);
        }
        return bd;
    }

    private BigDecimal getBigDecimalWithServerDefinedScale(int parameterIndex) throws SQLException {
        this.wasNullFlag = this.outParamAccessor[parameterIndex - 1].isWasNull();
        if (this.wasNullFlag) {
            return null;
        }
        return this.outParamAccessor[parameterIndex - 1].getBigDecimal();
    }

    @Override
    public Object getObject(int i, Map<String, Class<?>> map) throws SQLException {
        if (map == null) {
            return this.getObject(i);
        }
        return this.getObjectInner(i, map);
    }

    private Object getObjectInner(int parameterIndex, Map<String, Class<?>> map) throws SQLException {
        this.checkOutParam(parameterIndex);
        ParameterDesc desc = this.m_paramsDesc[parameterIndex - 1];
        if (this.connection.isCompatibleOracle() && DmdbType.isNUMERICtype(DmdbType.dtypeToSqlType(desc.getDType(), desc.getTypeName()))) {
            return this.getBigDecimal(parameterIndex);
        }
        int sqlType = this.m_curRow[parameterIndex - 1].getSqlType();
        this.wasNullFlag = this.outParamAccessor[parameterIndex - 1].isWasNull();
        if (this.wasNullFlag && sqlType != 50 && sqlType != -10) {
            return null;
        }
        switch (sqlType) {
            case -10: 
            case 50: {
                return this.getCursor(parameterIndex);
            }
        }
        return this.outParamAccessor[parameterIndex - 1].getObject(map == null ? this.connection.getTypeMap() : map);
    }

    @Override
    public Ref getRef(int i) throws SQLException {
        DBError.throwUnsupportedSQLException();
        return null;
    }

    @Override
    public Blob getBlob(int i) throws SQLException {
        this.checkOutParam(i);
        this.wasNullFlag = this.outParamAccessor[i - 1].isWasNull();
        if (this.wasNullFlag) {
            return null;
        }
        return this.outParamAccessor[i - 1].getBlob();
    }

    @Override
    public Clob getClob(int i) throws SQLException {
        this.checkOutParam(i);
        this.wasNullFlag = this.outParamAccessor[i - 1].isWasNull();
        if (this.wasNullFlag) {
            return null;
        }
        return this.outParamAccessor[i - 1].getClob();
    }

    @Override
    public Array getArray(int i) throws SQLException {
        this.checkOutParam(i);
        this.wasNullFlag = this.outParamAccessor[i - 1].isWasNull();
        if (this.wasNullFlag) {
            return null;
        }
        return this.outParamAccessor[i - 1].getArray();
    }

    @Override
    public Date getDate(int parameterIndex, Calendar cal) throws SQLException {
        Date d = this.getDate(parameterIndex);
        if (d == null) {
            return null;
        }
        if (cal == null) {
            cal = Calendar.getInstance();
        }
        cal.clear();
        cal.setTimeInMillis(d.getTime());
        return new Date(cal.getTime().getTime());
    }

    @Override
    public Time getTime(int parameterIndex, Calendar cal) throws SQLException {
        Time time = this.getTime(parameterIndex);
        if (time == null) {
            return null;
        }
        if (cal == null) {
            cal = Calendar.getInstance();
        }
        cal.clear();
        cal.setTimeInMillis(time.getTime());
        return new Time(cal.getTime().getTime());
    }

    @Override
    public Timestamp getTimestamp(int parameterIndex, Calendar cal) throws SQLException {
        Timestamp timestamp = this.getTimestamp(parameterIndex);
        if (timestamp == null) {
            return null;
        }
        if (cal == null) {
            cal = Calendar.getInstance();
        }
        cal.clear();
        cal.setTime(timestamp);
        Timestamp xn = new Timestamp(cal.getTimeInMillis());
        int nanos = timestamp.getNanos();
        if (nanos != 0) {
            xn.setNanos(nanos);
        }
        return xn;
    }

    @Override
    public synchronized void registerOutParameter(int paramIndex, int sqlType, String typeName) throws SQLException {
        this.regOutParam(paramIndex, sqlType, typeName);
        if (sqlType == 50 || sqlType == -10) {
            this.resultsCount = (short)(this.resultsCount + 1);
        }
    }

    @Override
    public synchronized void registerOutParameter(String parameterName, int sqlType) throws SQLException {
        int[] parameterIndex = this.getParamIndex_forPL(parameterName);
        int i = 0;
        while (i < parameterIndex.length) {
            this.registerOutParameter(parameterIndex[i], sqlType);
            ++i;
        }
    }

    @Override
    public synchronized void registerOutParameter(String parameterName, int sqlType, int scale) throws SQLException {
        int[] parameterIndex = this.getParamIndex_forPL(parameterName);
        int i = 0;
        while (i < parameterIndex.length) {
            this.registerOutParameter(parameterIndex[i], sqlType, scale);
            ++i;
        }
    }

    @Override
    public synchronized void registerOutParameter(String parameterName, int sqlType, String typeName) throws SQLException {
        int[] parameterIndex = this.getParamIndex_forPL(parameterName);
        int i = 0;
        while (i < parameterIndex.length) {
            this.registerOutParameter(parameterIndex[i], sqlType, typeName);
            ++i;
        }
    }

    @Override
    public URL getURL(int parameterIndex) throws SQLException {
        DBError.throwUnsupportedSQLException();
        return null;
    }

    @Override
    public void setURL(String parameterName, URL val) throws SQLException {
        DBError.throwUnsupportedSQLException();
    }

    @Override
    public void setNull(String parameterName, int sqlType) throws SQLException {
        int[] parameterIndex = this.getParamIndex_forPL(parameterName);
        int i = 0;
        while (i < parameterIndex.length) {
            this.setNull(parameterIndex[i], sqlType);
            ++i;
        }
    }

    @Override
    public void setBoolean(String parameterName, boolean x) throws SQLException {
        int[] parameterIndex = this.getParamIndex_forPL(parameterName);
        int i = 0;
        while (i < parameterIndex.length) {
            this.setBoolean(parameterIndex[i], x);
            ++i;
        }
    }

    @Override
    public void setByte(String parameterName, byte x) throws SQLException {
        int[] parameterIndex = this.getParamIndex_forPL(parameterName);
        int i = 0;
        while (i < parameterIndex.length) {
            this.setByte(parameterIndex[i], x);
            ++i;
        }
    }

    @Override
    public void setShort(String parameterName, short x) throws SQLException {
        int[] parameterIndex = this.getParamIndex_forPL(parameterName);
        int i = 0;
        while (i < parameterIndex.length) {
            this.setShort(parameterIndex[i], x);
            ++i;
        }
    }

    @Override
    public void setInt(String parameterName, int x) throws SQLException {
        int[] parameterIndex = this.getParamIndex_forPL(parameterName);
        int i = 0;
        while (i < parameterIndex.length) {
            this.setInt(parameterIndex[i], x);
            ++i;
        }
    }

    @Override
    public void setLong(String parameterName, long x) throws SQLException {
        int[] parameterIndex = this.getParamIndex_forPL(parameterName);
        int i = 0;
        while (i < parameterIndex.length) {
            this.setLong(parameterIndex[i], x);
            ++i;
        }
    }

    @Override
    public void setFloat(String parameterName, float x) throws SQLException {
        int[] parameterIndex = this.getParamIndex_forPL(parameterName);
        int i = 0;
        while (i < parameterIndex.length) {
            this.setFloat(parameterIndex[i], x);
            ++i;
        }
    }

    @Override
    public void setDouble(String parameterName, double x) throws SQLException {
        int[] parameterIndex = this.getParamIndex_forPL(parameterName);
        int i = 0;
        while (i < parameterIndex.length) {
            this.setDouble(parameterIndex[i], x);
            ++i;
        }
    }

    @Override
    public void setBigDecimal(String parameterName, BigDecimal x) throws SQLException {
        int[] parameterIndex = this.getParamIndex_forPL(parameterName);
        int i = 0;
        while (i < parameterIndex.length) {
            this.setBigDecimal(parameterIndex[i], x);
            ++i;
        }
    }

    @Override
    public void setString(String parameterName, String x) throws SQLException {
        int[] parameterIndex = this.getParamIndex_forPL(parameterName);
        int i = 0;
        while (i < parameterIndex.length) {
            this.setString(parameterIndex[i], x);
            ++i;
        }
    }

    @Override
    public void setBytes(String parameterName, byte[] x) throws SQLException {
        int[] parameterIndex = this.getParamIndex_forPL(parameterName);
        int i = 0;
        while (i < parameterIndex.length) {
            this.setBytes(parameterIndex[i], x);
            ++i;
        }
    }

    @Override
    public void setDate(String parameterName, Date x) throws SQLException {
        int[] parameterIndex = this.getParamIndex_forPL(parameterName);
        int i = 0;
        while (i < parameterIndex.length) {
            this.setDate(parameterIndex[i], x);
            ++i;
        }
    }

    @Override
    public void setTime(String parameterName, Time x) throws SQLException {
        int[] parameterIndex = this.getParamIndex_forPL(parameterName);
        int i = 0;
        while (i < parameterIndex.length) {
            this.setTime(parameterIndex[i], x);
            ++i;
        }
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp x) throws SQLException {
        int[] parameterIndex = this.getParamIndex_forPL(parameterName);
        int i = 0;
        while (i < parameterIndex.length) {
            this.setTimestamp(parameterIndex[i], x);
            ++i;
        }
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x, int length) throws SQLException {
        int[] parameterIndex = this.getParamIndex_forPL(parameterName);
        int i = 0;
        while (i < parameterIndex.length) {
            this.setAsciiStream(parameterIndex[i], x, length);
            ++i;
        }
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x, long length) throws SQLException {
        int[] parameterIndex = this.getParamIndex_forPL(parameterName);
        int i = 0;
        while (i < parameterIndex.length) {
            this.setAsciiStream(parameterIndex[i], x, length);
            ++i;
        }
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x, int length) throws SQLException {
        int[] parameterIndex = this.getParamIndex_forPL(parameterName);
        int i = 0;
        while (i < parameterIndex.length) {
            this.setBinaryStream(parameterIndex[i], x, length);
            ++i;
        }
    }

    @Override
    public void setObject(String parameterName, Object x, int targetSqlType, int scale) throws SQLException {
        int[] parameterIndex = this.getParamIndex_forPL(parameterName);
        int i = 0;
        while (i < parameterIndex.length) {
            this.setObject(parameterIndex[i], x, targetSqlType, scale);
            ++i;
        }
    }

    @Override
    public void setObject(String parameterName, Object x, int targetSqlType) throws SQLException {
        int[] parameterIndex = this.getParamIndex_forPL(parameterName);
        int i = 0;
        while (i < parameterIndex.length) {
            this.setObject(parameterIndex[i], x, targetSqlType);
            ++i;
        }
    }

    @Override
    public void setObject(String parameterName, Object x) throws SQLException {
        int[] parameterIndex = this.getParamIndex_forPL(parameterName);
        int i = 0;
        while (i < parameterIndex.length) {
            this.setObject(parameterIndex[i], x);
            ++i;
        }
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader, int length) throws SQLException {
        int[] parameterIndex = this.getParamIndex_forPL(parameterName);
        int i = 0;
        while (i < parameterIndex.length) {
            this.setCharacterStream(parameterIndex[i], reader, length);
            ++i;
        }
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader, long length) throws SQLException {
        int[] parameterIndex = this.getParamIndex_forPL(parameterName);
        int i = 0;
        while (i < parameterIndex.length) {
            this.setCharacterStream(parameterIndex[i], reader, length);
            ++i;
        }
    }

    @Override
    public void setDate(String parameterName, Date x, Calendar cal) throws SQLException {
        int[] parameterIndex = this.getParamIndex_forPL(parameterName);
        int i = 0;
        while (i < parameterIndex.length) {
            this.setDate(parameterIndex[i], x, cal);
            ++i;
        }
    }

    @Override
    public void setTime(String parameterName, Time x, Calendar cal) throws SQLException {
        int[] parameterIndex = this.getParamIndex_forPL(parameterName);
        int i = 0;
        while (i < parameterIndex.length) {
            this.setTime(parameterIndex[i], x, cal);
            ++i;
        }
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp x, Calendar cal) throws SQLException {
        int[] parameterIndex = this.getParamIndex_forPL(parameterName);
        int i = 0;
        while (i < parameterIndex.length) {
            this.setTimestamp(parameterIndex[i], x, cal);
            ++i;
        }
    }

    @Override
    public void setNull(String parameterName, int sqlType, String typeName) throws SQLException {
        int[] parameterIndex = this.getParamIndex_forPL(parameterName);
        int i = 0;
        while (i < parameterIndex.length) {
            this.setNull(parameterIndex[i], sqlType, typeName);
            ++i;
        }
    }

    @Override
    public String getString(String parameterName) throws SQLException {
        int parameterIndex = this.getParamIndex(parameterName);
        return this.getString(parameterIndex);
    }

    @Override
    public boolean getBoolean(String parameterName) throws SQLException {
        int parameterIndex = this.getParamIndex(parameterName);
        return this.getBoolean(parameterIndex);
    }

    @Override
    public byte getByte(String parameterName) throws SQLException {
        int parameterIndex = this.getParamIndex(parameterName);
        return this.getByte(parameterIndex);
    }

    @Override
    public short getShort(String parameterName) throws SQLException {
        int parameterIndex = this.getParamIndex(parameterName);
        return this.getShort(parameterIndex);
    }

    @Override
    public int getInt(String parameterName) throws SQLException {
        int parameterIndex = this.getParamIndex(parameterName);
        return this.getInt(parameterIndex);
    }

    @Override
    public long getLong(String parameterName) throws SQLException {
        int parameterIndex = this.getParamIndex(parameterName);
        return this.getLong(parameterIndex);
    }

    @Override
    public float getFloat(String parameterName) throws SQLException {
        int parameterIndex = this.getParamIndex(parameterName);
        return this.getFloat(parameterIndex);
    }

    @Override
    public double getDouble(String parameterName) throws SQLException {
        int parameterIndex = this.getParamIndex(parameterName);
        return this.getDouble(parameterIndex);
    }

    @Override
    public byte[] getBytes(String parameterName) throws SQLException {
        int parameterIndex = this.getParamIndex(parameterName);
        return this.getBytes(parameterIndex);
    }

    @Override
    public Date getDate(String parameterName) throws SQLException {
        int parameterIndex = this.getParamIndex(parameterName);
        return this.getDate(parameterIndex);
    }

    @Override
    public Time getTime(String parameterName) throws SQLException {
        int parameterIndex = this.getParamIndex(parameterName);
        return this.getTime(parameterIndex);
    }

    @Override
    public Timestamp getTimestamp(String parameterName) throws SQLException {
        int parameterIndex = this.getParamIndex(parameterName);
        return this.getTimestamp(parameterIndex);
    }

    @Override
    public Object getObject(String parameterName) throws SQLException {
        int parameterIndex = this.getParamIndex(parameterName);
        return this.getObject(parameterIndex);
    }

    @Override
    public BigDecimal getBigDecimal(String parameterName) throws SQLException {
        int parameterIndex = this.getParamIndex(parameterName);
        return this.getBigDecimal(parameterIndex);
    }

    @Override
    public Object getObject(String parameterName, Map<String, Class<?>> map) throws SQLException {
        int parameterIndex = this.getParamIndex(parameterName);
        return this.getObject(parameterIndex, map);
    }

    @Override
    public Ref getRef(String parameterName) throws SQLException {
        DBError.throwUnsupportedSQLException();
        return null;
    }

    @Override
    public Blob getBlob(String parameterName) throws SQLException {
        int parameterIndex = this.getParamIndex(parameterName);
        return this.getBlob(parameterIndex);
    }

    @Override
    public Clob getClob(String parameterName) throws SQLException {
        int parameterIndex = this.getParamIndex(parameterName);
        return this.getClob(parameterIndex);
    }

    @Override
    public Array getArray(String parameterName) throws SQLException {
        int parameterIndex = this.getParamIndex(parameterName);
        return this.getArray(parameterIndex);
    }

    @Override
    public Date getDate(String parameterName, Calendar cal) throws SQLException {
        int parameterIndex = this.getParamIndex(parameterName);
        return this.getDate(parameterIndex, cal);
    }

    @Override
    public Time getTime(String parameterName, Calendar cal) throws SQLException {
        int parameterIndex = this.getParamIndex(parameterName);
        return this.getTime(parameterIndex, cal);
    }

    @Override
    public Timestamp getTimestamp(String parameterName, Calendar cal) throws SQLException {
        int parameterIndex = this.getParamIndex(parameterName);
        return this.getTimestamp(parameterIndex, cal);
    }

    @Override
    public URL getURL(String parameterName) throws SQLException {
        int parameterIndex = this.getParamIndex(parameterName);
        return this.getURL(parameterIndex);
    }

    public DmdbIntervalYM getINTERVALYM(int i) throws SQLException {
        this.checkOutParam(i);
        this.wasNullFlag = this.outParamAccessor[i - 1].isWasNull();
        if (this.wasNullFlag) {
            return null;
        }
        return this.outParamAccessor[i - 1].getIntervalYM();
    }

    public DmdbIntervalYM getINTERVALYM(String s) throws SQLException {
        return this.getINTERVALYM(this.getParamIndex(s));
    }

    public DmdbIntervalDT getINTERVALDT(int i) throws SQLException {
        this.checkOutParam(i);
        this.wasNullFlag = this.outParamAccessor[i - 1].isWasNull();
        if (this.wasNullFlag) {
            return null;
        }
        return this.outParamAccessor[i - 1].getIntervalDT();
    }

    public DmdbIntervalDT getINTERVALDT(String s) throws SQLException {
        return this.getINTERVALDT(this.getParamIndex(s));
    }

    public DmdbTimestamp getTIMESTAMP(int i) throws SQLException {
        this.checkOutParam(i);
        this.wasNullFlag = this.outParamAccessor[i - 1].isWasNull();
        if (this.wasNullFlag) {
            return null;
        }
        return this.outParamAccessor[i - 1].getDmdbTimestamp();
    }

    public DmdbTimestamp getTIMESTAMP(String s) throws SQLException {
        int index = this.getParamIndex(s);
        return this.getTIMESTAMP(index);
    }

    public void setTIMESTAMP(String parameterName, DmdbTimestamp t) throws SQLException {
        int[] parameterIndex = this.getParamIndex_forPL(parameterName);
        int i = 0;
        while (i < parameterIndex.length) {
            this.setTIMESTAMP(parameterIndex[i], t);
            ++i;
        }
    }

    public void setINTERVALDT(String parameterName, DmdbIntervalDT dt) throws SQLException {
        int[] parameterIndex = this.getParamIndex_forPL(parameterName);
        int i = 0;
        while (i < parameterIndex.length) {
            this.setINTERVALDT(parameterIndex[i], dt);
            ++i;
        }
    }

    public void setINTERVALYM(String parameterName, DmdbIntervalYM ym) throws SQLException {
        int[] parameterIndex = this.getParamIndex_forPL(parameterName);
        int i = 0;
        while (i < parameterIndex.length) {
            this.setINTERVALYM(parameterIndex[i], ym);
            ++i;
        }
    }

    @Override
    public Reader getCharacterStream(int parameterIndex) throws SQLException {
        this.checkOutParam(parameterIndex);
        this.wasNullFlag = this.outParamAccessor[parameterIndex - 1].isWasNull();
        if (this.wasNullFlag) {
            return null;
        }
        return this.outParamAccessor[parameterIndex - 1].getCharacterStream();
    }

    int getParamIndex(String ParamName) throws SQLException {
        int pCount = -1;
        int i = 0;
        while (i < this.m_paramsDesc.length) {
            if (this.m_paramsDesc[i].getName().equalsIgnoreCase(ParamName)) {
                pCount = i;
                break;
            }
            ++i;
        }
        if (pCount == -1) {
            DBError.throwSQLException(6050);
        }
        return pCount + 1;
    }

    @Override
    public String getPrintMsg() {
        return this.printMsg;
    }

    @Override
    void resetState() throws SQLException {
        super.resetState();
        this.wasNullFlag = false;
    }

    @Override
    public synchronized void close() throws SQLException {
        if (this.closed) {
            return;
        }
        if (this.m_curRow != null && this.m_curRow.length > 0) {
            DmBinder[] dmBinderArray = this.m_curRow;
            int n = this.m_curRow.length;
            int n2 = 0;
            while (n2 < n) {
                DmBinder binder = dmBinderArray[n2];
                if (binder instanceof DmOutParamBinder && binder.getCursorStmt() != null) {
                    try {
                        binder.getCursorStmt().close();
                    }
                    catch (Exception exception) {}
                }
                ++n2;
            }
        }
        this.outParamAccessor = null;
        super.close();
        this.wasNullFlag = false;
    }

    @Override
    protected void setParamsDesc(ParameterDesc[] paramsInfo) throws SQLException {
        super.setParamsDesc(paramsInfo);
    }

    @Override
    protected DmdbInfo preparedExceute(int irow) throws SQLException {
        this.clearOutParamVal();
        DmdbInfo dbInfo = super.preparedExceute(irow);
        if (this.m_curRow != null) {
            int i = 0;
            while (i < this.paramCount) {
                if (this.m_curRow[i] != null && this.m_curRow[i] instanceof DmOutParamBinder) {
                    DmOutParamBinder outBinder = (DmOutParamBinder)this.m_curRow[i];
                    if (this.m_paramsDesc[i].getDType() == 120) {
                        outBinder.getCursorStmt().setExecFromStandby(this.getExecFromStandby());
                    }
                }
                ++i;
            }
        }
        return dbInfo;
    }

    public void clearOutParamVal() throws SQLException {
        if (this.m_curRow != null) {
            int i = 0;
            while (i < this.paramCount) {
                if (this.m_curRow[i] != null && this.m_curRow[i] instanceof DmOutParamBinder) {
                    DmOutParamBinder outBinder = (DmOutParamBinder)this.m_curRow[i];
                    if (outBinder.getCursorStmt() != null) {
                        try {
                            outBinder.getCursorStmt().close();
                        }
                        catch (Exception exception) {}
                        outBinder.setCursorStmt(null);
                    }
                    if (this.m_paramsDesc[i].getDType() == 120) {
                        DmdbStatement_bs stmt = (DmdbStatement_bs)this.connection.createStatement();
                        stmt.setExecFromStandby(this.getExecFromStandby());
                        outBinder.setCursorStmt(stmt);
                    }
                    this.outParamAccessor[i].setOutValue(null);
                    this.outParamAccessor[i].setWasNull(false);
                }
                ++i;
            }
        }
    }

    public BaseAccessor[] getOutParamAccessor() {
        return this.outParamAccessor;
    }

    void checkOutParam(int paramIndex) throws SQLException {
        if (this.m_paramsDesc == null) {
            throw new SQLException(DmSvcConf.res.getString("error.notOutParam"));
        }
        this.checkIndexInner(paramIndex);
        byte ioType = this.m_paramsDesc[paramIndex - 1].getIOType();
        if (ioType != 1 && ioType != 2) {
            throw new SQLException(DmSvcConf.res.getString("error.notOutParam"));
        }
    }

    protected synchronized void OutparamBindPrepare(int paramIndex) throws SQLException {
        this.checkIndexInner(paramIndex);
        int i = paramIndex - 1;
        if (!this.m_isBatchOpt && (this.m_bindIndicator[i] & 0x80) == 128 && this.m_curRow[i] != null && this.m_curRow[i] instanceof DmOutParamBinder) {
            DmBinder inbinder = ((DmOutParamBinder)this.m_curRow[i]).getInoutParamBinder();
            ((DmOutParamBinder)this.m_curRow[i]).close();
            this.m_curRow[i] = new DmOutParamBinder(this);
            this.m_curRow[i].setInoutParamBinder(inbinder);
        }
        int n = i;
        this.m_bindIndicator[n] = (byte)(this.m_bindIndicator[n] | 0x80);
    }

    protected void regOutParam(int paramIndex, int SQLType2) throws SQLException {
        this.checkOutParam(paramIndex);
        this.OutparamBindPrepare(paramIndex);
        DmOutParamBinder outBinder = (DmOutParamBinder)this.m_curRow[paramIndex - 1];
        outBinder.setSqlType(SQLType2);
        this.outParamAccessor[paramIndex - 1].setRegistSqlType(SQLType2);
    }

    protected void regOutParam(int paramIndex, int SQLType2, int sqlScale) throws SQLException {
        this.regOutParam(paramIndex, SQLType2);
        DmOutParamBinder outBinder = (DmOutParamBinder)this.m_curRow[paramIndex - 1];
        outBinder.setSqlScale(sqlScale);
    }

    protected void regOutParam(int paramIndex, int sqlType, String typeName) throws SQLException {
        this.regOutParam(paramIndex, sqlType);
        try {
            if ((sqlType == 2002 || sqlType == 2003 || sqlType == 2000) && StringUtil.isNotEmpty(typeName)) {
                TypeDescriptor desc = new TypeDescriptor(typeName, this.connection);
                desc.parseDescByName();
                DmOutParamBinder outBinder = (DmOutParamBinder)this.m_curRow[paramIndex - 1];
                outBinder.setTypeDesc(desc);
                this.outParamAccessor[paramIndex - 1].setRegistTypeName(typeName);
                this.outParamAccessor[paramIndex - 1].setRegistTypeDescriptor(desc);
            }
        }
        catch (SQLException sQLException) {
            DBError.throwSQLException(DmSvcConf.res.getString("error.invalidDescName"));
        }
    }
}

