/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.driver.DMException;
import dm.jdbc.driver.DmdbXAException;
import dm.jdbc.driver.Resource;
import dm.jdbc.util.ConvertUtil;
import dm.jdbc.util.StringUtil;
import java.io.IOException;
import java.sql.BatchUpdateException;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import javax.sql.rowset.spi.SyncProviderException;

public class DBError {
    protected static final Map fP = new HashMap();
    public static final DBError EC_EMPTY = new DBError(100, "02000", "");
    public static final DBError EC_STR_TRUNC_WARN = new DBError(101, "01000", "");
    public static final DBError EC_JUMP_STMT = new DBError(107, "01000", "");
    public static final DBError EC_RESULT_SET_EMPTY = new DBError(111, "01000", "");
    public static final DBError EC_RANGE_WARNING = new DBError(117, "01000", Resource.get("warning.rangeWarn"));
    public static final DBError EC_LIST_HP_NOT_DEFAULT = new DBError(119, "01000", "");
    public static final DBError EC_BP_WITH_ERROR = new DBError(121, "01000", Resource.get("warning.bp_with_err"));
    public static final DBError EC_OBJ_CREATE_WITH_WARN = new DBError(125, "01000", Resource.get("warning.objCreateWithWarn"));
    public static final DBError EC_SET_CURDB_SUCCESS = new DBError(200, "01000", "");
    public static final DBError EC_SET_TRAN_SUCCESS = new DBError(201, "01000", "");
    public static final DBError EC_EXPLAIN = new DBError(202, "01000", "");
    public static final DBError EC_RN_FIND_SEARCH_EMPTY = new DBError(203, "01000", "");
    public static final DBError EC_EXCEED_SESSION_EXECUTE_LIMIT = new DBError(-604, "", "");
    public static final DBError EC_EXCEED_SESSION_REQUEST_LIMIT = new DBError(-608, "", "");
    public static final DBError EC_PARSE_ERROR = new DBError(-2007, "42000", "");
    public static final DBError EC_COMMENT_IN_PREPARE = new DBError(-2001, "30000", "");
    public static final DBError EC_STMT_TYPE_MISMATCH = new DBError(-2003, "42000", "");
    public static final DBError EC_NOT_SUPPORTED = new DBError(-2004, "30000", "");
    public static final DBError EC_PARSE_ERROR_EXPLAIN = new DBError(-2005, "42000", "");
    public static final DBError EC_RECV_OOB = new DBError(-6007, "08000", "");
    public static final DBError EC_CONNECT_LOST = new DBError(-6010, "08000", "");
    public static final DBError EC_INVALID_DB_NAME = new DBError(-2200, "3D000", "");
    public static final DBError EC_INVALID_ROLE_NAME = new DBError(-2102, "0P000", "");
    public static final DBError EC_INVALID_SCHEMA_NAME = new DBError(-2103, "3F000", "");
    public static final DBError EC_INVALID_SAVEPOINT_NAME = new DBError(-2121, "3B000", "");
    public static final DBError EC_INVALID_CURSOR_NAME = new DBError(-2123, "34000", "");
    public static final DBError EC_INVALID_DB_OBJECT = new DBError(-2201, "3D000", "");
    public static final DBError EC_INVALID_SYSROLE_NAME = new DBError(-2152, "0P000", "");
    public static final DBError EC_UNAUTHORIZED_USER = new DBError(-2512, "28000", "");
    public static final DBError EC_OLD_ROW_REF_ASSGIN_VALUE = new DBError(-3002, "27000", "");
    public static final DBError EC_CHG_NEW_ROW_REF_IN_WRONG_TRG = new DBError(-3003, "27000", "");
    public static final DBError EC_INVALID_TRIGGER_ACTION = new DBError(-3004, "09000", "");
    public static final DBError EC_INVALID_EXPRESSION = new DBError(-3722, "2201B", "");
    public static final DBError EC_NO_INS_PRIVILEGE = new DBError(-5501, "42000", "");
    public static final DBError EC_NO_UNLOCK_LOGIN_PRIVILEGE = new DBError(-5588, "42000", "");
    public static final DBError EC_DATA_LOSE_WARN = new DBError(-6149, "22000", "");
    public static final DBError EC_DATA_CNV_FAIL = new DBError(-6101, "22000", "");
    public static final DBError EC_DATA_OVERFLOW = new DBError(-6102, "22003", Resource.get("error.overflow"));
    public static final DBError EC_DATA_DIV_ZERO = new DBError(-6103, "22012", "");
    public static final DBError EC_DATA_ILLEGAL_CHAR = new DBError(-6104, "22021", "");
    public static final DBError EC_DATATYPE_NOT_MATCH = new DBError(-6105, "22000", "");
    public static final DBError EC_INVALID_ESC_CHAR = new DBError(-6106, "22000", "");
    public static final DBError EC_INVALID_ESC_SEQ = new DBError(-6107, "22019", "");
    public static final DBError EC_STR_TRUNC = new DBError(-6108, "22001", "");
    public static final DBError EC_STR_CAST = new DBError(-6111, "22000", "");
    public static final DBError EC_DATETIME_OVERFLOW = new DBError(-6112, "22008", Resource.get("error.overflow"));
    public static final DBError EC_CAST_LOST_IMFO = new DBError(-6113, "22000", "");
    public static final DBError EC_CAST_LOST_PREC = new DBError(-6114, "22000", "");
    public static final DBError EC_INVALID_INTERVAL = new DBError(-6115, "22007", "");
    public static final DBError EC_INTERVAL_OVERFLOW = new DBError(-6118, "22015", Resource.get("error.overflow"));
    public static final DBError EC_INVALID_DATETIME = new DBError(-6119, "22007", "");
    public static final DBError EC_INVALID_DATA_TYPE = new DBError(-6120, "22000", "");
    public static final DBError EC_PREC_OUT_OF_LENGTH = new DBError(-6122, "22000", "");
    public static final DBError EC_DEC_OUT_OF_LENGTH = new DBError(-6123, "22000", "");
    public static final DBError EC_INVALID_DATE = new DBError(-6124, "22007", "");
    public static final DBError EC_STR_TOO_LONG = new DBError(-6125, "22000", "");
    public static final DBError EC_RN_LOCK_WAIT = new DBError(-6409, "", "");
    public static final DBError EC_RN_SET_TRANS = new DBError(-6510, "25000", "");
    public static final DBError EC_RN_INVALID_SAVEPNT_NAME = new DBError(-6501, "3B001", "");
    public static final DBError EC_RN_OPERATION_CANCELED = new DBError(-6515, "", "");
    public static final DBError EC_READONLY_TRANS = new DBError(-6506, "25006", "");
    public static final DBError EC_RN_DUP_KEY = new DBError(-6612, "23000", "");
    public static final DBError EC_RN_VIOLATE_NOT_NULL_CONSTAINT = new DBError(-6609, "23000", "");
    public static final DBError EC_RN_INVALID_DATA = new DBError(-6801, "22000", "");
    public static final DBError EC_RN_INVALID_CURSOR_STATE = new DBError(-7006, "24000", "");
    public static final DBError EC_RN_INVALID_DB_NAME = new DBError(-7015, "3D000", "");
    public static final DBError EC_RN_INVALID_SCHEMA_NAME = new DBError(-7018, "3F000", "");
    public static final DBError EC_RN_EXCEED_ROWSET_SIZE = new DBError(-7036, "", "");
    public static final DBError EC_RN_STMT_TIMEOUT = new DBError(-7049, "", "");
    public static final DBError EC_EXCEDD_MAX_SESSION_LIMIT = new DBError(-6001, "08000", "");
    public static final DBError EC_EXCEED_MAX_SESSION_PER_USER = new DBError(-6002, "08000", "");
    public static final DBError EC_CONNECT_CAN_NOT_ESTABLISHED = new DBError(-6003, "08004", "");
    public static final DBError ECJDBC_COMMUNITION_ERROR = new DBError(6001, "08S01", Resource.get("error.cumunationError"));
    public static final DBError ECJDBC_MSG_CHECK_ERROR = new DBError(6002, "HY021", Resource.get("error.msgCheckError"));
    public static final DBError ECJDBC_SQL_IS_EMPTY = new DBError(6003, "40003", Resource.get("error.sqlIsNullOrEmpty"));
    public static final DBError ECJDBC_INVALID_TIME_INTERVAL = new DBError(6005, "22007", Resource.get("error.invalidTimeIntervalValue"));
    public static final DBError ECJDBC_UNSUPPORTED_TYPE = new DBError(6006, "HY004", Resource.get("error.unsupportedType"));
    public static final DBError ECJDBC_DATA_CONVERTION_ERROR = new DBError(6007, "HY096", Resource.get("error.dataConvertionError"));
    public static final DBError ECJDBC_READ_ONLY_CONNECTION = new DBError(6008, "01001", Resource.get("error.readOnlyConnection"));
    public static final DBError ECJDBC_INVALID_SQL_TYPE = new DBError(6009, "HY004", Resource.get("error.invalidSqlType"));
    public static final DBError ECJDBC_INVALID_SEQUENCE = new DBError(6010, "HY093", Resource.get("error.invalidSequence"));
    public static final DBError ECJDBC_INVALID_DB_NAME = new DBError(6011, "3D000", Resource.get("error.invalidDbName"));
    public static final DBError ECJDBC_INVALID_DIGITAL_FORMAT = new DBError(6012, "22003", Resource.get("error.invalidDigitalTypeFormat"));
    public static final DBError ECJDBC_INVALID_DATA_FORMAT = new DBError(6013, "22007", Resource.get("error.invalidDateTypeFormat"));
    public static final DBError ECJDBC_INVALID_TIME_FORMAT = new DBError(6014, "22007", Resource.get("error.invalidTimeTypeFormat"));
    public static final DBError ECJDBC_INVALID_DATETIME_FORMAT = new DBError(6015, "22007", Resource.get("error.invalidDateTimeTypeFormat"));
    public static final DBError ECJDBC_INVALID_COLUMN_TYPE = new DBError(6016, "HY004", Resource.get("error.invalidColumnType"));
    public static final DBError ECJDBC_INVALID_COLUMN_NAME = new DBError(6017, "HY111", Resource.get("error.invalidColumnName"));
    public static final DBError ECJDBC_INVALID_BIGDIGITAL_FORMAT = new DBError(6018, "22003", Resource.get("error.invalidBigDecimalTypeFormat"));
    public static final DBError ECJDBC_INVALID_RESULTSET_TYPE = new DBError(6019, "01001", Resource.get("error.invalidResultsetType"));
    public static final DBError ECJDBC_INVALUID_ROW_NUMBER = new DBError(6020, "HY107", Resource.get("error.invalidRowNo"));
    public static final DBError ECJDBC_RESULTSET_EMPTY = new DBError(6021, "HY020", Resource.get("error.emptyResultset"));
    public static final DBError ECJDBC_INVALID_CURSOR_MOVE_DIRECTION = new DBError(6022, "HYC00", Resource.get("error.invalidCursorMoveDirection"));
    public static final DBError ECJDBC_FORWORD_ONLY_RESULTSET = new DBError(6023, "HY024", Resource.get("error.forwardOnlyResultset"));
    public static final DBError ECJDBC_NOT_ALLOW_NULL = new DBError(6024, "HY024", Resource.get("error.notAllowNull"));
    public static final DBError ECJDBC_INVALID_CATALOG = new DBError(6025, "3D000", Resource.get("error.invalidDbName"));
    public static final DBError ECJDBC_RESULTSET_NOT_IN_INSERT_STATUS = new DBError(6026, "01001", Resource.get("error.resultsetNotInInsertStatus"));
    public static final DBError ECJDBC_RESULTSET_IN_INSERT_STATUS = new DBError(6027, "01001", Resource.get("error.resultsetInInsertStatus"));
    public static final DBError ECJDBC_CURSOR_NOT_IN_RESULTSET = new DBError(6028, "01001", Resource.get("error.cursorNotInResultSet"));
    public static final DBError ECJDBC_RESULTSET_IS_READ_ONLY = new DBError(6029, "42000", Resource.get("error.resultsetInReadOnlyStatus"));
    public static final DBError ECJDBC_UNSUPPORTED_INTERFACE = new DBError(6030, "HYC00", Resource.get("error.unsupportedInterfase"));
    public static final DBError ECJDBC_INVALID_SEQUENCE_NUMBER = new DBError(6032, "42S22", Resource.get("error.invalidSequenceNo"));
    public static final DBError ECJDBC_INVALID_RETURN_VALUE = new DBError(6033, "HY024", Resource.get("error.invalidReturnValue"));
    public static final DBError ECJDBC_RESULTSET_CLOSED = new DBError(6034, "08007", Resource.get("error.resultsetClosed"));
    public static final DBError ECJDBC_STATEMENT_HANDLE_CLOSED = new DBError(6035, "08007", Resource.get("error.statementHandleClosed"));
    public static final DBError ECJDBC_INVALID_PARAMETER_VALUE = new DBError(6036, "HY024", Resource.get("error.invalidParameterValue"));
    public static final DBError ECJDBC_INVALID_PARAMETER_DESC = new DBError(6037, "HY024", Resource.get("error.invalidTypeDesc"));
    public static final DBError ECJDBC_INVALID_TRAN_ISOLATION = new DBError(6038, "HYC00", Resource.get("error.invalidTranIsolation"));
    public static final DBError ECJDBC_SAVEPOINT_IN_AUTOCOMMIT_MODE = new DBError(6039, "HY012", Resource.get("error.savepointInAutoCommitMode"));
    public static final DBError ECJDBC_ROLLBACK_TO_SAVEPOINT_IN_AUTOCOMMIT_MODE = new DBError(6040, "HY012", Resource.get("error.rollbackToSavepointInAutoCommitMode"));
    public static final DBError ECJDBC_RELEASE_SAVEPOINT_IN_AUTOCOMMIT_MODE = new DBError(6041, "HY012", Resource.get("error.releaseSavepointInAutoCommitMode"));
    public static final DBError ECJDBC_COMMIT_IN_AUTOCOMMIT_MODE = new DBError(6042, "HY012", Resource.get("error.commitInAutoCommitMode"));
    public static final DBError ECJDBC_ROLLBACK_IN_AUTOCOMMIT_MODE = new DBError(6043, "HY012", Resource.get("error.rollbackInAutoCommitMode"));
    public static final DBError ECJDBC_INVALID_INPUT_PARAMETER_VALUE = new DBError(6044, "21S01", Resource.get("error.invalidInputParameterValue"));
    public static final DBError ECJDBC_INVALID_OUTPUT_PARAMETER_VALUE = new DBError(6045, "21S01", Resource.get("error.invalidOutParameterValue"));
    public static final DBError ECJDBC_CANNOT_GET_SAVEPOINT_ID = new DBError(6046, "42000", Resource.get("error.canNotGetSavepointID"));
    public static final DBError ECJDBC_CANNOT_GET_SAVEPOINT_NAME = new DBError(6047, "42000", Resource.get("error.canNotGetSavepointName"));
    public static final DBError ECJDBC_UNKNOWN_PARAMETER_TYPE = new DBError(6048, "22002", Resource.get("error.unknownParameterType"));
    public static final DBError ECJDBC_INVALID_SCALE = new DBError(6049, "HY104", Resource.get("error.invalidScale"));
    public static final DBError ECJDBC_INVALID_PARAMETER_NAME = new DBError(6050, "HY093", Resource.get("error.invalidParameterName"));
    public static final DBError ECJDBC_INVALID_SAVEPOINT_NAME = new DBError(6051, "HY092", Resource.get("error.invalidSavepointName"));
    public static final DBError ECJDBC_PARAMETER_PREC_TOO_BIG = new DBError(6052, "HY104", Resource.get("error.tooBigParameterPrecsicion"));
    public static final DBError ECJDBC_SAVEPOINT_RELEASED = new DBError(6053, "HY009", Resource.get("error.savepointReleased"));
    public static final DBError ECJDBC_UNBINDED_PARAMETER = new DBError(6054, "21S01", Resource.get("error.unbindedParameter"));
    public static final DBError ECJDBC_INVALID_CURSOR_VALUE = new DBError(6055, "HY024", Resource.get("error.invalidCursorValue"));
    public static final DBError ECJDBC_INVALID_LENGTH_OR_OFFSET = new DBError(6057, "22025", Resource.get("error.invalidLenOrOffset"));
    public static final DBError ECJDBC_CONNECTION_CLOSED = new DBError(6060, "08003", Resource.get("error.connectionClosedOrNotBuild"));
    public static final DBError ECJDBC_NEGOTIATE_FAIL = new DBError(6061, "08003", Resource.get("error.encrypt.negotiate.fail"));
    public static final DBError ECJDBC_KERBEROS_FAIL = new DBError(6062, "08003", Resource.get("error.init.kerberos.fail"));
    public static final DBError ECJDBC_GET_FQDN_FAIL = new DBError(6063, "08003", Resource.get("error.getFQDN.fail"));
    public static final DBError ECJDBC_INVALID_SAVEPOINT = new DBError(6064, "", Resource.get("error.invalidSavepoint"));
    public static final DBError ECJDBC_INVALID_RESULTSET_FIELD = new DBError(6065, "", Resource.get("error.invalidResultSetField"));
    public static final DBError ECJDBC_INTERVAL_OVERFLOW = new DBError(6066, "22015", Resource.get("error.intervalValueOverflow"));
    public static final DBError ECJDBC_STRING_CUT = new DBError(6067, "22001", Resource.get("error.StringCut"));
    public static final DBError ECJDBC_INVALID_HEX = new DBError(6068, "22000", Resource.get("error.invalidHex"));
    public static final DBError ECJDBC_INVALID_CIPHER = new DBError(6069, "", Resource.get("error.invalidCipher"));
    public static final DBError ECJDBC_INVALID_BFILE = new DBError(6070, "", Resource.get("error.invalidBfileStr"));
    public static final DBError ECJDBC_MESSAGE_ENCRYPT_FAIL = new DBError(6071, "", Resource.get("error.cipher.encrypt.fail"));
    public static final DBError ECJDBC_MESSAGE_DECRYPT_FAIL = new DBError(6072, "", Resource.get("error.cipher.decrypt.fail"));
    public static final DBError ECJDBC_OSAUTH_ERROR = new DBError(6073, "", Resource.get("error.osAuthUserConflict"));
    public static final DBError ECJDBC_ERROR_SERVER_VERSION = new DBError(6074, "", Resource.get("error.version.server"));
    public static final DBError ECJDBC_USERNAME_TOO_LONG = new DBError(6075, "", Resource.get("error.usernameTooLong"));
    public static final DBError ECJDBC_PASSWORD_TOO_LONG = new DBError(6076, "", Resource.get("error.passwordtoolong"));
    public static final DBError ECJDBC_UNSUPPORTED_PARAM = new DBError(6077, "", Resource.get("error.unsupportedParam"));
    public static final DBError ECJDBC_STREAM_CLOSED = new DBError(6078, "", Resource.get("error.ClosedStream"));
    public static final DBError ECJDBC_INVALID_COMPLEX_TYPE_NAME = new DBError(6079, "", Resource.get("error.invalidDescName"));
    public static final DBError ECJDBC_STRUCT_MEM_NOT_MATCH = new DBError(6080, "", Resource.get("error.structMemNotMatch"));
    public static final DBError ECJDBC_INVALID_OBJ_BLOB = new DBError(6081, "", Resource.get("error.invalidObjBlob"));
    public static final DBError ECJDBC_INVALID_ARRAY_LEN = new DBError(6081, "", Resource.get("error.invalidLenOfSARR"));
    public static final DBError ECJDBC_NOT_OUT_PARAM = new DBError(6083, "", Resource.get("error.notOutParam"));
    public static final DBError ECJDBC_ROW_SET_NOT_DEL = new DBError(6084, "", Resource.get("error.cachedRowSetCRowNDel"));
    public static final DBError ECJDBC_ROW_SET_NOT_INSERT = new DBError(6085, "", Resource.get("error.cachedRowSetCRowNIns"));
    public static final DBError ECJDBC_ROW_SET_NOT_UPDATE = new DBError(6086, "", Resource.get("error.cachedRowSetCRowNUpd"));
    public static final DBError ECJDBC_ROW_SET_NULL = new DBError(6087, "", Resource.get("error.cachedRowSetNull"));
    public static final DBError ECJDBC_ROW_SET_TO_CLC_FAILED = new DBError(6088, "", Resource.get("error.cachedRowSetToClcFailed"));
    public static final DBError ECJDBC_ROW_SET_TAB_NAME_NULL = new DBError(6089, "", Resource.get("error.cachedRowSetTabNameNull"));
    public static final DBError ECJDBC_ROW_SET_COL_KEY_INVALID = new DBError(6090, "", Resource.get("error.cachedRowSetColKeyInvalid"));
    public static final DBError ECJDBC_ROW_SET_PAGE_SIZE_INVALID = new DBError(6091, "", Resource.get("error.cachedRowSetPageSizeInvalid"));
    public static final DBError ECJDBC_ROW_SET_RS_NOT_OPEN = new DBError(6091, "", Resource.get("error.cachedRowSetRsNotOpen"));
    public static final DBError ECJDBC_INVALID_SERVER_MODE = new DBError(6091, "", Resource.get("error.invalidServerMode"));
    public static final DBError ECJDBC_DATA_TOO_LONG = new DBError(6092, "", Resource.get("error.dataTooLarge"));
    public static final DBError ECJDBC_RW_STANDBY_CONNECT_FAIL = new DBError(6601, "", Resource.get("error.standbyConnectFailed"));
    public static final DBError ECJDBC_RW_INVALID_RS_FROM_STATNDBY = new DBError(6602, "", Resource.get("error.invalidRsFromStandby"));
    public static final DBError ECJDBC_CONNECTION_SWITCHED = new DBError(20000, "", Resource.get("error.SwitchedSused"));
    public static final DBError ECJDBC_CONNECTION_SWITCH_FAILED = new DBError(20001, "", Resource.get("error.SwitchedFailed"));
    public static final DBError ECJDBC_INIT_SSL_FAILED = new DBError(20002, "", Resource.get("error.SSLInitFailed"));
    public static final DBError ECJDBC_LOB_FREED = new DBError(20003, "", Resource.get("error.LobDataHasFreed"));
    public static final DBError ECJDBC_FATAL_ERROR = new DBError(20004, "", Resource.get("error.fatalError"));
    public static final DBError ECJDBC_INVALID_STMT_CALL_TYPE = new DBError(20005, "", Resource.get("error.invalidStmtCall"));
    public static final DBError ECJDBC_PTYPE_NOT_CURSOR = new DBError(20006, "", Resource.get("error.registedNotCursorType"));
    public static final DBError ECJDBC_COLINDEX_SMALLER_ONE = new DBError(20007, "", Resource.get("error.colIndexLowerOne"));
    public static final DBError ECJDBC_COLINDEXES_NULL = new DBError(20008, "", Resource.get("error.colIndexesNull"));
    public static final DBError ECJDBC_COLNAME_EMPTY = new DBError(20009, "", Resource.get("error.colName"));
    public static final DBError ECJDBC_COLNAMES_NULL = new DBError(20010, "", Resource.get("error.colNames"));
    public static final DBError ECJDBC_NOCOLUMNS_SET = new DBError(20011, "", Resource.get("error.nocolumnset"));
    public static final DBError ECJDBC_NOCOLNAMES_SET = new DBError(20012, "", Resource.get("error.nocolnameset"));
    public static final DBError ECJDBC_NOCOLINDEXES_SET = new DBError(20013, "", Resource.get("error.nocolindexset"));
    public static final DBError ECJDBC_COLINDEX_UNSET = new DBError(20014, "", Resource.get("error.colindexunset"));
    public static final DBError ECJDBC_COLNAME_UNSET = new DBError(20015, "", Resource.get("error.colnameunset"));
    public static final DBError ECJDBC_JRST_NOTSUPT_SHOWDELETED = new DBError(20016, "", Resource.get("error.jrstnshowdeleted"));
    public static final DBError ECJDBC_SERIAL_LOB_IOEX = new DBError(20017, "", Resource.get("error.serilobioex"));
    public static final DBError ECJDBC_CONN_URL_ERROR = new DBError(20018, "", Resource.get("error.connurlerror"));
    public static final DBError ECJDBC_COMMAND_NULL = new DBError(20019, "", Resource.get("error.commadNull"));
    public static final DBError ECJDBC_CRS_CURSOR_MOVED = new DBError(20020, "", Resource.get("error.cachedRowSetCursorMoved"));
    public static final DBError ECJDBC_CRS_RESULTSET_NOTSUPT = new DBError(20021, "", Resource.get("error.cachedRowSetRsNotSupt"));
    public static final DBError ECJDBC_CRS_NPREP_PAGING = new DBError(20022, "", "");
    public static final DBError ECJDBC_CRS_NPOPU_FULLY = new DBError(20023, "", Resource.get("error.cachedRowSetRowNpopu"));
    public static final DBError ECJDBC_CRS_STARTROW_NNEG = new DBError(20024, "", Resource.get("error.cachedRowSetStartRowNNeg"));
    public static final DBError ECJDBC_CRS_RS_NULL = new DBError(20025, "", Resource.get("error.cachedRowSetRsNull"));
    public static final DBError ECJDBC_CRS_RS_TFEW_TOSTARTP = new DBError(20026, "", Resource.get("error.cachedRowSetRsTooFew"));
    public static final DBError ECJDBC_CRS_INVALID_ROW_PARAM = new DBError(20029, "", Resource.get("error.cachedRowSetRowParamInvalid"));
    public static final DBError ECJDBC_TABNAME_NULL = new DBError(20027, "", Resource.get("error.tabNameIsNull"));
    public static final DBError ECJDBC_SCHNAME_EMPTYSTRING = new DBError(20028, "", Resource.get("error.schNameIsEmptyString"));
    public static final DBError ECJDBC_WARNING_UNSUPPORT_RESULTSET_TYPE = new DBError(9000, "", Resource.get("warning.notSupportedResultType"));
    public int fQ;
    public String fR;
    public String reason;

    private DBError(int n2, String string, String string2) {
        this.fQ = n2;
        this.fR = string;
        this.reason = string2;
        fP.put(n2, this);
    }

    private static String getSQLState(int n2) {
        String string;
        DBError dBError = (DBError)fP.get(n2);
        String string2 = string = dBError != null ? dBError.fR : "";
        if (StringUtil.isEmpty(string)) {
            string = n2 > 0 && n2 < 1000 ? "01000" : (n2 > -6599 && n2 <= -6501 ? "25000" : (n2 >= -5999 && n2 <= -5500 ? "28000" : (n2 >= -6699 && n2 <= -6601 ? "23000" : "22000")));
        }
        return string;
    }

    public static void throwRuntimeException(String string) {
        throw new RuntimeException(string);
    }

    public static void throwRuntimeException(String string, Throwable throwable) {
        throw new RuntimeException(string, throwable);
    }

    public static void throwException(String string, Throwable throwable) {
        throw new DMException(string, "", 0, throwable);
    }

    public static void throwException(String string, int n2) {
        throw new DMException(string, DBError.getSQLState(n2), n2, null);
    }

    public static void throwException(String string) {
        throw new DMException(string, "", 0, null);
    }

    public static void throwBatchUpdateException(String string, String string2, int n2, long[] lArray) {
        int[] nArray = lArray != null ? new int[lArray.length] : null;
        int n3 = 0;
        while (n3 < nArray.length) {
            nArray[n3] = ConvertUtil.toInt(lArray[n3]);
            ++n3;
        }
        throw new BatchUpdateException(string, string2, n2, nArray);
    }

    public static void throwBatchUpdateException(String string, String string2, int n2, int[] nArray) {
        throw new BatchUpdateException(string, string2, n2, nArray);
    }

    public static void throwIOException(String string) {
        throw new IOException(string);
    }

    public void throwException(String ... stringArray) {
        String string = this.reason;
        if (stringArray != null) {
            try {
                string = new MessageFormat(this.reason).format(stringArray);
            }
            catch (Exception exception) {}
        }
        throw new DMException(string, this.fR, this.fQ, null);
    }

    public void throwException(Throwable throwable) {
        throw new DMException(this.reason, this.fR, this.fQ, throwable);
    }

    public static void main(String[] stringArray) {
        EC_BP_WITH_ERROR.throwException(new String[0]);
    }

    public static void throwXAException(int n2) {
        throw new DmdbXAException(n2);
    }

    public static void throwXAException(SQLException sQLException) {
        throw new DmdbXAException(sQLException.getMessage());
    }

    public static void throwSyncProviderException(SQLException sQLException) {
        throw new SyncProviderException(sQLException.getMessage());
    }
}

