/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial.dialect.dm;

import java.sql.Blob;
import java.sql.Struct;
import org.geolatte.geom.ByteBuffer;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.codec.DmWkb;
import org.geolatte.geom.codec.DmWkt;
import org.geolatte.geom.codec.db.Decoder;

public class DmStructDecoder
implements Decoder<Struct> {
    public Geometry<?> decode(Struct geomObj) {
        if (geomObj == null) {
            return null;
        }
        try {
            if (geomObj instanceof Struct) {
                Object[] objs = geomObj.getAttributes();
                int srid = (Integer)objs[0];
                Blob wkbObj = (Blob)objs[1];
                int type = (Integer)objs[2];
                if (wkbObj == null) {
                    return DmWkt.fromWkt((String)("SRID=" + srid + ";" + this.getEmptyGeomStr(type)));
                }
                byte[] wkb = wkbObj.getBytes(1L, (int)wkbObj.length());
                ByteBuffer buffer = ByteBuffer.from((byte[])wkb);
                return DmWkb.fromWkb(buffer, srid);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Couldn't parse incoming Dameng Spatial data.");
        }
        return null;
    }

    public boolean accepts(Struct struct) {
        return true;
    }

    private String getEmptyGeomStr(int type) {
        switch (type) {
            case 0: {
                return "POINT EMPTY";
            }
            case 1: {
                return "LINESTRING EMPTY";
            }
            case 2: {
                return "LINEARRING EMPTY";
            }
            case 3: {
                return "POLYGON EMPTY";
            }
            case 4: {
                return "MULTIPOINT EMPTY";
            }
            case 5: {
                return "MULTILINESTRING EMPTY";
            }
            case 6: {
                return "MULTIPOLYGON EMPTY";
            }
            case 7: {
                return "GEOMETRYCOLLECTION EMPTY";
            }
        }
        throw new RuntimeException("Couldn't parse incoming Dameng Spatial data.");
    }
}

