/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec;

import org.geolatte.geom.ByteBuffer;
import org.geolatte.geom.ByteOrder;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.Position;
import org.geolatte.geom.codec.BaseWkbVisitor;
import org.geolatte.geom.codec.PostgisWkbV1Dialect;
import org.geolatte.geom.codec.WkbDialect;

public class DmWkbDialect
extends PostgisWkbV1Dialect {
    protected <P extends Position> int calculateSize(Geometry<P> geom, boolean includeSrid) {
        int size = super.calculateSize(geom, includeSrid);
        return includeSrid && geom.getSRID() > 0 ? size - 4 : size;
    }

    protected <P extends Position> BaseWkbVisitor<P> mkVisitor(Geometry<P> geom, ByteOrder bo) {
        return new DmWkbVisitor(this.mkByteBuffer(geom, bo), (WkbDialect)this);
    }

    private static class DmWkbVisitor<P extends Position>
    extends BaseWkbVisitor<P> {
        DmWkbVisitor(ByteBuffer byteBuffer, WkbDialect dialect) {
            super(byteBuffer, dialect);
        }

        protected void writeTypeCodeAndSrid(Geometry<P> geometry, ByteBuffer output) {
            long typeCode = this.dialect().geometryTypeCode(geometry);
            output.putUInt(typeCode);
        }
    }
}

