/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial.dialect.dm;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Struct;
import org.geolatte.geom.Geometry;
import org.hibernate.spatial.dialect.dm.DmJdbcLiteralFormatter;
import org.hibernate.spatial.dialect.dm.DmStructDecoder;
import org.hibernate.spatial.dialect.dm.DmStructEncoder;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.BasicBinder;
import org.hibernate.type.descriptor.jdbc.BasicExtractor;
import org.hibernate.type.descriptor.jdbc.JdbcLiteralFormatter;
import org.hibernate.type.descriptor.jdbc.JdbcType;

public class DmGeometryJdbcType
implements JdbcType {
    public static final DmGeometryJdbcType INSTANCE = new DmGeometryJdbcType();

    public int getJdbcTypeCode() {
        return 2002;
    }

    public int getDefaultSqlTypeCode() {
        return 3200;
    }

    public <X> JdbcLiteralFormatter<X> getJdbcLiteralFormatter(JavaType<X> javaType) {
        return new DmJdbcLiteralFormatter<X>(javaType);
    }

    public <X> ValueBinder<X> getBinder(JavaType<X> javaType) {
        return new BasicBinder<X>(javaType, this){

            protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                st.setObject(index, this.toStruct(value, options, st.getConnection()));
            }

            protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                st.setObject(name, (Object)this.toStruct(value, options, st.getConnection()));
            }

            private Struct toStruct(X value, WrapperOptions options, Connection connection) {
                Geometry geometry = (Geometry)this.getJavaType().unwrap(value, Geometry.class, options);
                DmStructEncoder encoder = new DmStructEncoder();
                Struct encoded = encoder.encode(geometry, connection);
                return encoded;
            }
        };
    }

    public <X> ValueExtractor<X> getExtractor(JavaType<X> javaType) {
        return new BasicExtractor<X>(javaType, this){

            protected X doExtract(ResultSet rs, int paramIndex, WrapperOptions options) throws SQLException {
                return this.getJavaType().wrap(this.toGeometry(rs.getObject(paramIndex)), options);
            }

            protected X doExtract(CallableStatement statement, int index, WrapperOptions options) throws SQLException {
                return this.getJavaType().wrap(this.toGeometry(statement.getObject(index)), options);
            }

            protected X doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
                return this.getJavaType().wrap(this.toGeometry(statement.getObject(name)), options);
            }

            private Geometry<?> toGeometry(Object object) {
                if (object == null) {
                    return null;
                }
                if (object instanceof Struct) {
                    DmStructDecoder decoder = new DmStructDecoder();
                    return decoder.decode((Struct)object);
                }
                throw new IllegalStateException("Object of type " + object.getClass().getCanonicalName() + " not handled by DM as spatial value");
            }
        };
    }
}

