/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.desc;

import dm.jdbc.desc.EP;
import dm.jdbc.desc.EPGroup;
import dm.jdbc.desc.EPGroup$EPSelector$1;
import dm.jdbc.driver.DBError;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.util.StringUtil;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public abstract class EPGroup$EPSelector {
    public static final int TYPE_WELL_DISTRIBUTE = 0;
    public static final int TYPE_HEAD_FIRST = 1;
    public EP[] dbs;
    public int type = -1;

    public EPGroup$EPSelector(int n2) {
        this.type = n2;
    }

    public void select(DmdbConnection dmdbConnection, boolean bl, boolean bl2) {
        this.beforeSelect(bl);
        StringBuilder stringBuilder = new StringBuilder();
        SQLException sQLException = null;
        EP[] ePArray = this.dbs;
        int n2 = this.dbs.length;
        int n3 = 0;
        while (n3 < n2) {
            EP eP = ePArray[n3];
            try {
                eP.connect(dmdbConnection);
                if (!this.checkServerMode(bl2, dmdbConnection)) {
                    dmdbConnection.free();
                    DBError.ECJDBC_INVALID_SERVER_MODE.throwException(new String[0]);
                }
                EPGroup.access$0().debug("try connect success [" + dmdbConnection.host + ":" + dmdbConnection.port + "]");
                return;
            }
            catch (SQLException sQLException2) {
                if (sQLException == null) {
                    sQLException = sQLException2;
                }
                stringBuilder.append("[").append(eP.toString()).append("]").append(sQLException2.getMessage()).append(StringUtil.LINE_SEPARATOR);
                EPGroup.access$0().debug("try connect fail [" + eP.toString() + "] " + sQLException2.getMessage());
                ++n3;
            }
        }
        if (sQLException != null) {
            throw sQLException;
        }
        DBError.throwException(stringBuilder.toString(), DBError.ECJDBC_COMMUNITION_ERROR.errCode);
    }

    public abstract void beforeSelect(boolean var1);

    public EP[] sortEpList(EP[] ePArray, boolean bl) {
        List<EP> list = Arrays.asList(ePArray);
        Collections.sort(list, new EPGroup$EPSelector$1(this, bl));
        return list.toArray(new EP[0]);
    }

    public boolean checkServerMode(boolean bl, DmdbConnection dmdbConnection) {
        if (dmdbConnection.loginDscCtrl && !dmdbConnection.dscControl) {
            dmdbConnection.free();
            DBError.ECJDBC_INVALID_SERVER_MODE.throwException(new String[0]);
        }
        if (dmdbConnection.getLoginStatus() > 0 && dmdbConnection.svrStat != dmdbConnection.getLoginStatus()) {
            dmdbConnection.free();
            DBError.ECJDBC_INVALID_SERVER_MODE.throwException(new String[0]);
        }
        if (bl) {
            switch (dmdbConnection.loginMode) {
                case 1: {
                    return dmdbConnection.svrMode == 1;
                }
                case 2: {
                    return dmdbConnection.svrMode == 2;
                }
            }
            return true;
        }
        switch (dmdbConnection.loginMode) {
            case 4: {
                return dmdbConnection.svrMode == 0;
            }
            case 0: 
            case 1: {
                return dmdbConnection.svrMode == 1;
            }
            case 2: 
            case 3: {
                return dmdbConnection.svrMode == 2;
            }
        }
        return false;
    }
}

