/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.filter.stat;

import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbPreparedStatement;
import dm.jdbc.driver.DmdbResultSet;
import dm.jdbc.driver.DmdbStatement;
import dm.jdbc.enums.ExecuteType;
import dm.jdbc.filter.stat.ConnectionStat;
import dm.jdbc.filter.stat.SqlStat;
import dm.jdbc.filter.stat.util.JSONWriter;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.NClob;
import java.util.Date;

public class StatUtil {
    public static void statementCreateAfter(DmdbConnection dmdbConnection, DmdbStatement dmdbStatement) {
        dmdbStatement.statInfo.setConstructNano();
        dmdbConnection.statInfo.getConnStat().incrementStmt();
    }

    public static void statementExecuteUpdateBefore(DmdbStatement dmdbStatement, String string) {
        dmdbStatement.statInfo.setLastExecuteSql(string);
        dmdbStatement.statInfo.setFirstResultSet(false);
        dmdbStatement.statInfo.setLastExecuteType(ExecuteType.UPDATE);
        StatUtil.internalBeforeStatementExecute(dmdbStatement, string);
    }

    public static void statementExecuteUpdateAfter(DmdbStatement dmdbStatement, String string, int n2) {
        StatUtil.internalAfterStatementExecute(dmdbStatement, n2);
    }

    public static void statementExecuteQueryBefore(DmdbStatement dmdbStatement, String string) {
        dmdbStatement.statInfo.setLastExecuteSql(string);
        dmdbStatement.statInfo.setFirstResultSet(true);
        dmdbStatement.statInfo.setLastExecuteType(ExecuteType.QUERY);
        StatUtil.internalBeforeStatementExecute(dmdbStatement, string);
    }

    public static void statementExecuteQueryAfter(DmdbStatement dmdbStatement, String string, DmdbResultSet dmdbResultSet) {
        if (dmdbResultSet != null) {
            StatUtil.resultSetCreateAfter(dmdbResultSet, dmdbStatement);
        }
        StatUtil.internalAfterStatementExecute(dmdbStatement, new int[0]);
    }

    public static void statementExecuteBefore(DmdbStatement dmdbStatement, String string) {
        dmdbStatement.statInfo.setLastExecuteSql(string);
        dmdbStatement.statInfo.setFirstResultSet(false);
        dmdbStatement.statInfo.setLastExecuteType(ExecuteType.ALL);
        StatUtil.internalBeforeStatementExecute(dmdbStatement, string);
    }

    public static void statementExecuteAfter(DmdbStatement dmdbStatement, String string, boolean bl) {
        dmdbStatement.statInfo.setFirstResultSet(bl);
        StatUtil.internalAfterStatementExecute(dmdbStatement, new int[0]);
    }

    public static void statementExecuteBatchBefore(DmdbStatement dmdbStatement) {
        int n2 = dmdbStatement.batchSqls == null ? 0 : dmdbStatement.batchSqls.size();
        String string = n2 > 0 ? (String)dmdbStatement.batchSqls.get(0) : "";
        SqlStat sqlStat = dmdbStatement.statInfo.getSqlStat();
        if (sqlStat == null || sqlStat.isRemoved() || !sqlStat.getSql().equals(string)) {
            sqlStat = dmdbStatement.connection.statInfo.getConnStat().createSqlStat(string);
            dmdbStatement.statInfo.setSqlStat(sqlStat);
        }
        if (sqlStat != null) {
            sqlStat.addExecuteBatchCount(n2);
        }
        dmdbStatement.statInfo.setLastExecuteSql(string);
        dmdbStatement.statInfo.setFirstResultSet(false);
        dmdbStatement.statInfo.setLastExecuteType(ExecuteType.BATCH);
        StatUtil.internalBeforeStatementExecute(dmdbStatement, string);
    }

    public static void statementExecuteBatchAfter(DmdbStatement dmdbStatement, int[] nArray) {
        StatUtil.internalAfterStatementExecute(dmdbStatement, nArray);
    }

    public static void preparedStatementExecuteBefore(DmdbStatement dmdbStatement) {
        StatUtil.statementExecuteBefore(dmdbStatement, dmdbStatement.nativeSql);
    }

    public static void preparedStatementExecuteAfter(DmdbStatement dmdbStatement, boolean bl) {
        StatUtil.statementExecuteAfter(dmdbStatement, dmdbStatement.nativeSql, bl);
    }

    public static void preparedStatementExecuteUpdateBefore(DmdbStatement dmdbStatement) {
        StatUtil.statementExecuteUpdateBefore(dmdbStatement, dmdbStatement.nativeSql);
    }

    public static void preparedStatementExecuteUpdateAfter(DmdbStatement dmdbStatement, int n2) {
        StatUtil.statementExecuteUpdateAfter(dmdbStatement, dmdbStatement.nativeSql, n2);
    }

    public static void preparedStatementExecuteQueryBefore(DmdbStatement dmdbStatement) {
        StatUtil.statementExecuteQueryBefore(dmdbStatement, dmdbStatement.nativeSql);
    }

    public static void preparedStatementExecuteQueryAfter(DmdbStatement dmdbStatement, DmdbResultSet dmdbResultSet) {
        if (dmdbResultSet != null) {
            StatUtil.resultSetCreateAfter(dmdbResultSet, dmdbStatement);
        }
        StatUtil.internalAfterStatementExecute(dmdbStatement, new int[0]);
    }

    public static void preparedStatementExecuteBatchAfter(DmdbStatement dmdbStatement, int[] nArray) {
        StatUtil.statementExecuteBatchAfter(dmdbStatement, nArray);
    }

    public static void preparedStatementExecuteBatchBefore(DmdbStatement dmdbStatement) {
        StatUtil.statementExecuteBatchBefore(dmdbStatement);
    }

    public static void internalBeforeStatementExecute(DmdbStatement dmdbStatement, String string) {
        ConnectionStat connectionStat = dmdbStatement.connection.statInfo.getConnStat();
        connectionStat.incrementExecuteCount();
        dmdbStatement.statInfo.beforeExecute();
        SqlStat sqlStat = dmdbStatement.statInfo.getSqlStat();
        if (sqlStat == null || sqlStat.isRemoved() || !sqlStat.getSql().equals(string)) {
            sqlStat = connectionStat.createSqlStat(string);
            dmdbStatement.statInfo.setSqlStat(sqlStat);
        }
        boolean bl = false;
        boolean bl2 = bl = !dmdbStatement.connection.do_getAutoCommit();
        if (sqlStat != null) {
            sqlStat.setExecuteLastStartTime(System.currentTimeMillis());
            sqlStat.incrementRunningCount();
            if (bl) {
                sqlStat.incrementInTransactionCount();
            }
        }
    }

    public static void internalAfterStatementExecute(DmdbStatement dmdbStatement, int ... nArray) {
        long l2 = System.nanoTime();
        long l3 = l2 - dmdbStatement.statInfo.getLastExecuteStartNano();
        dmdbStatement.statInfo.afterExecute(l3);
        SqlStat sqlStat = dmdbStatement.statInfo.getSqlStat();
        if (sqlStat != null) {
            sqlStat.incrementExecuteSuccessCount();
            sqlStat.decrementRunningCount();
            String string = "";
            if (dmdbStatement instanceof DmdbPreparedStatement) {
                string = StatUtil.buildSlowParameters((DmdbPreparedStatement)dmdbStatement);
            }
            sqlStat.addExecuteTime(dmdbStatement.statInfo.getLastExecuteType(), dmdbStatement.statInfo.isFirstResultSet(), l3, string);
            if (!dmdbStatement.statInfo.isFirstResultSet() && dmdbStatement.statInfo.getLastExecuteType() == ExecuteType.ALL) {
                int n2 = (int)dmdbStatement.execInfo.updateCount;
                n2 = n2 < 0 ? 0 : n2;
                sqlStat.addUpdateCount(n2);
            } else {
                int[] nArray2 = nArray;
                int n3 = nArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    int n5 = nArray2[n4];
                    sqlStat.addUpdateCount(n5);
                    sqlStat.addFetchRowCount(0L);
                    ++n4;
                }
            }
        }
    }

    public static String buildSlowParameters(DmdbPreparedStatement dmdbPreparedStatement) {
        JSONWriter jSONWriter = new JSONWriter();
        jSONWriter.writeArrayStart();
        int n2 = 0;
        int n3 = dmdbPreparedStatement.paramCount;
        while (n2 < n3) {
            Object object = StatUtil.getParamObject(dmdbPreparedStatement, 0, n2);
            if (n2 != 0) {
                jSONWriter.writeComma();
            }
            if (object == null) {
                jSONWriter.writeNull();
            } else if (object instanceof String) {
                String string = (String)object;
                if (string.length() > 100) {
                    jSONWriter.writeString(String.valueOf(string.substring(0, 97)) + "...");
                } else {
                    jSONWriter.writeString(string);
                }
            } else if (object instanceof Number) {
                jSONWriter.writeObject(object);
            } else if (object instanceof Date) {
                jSONWriter.writeObject(object);
            } else if (object instanceof Boolean) {
                jSONWriter.writeObject(object);
            } else if (object instanceof InputStream) {
                jSONWriter.writeString("<InputStream>");
            } else if (object instanceof NClob) {
                jSONWriter.writeString("<NClob>");
            } else if (object instanceof Clob) {
                jSONWriter.writeString("<Clob>");
            } else if (object instanceof Blob) {
                jSONWriter.writeString("<Blob>");
            } else {
                jSONWriter.writeString(String.valueOf('<') + object.getClass().getName() + '>');
            }
            ++n2;
        }
        jSONWriter.writeArrayEnd();
        return jSONWriter.toString();
    }

    public static void statementExecuteErrorAfter(DmdbStatement dmdbStatement, Throwable throwable) {
        long l2 = System.nanoTime() - dmdbStatement.statInfo.getLastExecuteStartNano();
        dmdbStatement.connection.statInfo.getConnStat().incrementErrorCount();
        dmdbStatement.statInfo.afterExecute(l2);
        SqlStat sqlStat = dmdbStatement.statInfo.getSqlStat();
        if (sqlStat != null) {
            sqlStat.decrementRunningCount();
            sqlStat.error(throwable);
            String string = "";
            if (dmdbStatement instanceof DmdbPreparedStatement) {
                string = StatUtil.buildSlowParameters((DmdbPreparedStatement)dmdbStatement);
            }
            sqlStat.addExecuteTime(dmdbStatement.statInfo.getLastExecuteType(), dmdbStatement.statInfo.isFirstResultSet(), l2, string);
        }
    }

    public static void statementCloseBefore(DmdbStatement dmdbStatement) {
        dmdbStatement.connection.statInfo.getConnStat().decrementStmt();
    }

    public static void resultSetCreateAfter(DmdbResultSet dmdbResultSet, DmdbStatement dmdbStatement) {
        dmdbResultSet.statInfo.setSql(dmdbStatement.statInfo.getLastExecuteSql());
        dmdbResultSet.statInfo.setSqlStat(dmdbStatement.statInfo.getSqlStat());
        dmdbResultSet.statInfo.setConstructNano();
    }

    public static void resultSetCloseBefore(DmdbResultSet dmdbResultSet) {
        long l2 = System.nanoTime() - dmdbResultSet.statInfo.getConstructNano();
        long l3 = StatUtil.getFetchedRows(dmdbResultSet);
        SqlStat sqlStat = dmdbResultSet.statInfo.getSqlStat();
        if (sqlStat != null && dmdbResultSet.statInfo.getCloseCount() == 0) {
            sqlStat.addFetchRowCount(l3);
            long l4 = dmdbResultSet.statInfo.getLastExecuteTimeNano();
            sqlStat.addResultSetHoldTimeNano(l4, l2);
            if (dmdbResultSet.statInfo.getReadStringLength() > 0L) {
                sqlStat.addStringReadLength(dmdbResultSet.statInfo.getReadStringLength());
            }
            if (dmdbResultSet.statInfo.getReadBytesLength() > 0L) {
                sqlStat.addReadBytesLength(dmdbResultSet.statInfo.getReadBytesLength());
            }
            if (dmdbResultSet.statInfo.getOpenInputStreamCount() > 0) {
                sqlStat.addInputStreamOpenCount(dmdbResultSet.statInfo.getOpenInputStreamCount());
            }
            if (dmdbResultSet.statInfo.getOpenReaderCount() > 0) {
                sqlStat.addReaderOpenCount(dmdbResultSet.statInfo.getOpenReaderCount());
            }
        }
        dmdbResultSet.statInfo.incrementCloseCount();
    }

    public static int getActiveStmtCount(DmdbConnection dmdbConnection) {
        return dmdbConnection.activeStmtList == null ? 0 : dmdbConnection.activeStmtList.size();
    }

    public static Object getParamObject(DmdbPreparedStatement dmdbPreparedStatement, int n2, int n3) {
        if (dmdbPreparedStatement.paramObjectsList != null && dmdbPreparedStatement.paramObjectsList.size() > 0) {
            Object[] objectArray = (Object[])dmdbPreparedStatement.paramObjectsList.get(n2);
            return objectArray[n3];
        }
        return dmdbPreparedStatement.curRowObjects[n3];
    }

    public static long getFetchedRows(DmdbResultSet dmdbResultSet) {
        if (dmdbResultSet.currentPos >= dmdbResultSet.totalRowCount) {
            return dmdbResultSet.totalRowCount;
        }
        return dmdbResultSet.currentPos + 1L;
    }
}

