/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.desc;

import dm.jdbc.desc.EP;
import dm.jdbc.desc.EPGroup;
import dm.jdbc.driver.DBError;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.util.StringUtil;
import java.sql.SQLException;

public abstract class EPGroup$EPSelector {
    public static final int TYPE_WELL_DISTRIBUTE = 0;
    public static final int TYPE_HEAD_FIRST = 1;
    public EPGroup group;
    public int type = -1;

    public EPGroup$EPSelector(EPGroup ePGroup, int n2) {
        this.group = ePGroup;
        this.type = n2;
    }

    public abstract EP[] start();

    public abstract void beforeSelect(EP[] var1, boolean var2);

    public void select(EP[] ePArray, DmdbConnection dmdbConnection, boolean bl, boolean bl2) {
        this.beforeSelect(ePArray, bl);
        StringBuilder stringBuilder = new StringBuilder();
        SQLException sQLException = null;
        EP[] ePArray2 = ePArray;
        int n2 = ePArray.length;
        int n3 = 0;
        while (n3 < n2) {
            EP eP = ePArray2[n3];
            try {
                eP.connect(dmdbConnection);
                if (!this.checkServerMode(bl2, dmdbConnection)) {
                    dmdbConnection.free();
                    DBError.ECJDBC_INVALID_SERVER_MODE.throwz(new Object[0]);
                }
                EPGroup.access$0().debug("try connect success [" + dmdbConnection.host + ":" + dmdbConnection.port + "]");
                return;
            }
            catch (SQLException sQLException2) {
                if (sQLException == null) {
                    sQLException = sQLException2;
                }
                stringBuilder.append("[").append(eP.toString()).append("]").append(sQLException2.getMessage()).append(StringUtil.LINE_SEPARATOR);
                EPGroup.access$0().debug("try connect fail [" + eP.toString() + "] " + sQLException2.getMessage());
                ++n3;
            }
        }
        if (sQLException != null) {
            throw sQLException;
        }
        DBError.throwException(stringBuilder.toString(), DBError.ECJDBC_COMMUNITION_ERROR.errCode);
    }

    public boolean checkServerMode(boolean bl, DmdbConnection dmdbConnection) {
        if (this.group.loginDscCtrl && !dmdbConnection.dscControl) {
            dmdbConnection.free();
            DBError.ECJDBC_INVALID_SERVER_MODE.throwz(new Object[0]);
        }
        if (this.group.loginStatus > 0 && dmdbConnection.svrStat != this.group.loginStatus) {
            dmdbConnection.free();
            DBError.ECJDBC_INVALID_SERVER_MODE.throwz(new Object[0]);
        }
        if (bl) {
            switch (this.group.loginMode) {
                case 1: {
                    return dmdbConnection.svrMode == 1;
                }
                case 2: {
                    return dmdbConnection.svrMode == 2;
                }
            }
            return true;
        }
        switch (this.group.loginMode) {
            case 4: {
                return dmdbConnection.svrMode == 0;
            }
            case 0: 
            case 1: {
                return dmdbConnection.svrMode == 1;
            }
            case 2: 
            case 3: {
                return dmdbConnection.svrMode == 2;
            }
        }
        return false;
    }
}

