/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.driver.DBError;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.internal.IDmdbConnection;
import dm.jdbc.util.BEByteUtil;
import dm.jdbc.util.ByteUtil;
import dm.jdbc.util.StringUtil;
import java.sql.DriverManager;
import java.sql.RowId;
import java.sql.SQLException;
import java.util.Arrays;

public class DmdbRowId
implements RowId {
    private static final char[] toBase64 = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    private static final byte[] fromBase64;
    private static final byte BASE64_DECODE_UNDEFINED = 64;
    private static final int BYTE_LEN_OLD = 8;
    private static final int CHAR_LEN = 18;
    private static final int BYTE_LEN_NEW = 12;
    private byte[] value;

    static {
        byte[] byArray = new byte[256];
        byArray[0] = 64;
        byArray[1] = 64;
        byArray[2] = 64;
        byArray[3] = 64;
        byArray[4] = 64;
        byArray[5] = 64;
        byArray[6] = 64;
        byArray[7] = 64;
        byArray[8] = 64;
        byArray[9] = 64;
        byArray[10] = 64;
        byArray[11] = 64;
        byArray[12] = 64;
        byArray[13] = 64;
        byArray[14] = 64;
        byArray[15] = 64;
        byArray[16] = 64;
        byArray[17] = 64;
        byArray[18] = 64;
        byArray[19] = 64;
        byArray[20] = 64;
        byArray[21] = 64;
        byArray[22] = 64;
        byArray[23] = 64;
        byArray[24] = 64;
        byArray[25] = 64;
        byArray[26] = 64;
        byArray[27] = 64;
        byArray[28] = 64;
        byArray[29] = 64;
        byArray[30] = 64;
        byArray[31] = 64;
        byArray[32] = 64;
        byArray[33] = 64;
        byArray[34] = 64;
        byArray[35] = 64;
        byArray[36] = 64;
        byArray[37] = 64;
        byArray[38] = 64;
        byArray[39] = 64;
        byArray[40] = 64;
        byArray[41] = 64;
        byArray[42] = 64;
        byArray[43] = 62;
        byArray[44] = 64;
        byArray[45] = 64;
        byArray[46] = 64;
        byArray[47] = 63;
        byArray[48] = 52;
        byArray[49] = 53;
        byArray[50] = 54;
        byArray[51] = 55;
        byArray[52] = 56;
        byArray[53] = 57;
        byArray[54] = 58;
        byArray[55] = 59;
        byArray[56] = 60;
        byArray[57] = 61;
        byArray[58] = 64;
        byArray[59] = 64;
        byArray[60] = 64;
        byArray[61] = 64;
        byArray[62] = 64;
        byArray[63] = 64;
        byArray[64] = 64;
        byArray[66] = 1;
        byArray[67] = 2;
        byArray[68] = 3;
        byArray[69] = 4;
        byArray[70] = 5;
        byArray[71] = 6;
        byArray[72] = 7;
        byArray[73] = 8;
        byArray[74] = 9;
        byArray[75] = 10;
        byArray[76] = 11;
        byArray[77] = 12;
        byArray[78] = 13;
        byArray[79] = 14;
        byArray[80] = 15;
        byArray[81] = 16;
        byArray[82] = 17;
        byArray[83] = 18;
        byArray[84] = 19;
        byArray[85] = 20;
        byArray[86] = 21;
        byArray[87] = 22;
        byArray[88] = 23;
        byArray[89] = 24;
        byArray[90] = 25;
        byArray[91] = 64;
        byArray[92] = 64;
        byArray[93] = 64;
        byArray[94] = 64;
        byArray[95] = 64;
        byArray[96] = 64;
        byArray[97] = 26;
        byArray[98] = 27;
        byArray[99] = 28;
        byArray[100] = 29;
        byArray[101] = 30;
        byArray[102] = 31;
        byArray[103] = 32;
        byArray[104] = 33;
        byArray[105] = 34;
        byArray[106] = 35;
        byArray[107] = 36;
        byArray[108] = 37;
        byArray[109] = 38;
        byArray[110] = 39;
        byArray[111] = 40;
        byArray[112] = 41;
        byArray[113] = 42;
        byArray[114] = 43;
        byArray[115] = 44;
        byArray[116] = 45;
        byArray[117] = 46;
        byArray[118] = 47;
        byArray[119] = 48;
        byArray[120] = 49;
        byArray[121] = 50;
        byArray[122] = 51;
        byArray[123] = 64;
        byArray[124] = 64;
        byArray[125] = 64;
        byArray[126] = 64;
        byArray[127] = 64;
        byArray[128] = 64;
        byArray[129] = 64;
        byArray[130] = 64;
        byArray[131] = 64;
        byArray[132] = 64;
        byArray[133] = 64;
        byArray[134] = 64;
        byArray[135] = 64;
        byArray[136] = 64;
        byArray[137] = 64;
        byArray[138] = 64;
        byArray[139] = 64;
        byArray[140] = 64;
        byArray[141] = 64;
        byArray[142] = 64;
        byArray[143] = 64;
        byArray[144] = 64;
        byArray[145] = 64;
        byArray[146] = 64;
        byArray[147] = 64;
        byArray[148] = 64;
        byArray[149] = 64;
        byArray[150] = 64;
        byArray[151] = 64;
        byArray[152] = 64;
        byArray[153] = 64;
        byArray[154] = 64;
        byArray[155] = 64;
        byArray[156] = 64;
        byArray[157] = 64;
        byArray[158] = 64;
        byArray[159] = 64;
        byArray[160] = 64;
        byArray[161] = 64;
        byArray[162] = 64;
        byArray[163] = 64;
        byArray[164] = 64;
        byArray[165] = 64;
        byArray[166] = 64;
        byArray[167] = 64;
        byArray[168] = 64;
        byArray[169] = 64;
        byArray[170] = 64;
        byArray[171] = 64;
        byArray[172] = 64;
        byArray[173] = 64;
        byArray[174] = 64;
        byArray[175] = 64;
        byArray[176] = 64;
        byArray[177] = 64;
        byArray[178] = 64;
        byArray[179] = 64;
        byArray[180] = 64;
        byArray[181] = 64;
        byArray[182] = 64;
        byArray[183] = 64;
        byArray[184] = 64;
        byArray[185] = 64;
        byArray[186] = 64;
        byArray[187] = 64;
        byArray[188] = 64;
        byArray[189] = 64;
        byArray[190] = 64;
        byArray[191] = 64;
        byArray[192] = 64;
        byArray[193] = 64;
        byArray[194] = 64;
        byArray[195] = 64;
        byArray[196] = 64;
        byArray[197] = 64;
        byArray[198] = 64;
        byArray[199] = 64;
        byArray[200] = 64;
        byArray[201] = 64;
        byArray[202] = 64;
        byArray[203] = 64;
        byArray[204] = 64;
        byArray[205] = 64;
        byArray[206] = 64;
        byArray[207] = 64;
        byArray[208] = 64;
        byArray[209] = 64;
        byArray[210] = 64;
        byArray[211] = 64;
        byArray[212] = 64;
        byArray[213] = 64;
        byArray[214] = 64;
        byArray[215] = 64;
        byArray[216] = 64;
        byArray[217] = 64;
        byArray[218] = 64;
        byArray[219] = 64;
        byArray[220] = 64;
        byArray[221] = 64;
        byArray[222] = 64;
        byArray[223] = 64;
        byArray[224] = 64;
        byArray[225] = 64;
        byArray[226] = 64;
        byArray[227] = 64;
        byArray[228] = 64;
        byArray[229] = 64;
        byArray[230] = 64;
        byArray[231] = 64;
        byArray[232] = 64;
        byArray[233] = 64;
        byArray[234] = 64;
        byArray[235] = 64;
        byArray[236] = 64;
        byArray[237] = 64;
        byArray[238] = 64;
        byArray[239] = 64;
        byArray[240] = 64;
        byArray[241] = 64;
        byArray[242] = 64;
        byArray[243] = 64;
        byArray[244] = 64;
        byArray[245] = 64;
        byArray[246] = 64;
        byArray[247] = 64;
        byArray[248] = 64;
        byArray[249] = 64;
        byArray[250] = 64;
        byArray[251] = 64;
        byArray[252] = 64;
        byArray[253] = 64;
        byArray[254] = 64;
        byArray[255] = 64;
        fromBase64 = byArray;
    }

    protected DmdbRowId(byte[] bytesValue) throws SQLException {
        this.value = bytesValue;
    }

    public static DmdbRowId valueOf(byte[] bytesValue) throws SQLException {
        if (bytesValue.length != 12 && bytesValue.length != 8) {
            DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz("invalid rowid value: " + Arrays.toString(bytesValue));
        }
        return new DmdbRowId(bytesValue);
    }

    public static DmdbRowId valueOf(String strValue) throws SQLException {
        if (StringUtil.isEmpty(strValue = StringUtil.trimToEmpty(strValue))) {
            return null;
        }
        if (strValue.length() == 18) {
            byte[] bytesValue = DmdbRowId.parse(strValue);
            return new DmdbRowId(bytesValue);
        }
        try {
            long longValue = Long.valueOf(strValue);
            return DmdbRowId.valueOf(longValue);
        }
        catch (Exception exception) {
            DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz("invalid rowid value: " + strValue);
            return null;
        }
    }

    public static DmdbRowId valueOf(long longValue) throws SQLException {
        return new DmdbRowId(ByteUtil.fromLong(longValue));
    }

    @Override
    public byte[] getBytes() {
        return this.value;
    }

    @Override
    public String toString() {
        if (this.value.length == 8) {
            return String.valueOf(ByteUtil.toLong(this.value));
        }
        byte[] src = this.value;
        int srcPos = 0;
        char[] dest = new char[18];
        int destPos = 0;
        byte c1 = 0;
        byte c2 = src[srcPos++];
        byte c3 = src[srcPos++];
        dest[destPos++] = toBase64[0];
        dest[destPos++] = toBase64[(c2 & 0xF0) >> 4];
        dest[destPos++] = toBase64[(c2 & 0xF) << 2 | (c3 & 0xC0) >> 6];
        dest[destPos++] = toBase64[c3 & 0x3F];
        c3 = src[srcPos++];
        dest[destPos++] = toBase64[(c3 & 0xC0) >> 6];
        dest[destPos++] = toBase64[c3 & 0x3F];
        int i2 = 0;
        while (i2 < 3) {
            c1 = src[srcPos++];
            c2 = src[srcPos++];
            c3 = src[srcPos++];
            dest[destPos++] = toBase64[(c1 & 0xFC) >> 2];
            dest[destPos++] = toBase64[(c1 & 3) << 4 | (c2 & 0xF0) >> 4];
            dest[destPos++] = toBase64[(c2 & 0xF) << 2 | (c3 & 0xC0) >> 6];
            dest[destPos++] = toBase64[c3 & 0x3F];
            ++i2;
        }
        return String.valueOf(dest);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DmdbRowId)) {
            return false;
        }
        return Arrays.equals(this.value, ((DmdbRowId)obj).value);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.value);
    }

    public long longValue(IDmdbConnection conn) throws SQLException {
        if (this.value.length == 8) {
            return ByteUtil.toLong(this.value);
        }
        int epno = BEByteUtil.getUB2(this.value, 0);
        long partno = BEByteUtil.getUB4(this.value, 2);
        byte[] realRowidBytes = new byte[8];
        BEByteUtil.getBytes(this.value, 6, realRowidBytes, 2, 6);
        long realRowid = BEByteUtil.toLong(realRowidBytes);
        if (partno > conn.getRowidMaxHpno() || epno > conn.getRowidMaxEpno()) {
            DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
        }
        long longValue = realRowid | (partno & 0xFFFFFFFFFFFFFFFFL) << conn.getRowidNBitsReal();
        if (conn.getRowidNBitsEpno() != 0) {
            longValue |= ((long)epno & 0xFFFFFFFFFFFFFFFFL) << 64 - conn.getRowidNBitsEpno();
        }
        return longValue;
    }

    public byte[] encode(IDmdbConnection conn) throws SQLException {
        if (this.value.length == 12) {
            return this.value;
        }
        long longValue = ByteUtil.toLong(this.value);
        long partno = 0L;
        long realRowid = 0L;
        int epno = (int)(longValue >> 64 - conn.getRowidNBitsEpno() & (long)((1 << conn.getRowidNBitsEpno()) - 1));
        if (epno > conn.getRowidMaxEpno()) {
            DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz("invalid rowid value: " + longValue);
        }
        if (conn.getRowidNBitsReal() == 48) {
            partno = longValue >> 48 & (long)((1 << 16 - conn.getRowidNBitsEpno()) - 1);
            if (partno > conn.getRowidMaxHpno()) {
                DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz("invalid rowid value: " + longValue);
            }
            realRowid = longValue & 0xFFFFFFFFFFFFL;
        } else {
            realRowid = longValue & 0xFFFFFFFFFFFL;
            partno = longValue >> 44 & (long)((1 << 20 - conn.getRowidNBitsEpno()) - 1);
        }
        byte[] bytes = new byte[12];
        BEByteUtil.setUB2(bytes, 0, epno);
        BEByteUtil.setUB4(bytes, 2, partno);
        BEByteUtil.setBytes(bytes, 6, BEByteUtil.fromLong(realRowid), 2, 6);
        return bytes;
    }

    private static byte[] parse(String strValue) throws SQLException {
        byte reserved;
        if (strValue.length() != 18) {
            DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz("invalid rowid value: " + strValue);
        }
        char[] src = strValue.toCharArray();
        int srcPos = 0;
        byte[] dest = new byte[12];
        int destPos = 0;
        byte c0 = fromBase64[src[srcPos++]];
        byte c1 = fromBase64[src[srcPos++]];
        byte c2 = fromBase64[src[srcPos++]];
        byte c3 = fromBase64[src[srcPos++]];
        if (c0 == 64 || c1 == 64 || c2 == 64 || c3 == 64) {
            DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
        }
        if ((reserved = (byte)(c0 << 2 | (c1 & 0x30) >> 4)) != 0) {
            DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
        }
        dest[destPos++] = (byte)(c1 << 4 | (c2 & 0x3C) >> 2);
        dest[destPos++] = (byte)(c2 << 6 | c3);
        c2 = fromBase64[src[srcPos++]];
        c3 = fromBase64[src[srcPos++]];
        if (c2 == 64 || c3 == 64) {
            DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
        }
        if ((reserved = (byte)((c2 & 0x3C) >> 2)) != 0) {
            DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
        }
        dest[destPos++] = (byte)(c2 << 6 | c3);
        int i2 = 0;
        while (i2 < 3) {
            c0 = fromBase64[src[srcPos++]];
            c1 = fromBase64[src[srcPos++]];
            c2 = fromBase64[src[srcPos++]];
            c3 = fromBase64[src[srcPos++]];
            if (c0 == 64 || c1 == 64 || c2 == 64 || c3 == 64) {
                DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
            }
            dest[destPos++] = (byte)(c0 << 2 | (c1 & 0x30) >> 4);
            dest[destPos++] = (byte)(c1 << 4 | (c2 & 0x3C) >> 2);
            dest[destPos++] = (byte)(c2 << 6 | c3);
            ++i2;
        }
        return dest;
    }

    public static void main(String[] args) {
        try {
            Class.forName("dm.jdbc.driver.DmDriver");
            DmdbConnection conn = (DmdbConnection)DriverManager.getConnection("jdbc:dm://localhost:5236", "SYSDBA", "SYSDBA");
            conn.rowidNBitsReal = 44;
            conn.rowidMaxHpno = 1000000L;
            System.out.println(Arrays.toString(DmdbRowId.valueOf(0x4104141041000001L).encode(conn)));
            System.out.println(Arrays.toString(DmdbRowId.valueOf(0x4104141041000001L).getBytes()));
            System.out.println(DmdbRowId.valueOf(0x4104141041000001L).toString());
            System.out.println(DmdbRowId.valueOf("AAAAAABBBBBBBBAAAB").toString());
            System.out.println(Arrays.toString(DmdbRowId.valueOf("AAAAAABBBBBBBBAAAB").getBytes()));
            System.out.println(Arrays.toString(DmdbRowId.valueOf("AAAAAABBBBBBBBAAAB").encode(conn)));
            System.out.println(DmdbRowId.valueOf("AAAAAABBBBBBBBAAAB").longValue(conn));
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }
}

