/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.filter;

import dm.jdbc.driver.DBError;
import dm.jdbc.driver.DmDriver;
import dm.jdbc.driver.DmdbCallableStatement;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbIntervalDT;
import dm.jdbc.driver.DmdbIntervalYM;
import dm.jdbc.driver.DmdbPreparedStatement;
import dm.jdbc.driver.DmdbResultSet;
import dm.jdbc.driver.DmdbStatement;
import dm.jdbc.driver.DmdbTimestamp;
import dm.jdbc.filter.BaseFilter;
import dm.jdbc.internal.conf.DmProperties;
import dm.jdbc.internal.conf.EP;
import dm.jdbc.util.StringUtil;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Map;
import java.util.concurrent.Executor;

public class DscParallelFilter
extends BaseFilter {
    private DscParallelFilter() {
    }

    public static DscParallelFilter getInstance() {
        return new DscParallelFilter();
    }

    private boolean doReconnect(DmdbConnection connection, SQLException e2) throws SQLException {
        if (e2.getErrorCode() != DBError.EC_SWITCH_TO_EP_SEQNO.errCode) {
            throw e2;
        }
        String errMsg = e2.getMessage();
        int idx = errMsg.lastIndexOf("_");
        connection.switchToEpSeqno = Integer.parseInt(StringUtil.trimToEmpty(errMsg.substring(idx + 1)));
        return true;
    }

    private DmdbPreparedStatement getCurrent(DmdbPreparedStatement preparedStatement) {
        return (DmdbPreparedStatement)preparedStatement.tempMap.get(preparedStatement.connection.switchToEpSeqno);
    }

    private DmdbCallableStatement getCurrent(DmdbCallableStatement callableStatement) {
        return (DmdbCallableStatement)callableStatement.tempMap.get(callableStatement.connection.switchToEpSeqno);
    }

    private DmdbStatement getCurrent(DmdbStatement statement) {
        return statement.tempMap.get(statement.connection.switchToEpSeqno);
    }

    private DmdbConnection getCurrent(DmdbConnection connection) {
        return connection.tempMap.get(connection.switchToEpSeqno);
    }

    @Override
    public Connection Driver_connect(DmDriver driver, DmProperties props) throws SQLException {
        final DmdbConnection connection = (DmdbConnection)super.Driver_connect(driver, props);
        if (connection.epGroup == null || connection.epGroup.epList.size() == 0) {
            return connection;
        }
        DscParallelFilter.doTaskParallel(connection.epGroup.epList.toArray(new EP[0]), new BaseFilter.FilterCallback<EP>(){

            @Override
            public void run(EP ep) throws SQLException {
                if (StringUtil.equalsIgnoreCase(ep.host, connection.host) && ep.port == connection.port) {
                    connection.tempMap.put(ep.epSeqno, connection);
                } else {
                    DmdbConnection conn = new DmdbConnection(connection.props);
                    ep.connect(conn);
                    connection.tempMap.put(ep.epSeqno, conn);
                }
            }
        });
        connection.switchToEpSeqno = connection.ep.epSeqno;
        return connection;
    }

    @Override
    public void Connection_close(DmdbConnection connection) throws SQLException {
        DscParallelFilter.doTaskParallel(connection.tempMap.values().toArray(new DmdbConnection[0]), new BaseFilter.FilterCallback<DmdbConnection>(){

            @Override
            public void run(DmdbConnection siteObject) throws SQLException {
                siteObject.do_close();
            }
        });
    }

    @Override
    public void Connection_commit(DmdbConnection connection) throws SQLException {
        DscParallelFilter.doTaskParallel(connection.tempMap.values().toArray(new DmdbConnection[0]), new BaseFilter.FilterCallback<DmdbConnection>(){

            @Override
            public void run(DmdbConnection siteObject) throws SQLException {
                siteObject.do_commit();
            }
        });
    }

    @Override
    public void Connection_rollback(DmdbConnection connection) throws SQLException {
        DscParallelFilter.doTaskParallel(connection.tempMap.values().toArray(new DmdbConnection[0]), new BaseFilter.FilterCallback<DmdbConnection>(){

            @Override
            public void run(DmdbConnection siteObject) throws SQLException {
                siteObject.do_rollback();
            }
        });
    }

    @Override
    public void Connection_setAutoCommit(DmdbConnection connection, final boolean autoCommit) throws SQLException {
        DscParallelFilter.doTaskParallel(connection.tempMap.values().toArray(new DmdbConnection[0]), new BaseFilter.FilterCallback<DmdbConnection>(){

            @Override
            public void run(DmdbConnection siteObject) throws SQLException {
                siteObject.do_setAutoCommit(autoCommit);
            }
        });
    }

    @Override
    public void Connection_setHoldability(DmdbConnection connection, final int holdability) throws SQLException {
        DscParallelFilter.doTaskParallel(connection.tempMap.values().toArray(new DmdbConnection[0]), new BaseFilter.FilterCallback<DmdbConnection>(){

            @Override
            public void run(DmdbConnection siteObject) throws SQLException {
                siteObject.do_setHoldability(holdability);
            }
        });
    }

    @Override
    public void Connection_setReadOnly(DmdbConnection connection, final boolean readOnly) throws SQLException {
        DscParallelFilter.doTaskParallel(connection.tempMap.values().toArray(new DmdbConnection[0]), new BaseFilter.FilterCallback<DmdbConnection>(){

            @Override
            public void run(DmdbConnection siteObject) throws SQLException {
                siteObject.do_setReadOnly(readOnly);
            }
        });
    }

    @Override
    public void Connection_setSchema(DmdbConnection connection, final String schema) throws SQLException {
        DscParallelFilter.doTaskParallel(connection.tempMap.values().toArray(new DmdbConnection[0]), new BaseFilter.FilterCallback<DmdbConnection>(){

            @Override
            public void run(DmdbConnection siteObject) throws SQLException {
                siteObject.do_setSchema(schema);
            }
        });
    }

    @Override
    public void Connection_setTransactionIsolation(DmdbConnection connection, final int level) throws SQLException {
        DscParallelFilter.doTaskParallel(connection.tempMap.values().toArray(new DmdbConnection[0]), new BaseFilter.FilterCallback<DmdbConnection>(){

            @Override
            public void run(DmdbConnection siteObject) throws SQLException {
                siteObject.do_setTransactionIsolation(level);
            }
        });
    }

    @Override
    public void Connection_clearWarnings(DmdbConnection connection) throws SQLException {
        DscParallelFilter.doTaskParallel(connection.tempMap.values().toArray(new DmdbConnection[0]), new BaseFilter.FilterCallback<DmdbConnection>(){

            @Override
            public void run(DmdbConnection siteObject) throws SQLException {
                siteObject.do_clearWarnings();
            }
        });
    }

    @Override
    public void Connection_setTypeMap(DmdbConnection connection, final Map<String, Class<?>> map) throws SQLException {
        DscParallelFilter.doTaskParallel(connection.tempMap.values().toArray(new DmdbConnection[0]), new BaseFilter.FilterCallback<DmdbConnection>(){

            @Override
            public void run(DmdbConnection siteObject) throws SQLException {
                siteObject.do_setTypeMap(map);
            }
        });
    }

    @Override
    public Savepoint Connection_setSavepoint(DmdbConnection connection) throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
        return null;
    }

    @Override
    public Savepoint Connection_setSavepoint(DmdbConnection connection, String name) throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
        return null;
    }

    @Override
    public void Connection_rollback(DmdbConnection connection, Savepoint savepoint) throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
    }

    @Override
    public void Connection_releaseSavepoint(DmdbConnection connection, Savepoint savepoint) throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
    }

    @Override
    public void Connection_setNetworkTimeout(DmdbConnection connection, final Executor executor, final int milliseconds) throws SQLException {
        DscParallelFilter.doTaskParallel(connection.tempMap.values().toArray(new DmdbConnection[0]), new BaseFilter.FilterCallback<DmdbConnection>(){

            @Override
            public void run(DmdbConnection siteObject) throws SQLException {
                siteObject.do_setNetworkTimeout(executor, milliseconds);
            }
        });
    }

    @Override
    public Statement Connection_createStatement(final DmdbConnection connection, final int resultSetType, final int resultSetConcurrency) throws SQLException {
        final DmdbStatement stmt = connection.do_createStatement(resultSetType, resultSetConcurrency);
        DscParallelFilter.doTaskParallel(connection.tempMap.values().toArray(new DmdbConnection[0]), new BaseFilter.FilterCallback<DmdbConnection>(){

            @Override
            public void run(DmdbConnection siteObject) throws SQLException {
                if (siteObject == connection) {
                    stmt.tempMap.put(siteObject.ep.epSeqno, stmt);
                } else {
                    stmt.tempMap.put(siteObject.ep.epSeqno, siteObject.do_createStatement(resultSetType, resultSetConcurrency));
                }
            }
        });
        return stmt;
    }

    @Override
    public Statement Connection_createStatement(final DmdbConnection connection) throws SQLException {
        final DmdbStatement stmt = connection.do_createStatement();
        DscParallelFilter.doTaskParallel(connection.tempMap.values().toArray(new DmdbConnection[0]), new BaseFilter.FilterCallback<DmdbConnection>(){

            @Override
            public void run(DmdbConnection siteObject) throws SQLException {
                if (siteObject == connection) {
                    stmt.tempMap.put(siteObject.ep.epSeqno, stmt);
                } else {
                    stmt.tempMap.put(siteObject.ep.epSeqno, siteObject.do_createStatement());
                }
            }
        });
        return stmt;
    }

    @Override
    public Statement Connection_createStatement(final DmdbConnection connection, final int resultSetType, final int resultSetConcurrency, final int resultSetHoldability) throws SQLException {
        final DmdbStatement stmt = connection.do_createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
        DscParallelFilter.doTaskParallel(connection.tempMap.values().toArray(new DmdbConnection[0]), new BaseFilter.FilterCallback<DmdbConnection>(){

            @Override
            public void run(DmdbConnection siteObject) throws SQLException {
                if (siteObject == connection) {
                    stmt.tempMap.put(siteObject.ep.epSeqno, stmt);
                } else {
                    stmt.tempMap.put(siteObject.ep.epSeqno, siteObject.do_createStatement(resultSetType, resultSetConcurrency, resultSetHoldability));
                }
            }
        });
        return stmt;
    }

    @Override
    public CallableStatement Connection_prepareCall(final DmdbConnection connection, final String sql) throws SQLException {
        final DmdbCallableStatement cstmt = connection.do_prepareCall(sql);
        DscParallelFilter.doTaskParallel(connection.tempMap.values().toArray(new DmdbConnection[0]), new BaseFilter.FilterCallback<DmdbConnection>(){

            @Override
            public void run(DmdbConnection siteObject) throws SQLException {
                if (siteObject == connection) {
                    cstmt.tempMap.put(siteObject.ep.epSeqno, cstmt);
                } else {
                    cstmt.tempMap.put(siteObject.ep.epSeqno, siteObject.do_prepareCall(sql));
                }
            }
        });
        return cstmt;
    }

    @Override
    public CallableStatement Connection_prepareCall(final DmdbConnection connection, final String sql, final int resultSetType, final int resultSetConcurrency, final int resultSetHoldability) throws SQLException {
        final DmdbCallableStatement cstmt = connection.do_prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        DscParallelFilter.doTaskParallel(connection.tempMap.values().toArray(new DmdbConnection[0]), new BaseFilter.FilterCallback<DmdbConnection>(){

            @Override
            public void run(DmdbConnection siteObject) throws SQLException {
                if (siteObject == connection) {
                    cstmt.tempMap.put(siteObject.ep.epSeqno, cstmt);
                } else {
                    cstmt.tempMap.put(siteObject.ep.epSeqno, siteObject.do_prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability));
                }
            }
        });
        return cstmt;
    }

    @Override
    public CallableStatement Connection_prepareCall(final DmdbConnection connection, final String sql, final int resultSetType, final int resultSetConcurrency) throws SQLException {
        final DmdbCallableStatement cstmt = connection.do_prepareCall(sql, resultSetType, resultSetConcurrency);
        DscParallelFilter.doTaskParallel(connection.tempMap.values().toArray(new DmdbConnection[0]), new BaseFilter.FilterCallback<DmdbConnection>(){

            @Override
            public void run(DmdbConnection siteObject) throws SQLException {
                if (siteObject == connection) {
                    cstmt.tempMap.put(siteObject.ep.epSeqno, cstmt);
                } else {
                    cstmt.tempMap.put(siteObject.ep.epSeqno, siteObject.do_prepareCall(sql, resultSetType, resultSetConcurrency));
                }
            }
        });
        return cstmt;
    }

    @Override
    public PreparedStatement Connection_prepareStatement(final DmdbConnection connection, final String sql, final int[] columnIndexes) throws SQLException {
        final DmdbPreparedStatement pstmt = connection.do_prepareStatement(sql, columnIndexes);
        DscParallelFilter.doTaskParallel(connection.tempMap.values().toArray(new DmdbConnection[0]), new BaseFilter.FilterCallback<DmdbConnection>(){

            @Override
            public void run(DmdbConnection siteObject) throws SQLException {
                if (siteObject == connection) {
                    pstmt.tempMap.put(siteObject.ep.epSeqno, pstmt);
                } else {
                    pstmt.tempMap.put(siteObject.ep.epSeqno, siteObject.do_prepareStatement(sql, columnIndexes));
                }
            }
        });
        return pstmt;
    }

    @Override
    public PreparedStatement Connection_prepareStatement(final DmdbConnection connection, final String sql, final String[] columnNames) throws SQLException {
        final DmdbPreparedStatement pstmt = connection.do_prepareStatement(sql, columnNames);
        DscParallelFilter.doTaskParallel(connection.tempMap.values().toArray(new DmdbConnection[0]), new BaseFilter.FilterCallback<DmdbConnection>(){

            @Override
            public void run(DmdbConnection siteObject) throws SQLException {
                if (siteObject == connection) {
                    pstmt.tempMap.put(siteObject.ep.epSeqno, pstmt);
                } else {
                    pstmt.tempMap.put(siteObject.ep.epSeqno, siteObject.do_prepareStatement(sql, columnNames));
                }
            }
        });
        return pstmt;
    }

    @Override
    public PreparedStatement Connection_prepareStatement(final DmdbConnection connection, final String sql) throws SQLException {
        final DmdbPreparedStatement pstmt = connection.do_prepareStatement(sql);
        DscParallelFilter.doTaskParallel(connection.tempMap.values().toArray(new DmdbConnection[0]), new BaseFilter.FilterCallback<DmdbConnection>(){

            @Override
            public void run(DmdbConnection siteObject) throws SQLException {
                if (siteObject == connection) {
                    pstmt.tempMap.put(siteObject.ep.epSeqno, pstmt);
                } else {
                    pstmt.tempMap.put(siteObject.ep.epSeqno, siteObject.do_prepareStatement(sql));
                }
            }
        });
        return pstmt;
    }

    @Override
    public PreparedStatement Connection_prepareStatement(final DmdbConnection connection, final String sql, final int resultSetType, final int resultSetConcurrency) throws SQLException {
        final DmdbPreparedStatement pstmt = connection.do_prepareStatement(sql, resultSetType, resultSetConcurrency);
        DscParallelFilter.doTaskParallel(connection.tempMap.values().toArray(new DmdbConnection[0]), new BaseFilter.FilterCallback<DmdbConnection>(){

            @Override
            public void run(DmdbConnection siteObject) throws SQLException {
                if (siteObject == connection) {
                    pstmt.tempMap.put(siteObject.ep.epSeqno, pstmt);
                } else {
                    pstmt.tempMap.put(siteObject.ep.epSeqno, siteObject.do_prepareStatement(sql, resultSetType, resultSetConcurrency));
                }
            }
        });
        return pstmt;
    }

    @Override
    public PreparedStatement Connection_prepareStatement(final DmdbConnection connection, final String sql, final int resultSetType, final int resultSetConcurrency, final int resultSetHoldability) throws SQLException {
        final DmdbPreparedStatement pstmt = connection.do_prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        DscParallelFilter.doTaskParallel(connection.tempMap.values().toArray(new DmdbConnection[0]), new BaseFilter.FilterCallback<DmdbConnection>(){

            @Override
            public void run(DmdbConnection siteObject) throws SQLException {
                if (siteObject == connection) {
                    pstmt.tempMap.put(siteObject.ep.epSeqno, pstmt);
                } else {
                    pstmt.tempMap.put(siteObject.ep.epSeqno, siteObject.do_prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability));
                }
            }
        });
        return pstmt;
    }

    @Override
    public PreparedStatement Connection_prepareStatement(final DmdbConnection connection, final String sql, final int autoGeneratedKeys) throws SQLException {
        final DmdbPreparedStatement pstmt = connection.do_prepareStatement(sql, autoGeneratedKeys);
        DscParallelFilter.doTaskParallel(connection.tempMap.values().toArray(new DmdbConnection[0]), new BaseFilter.FilterCallback<DmdbConnection>(){

            @Override
            public void run(DmdbConnection siteObject) throws SQLException {
                if (siteObject == connection) {
                    pstmt.tempMap.put(siteObject.ep.epSeqno, pstmt);
                } else {
                    pstmt.tempMap.put(siteObject.ep.epSeqno, siteObject.do_prepareStatement(sql, autoGeneratedKeys));
                }
            }
        });
        return pstmt;
    }

    @Override
    public void PreparedStatement_clearParameters(DmdbPreparedStatement preparedStatement) throws SQLException {
        DscParallelFilter.doTaskParallel(preparedStatement.tempMap.values().toArray(new DmdbPreparedStatement[0]), new BaseFilter.FilterCallback<DmdbPreparedStatement>(){

            @Override
            public void run(DmdbPreparedStatement siteObject) throws SQLException {
                siteObject.do_clearParameters();
            }
        });
    }

    @Override
    public boolean Statement_execute(DmdbStatement statement, String sql) throws SQLException {
        boolean ret;
        block2: {
            ret = false;
            try {
                ret = this.getCurrent(statement).do_execute(sql);
            }
            catch (SQLException e2) {
                if (!this.doReconnect(statement.connection, e2)) break block2;
                ret = this.getCurrent(statement).do_execute(sql);
            }
        }
        return ret;
    }

    @Override
    public boolean Statement_execute(DmdbStatement statement, String sql, int autoGeneratedKeys) throws SQLException {
        boolean ret;
        block2: {
            ret = false;
            try {
                ret = this.getCurrent(statement).do_execute(sql, autoGeneratedKeys);
            }
            catch (SQLException e2) {
                if (!this.doReconnect(statement.connection, e2)) break block2;
                ret = this.getCurrent(statement).do_execute(sql, autoGeneratedKeys);
            }
        }
        return ret;
    }

    @Override
    public boolean Statement_execute(DmdbStatement statement, String sql, int[] columnIndexes) throws SQLException {
        boolean ret;
        block2: {
            ret = false;
            try {
                ret = this.getCurrent(statement).do_execute(sql, columnIndexes);
            }
            catch (SQLException e2) {
                if (!this.doReconnect(statement.connection, e2)) break block2;
                ret = this.getCurrent(statement).do_execute(sql, columnIndexes);
            }
        }
        return ret;
    }

    @Override
    public boolean Statement_execute(DmdbStatement statement, String sql, String[] columnNames) throws SQLException {
        boolean ret;
        block2: {
            ret = false;
            try {
                ret = this.getCurrent(statement).do_execute(sql, columnNames);
            }
            catch (SQLException e2) {
                if (!this.doReconnect(statement.connection, e2)) break block2;
                ret = this.getCurrent(statement).do_execute(sql, columnNames);
            }
        }
        return ret;
    }

    @Override
    public int[] Statement_executeBatch(DmdbStatement statement) throws SQLException {
        int[] ret;
        block2: {
            ret = null;
            try {
                ret = this.getCurrent(statement).do_executeBatch();
            }
            catch (SQLException e2) {
                if (!this.doReconnect(statement.connection, e2)) break block2;
                ret = this.getCurrent(statement).do_executeBatch();
            }
        }
        return ret;
    }

    @Override
    public long[] Statement_executeLargeBatch(DmdbStatement statement) throws SQLException {
        long[] ret;
        block2: {
            ret = null;
            try {
                ret = this.getCurrent(statement).do_executeLargeBatch();
            }
            catch (SQLException e2) {
                if (!this.doReconnect(statement.connection, e2)) break block2;
                ret = this.getCurrent(statement).do_executeLargeBatch();
            }
        }
        return ret;
    }

    @Override
    public long Statement_executeLargeUpdate(DmdbStatement statement, String sql, int autoGeneratedKeys) throws SQLException {
        long ret;
        block2: {
            ret = 0L;
            try {
                ret = this.getCurrent(statement).do_executeLargeUpdate(sql, autoGeneratedKeys);
            }
            catch (SQLException e2) {
                if (!this.doReconnect(statement.connection, e2)) break block2;
                ret = this.getCurrent(statement).do_executeLargeUpdate(sql, autoGeneratedKeys);
            }
        }
        return ret;
    }

    @Override
    public long Statement_executeLargeUpdate(DmdbStatement statement, String sql) throws SQLException {
        long ret;
        block2: {
            ret = 0L;
            try {
                ret = this.getCurrent(statement).do_executeLargeUpdate(sql);
            }
            catch (SQLException e2) {
                if (!this.doReconnect(statement.connection, e2)) break block2;
                ret = this.getCurrent(statement).do_executeLargeUpdate(sql);
            }
        }
        return ret;
    }

    @Override
    public long Statement_executeLargeUpdate(DmdbStatement statement, String sql, int[] columnIndexes) throws SQLException {
        long ret;
        block2: {
            ret = 0L;
            try {
                ret = this.getCurrent(statement).do_executeLargeUpdate(sql, columnIndexes);
            }
            catch (SQLException e2) {
                if (!this.doReconnect(statement.connection, e2)) break block2;
                ret = this.getCurrent(statement).do_executeLargeUpdate(sql, columnIndexes);
            }
        }
        return ret;
    }

    @Override
    public long Statement_executeLargeUpdate(DmdbStatement statement, String sql, String[] columnNames) throws SQLException {
        long ret;
        block2: {
            ret = 0L;
            try {
                ret = this.getCurrent(statement).do_executeLargeUpdate(sql, columnNames);
            }
            catch (SQLException e2) {
                if (!this.doReconnect(statement.connection, e2)) break block2;
                ret = this.getCurrent(statement).do_executeLargeUpdate(sql, columnNames);
            }
        }
        return ret;
    }

    @Override
    public ResultSet Statement_executeQuery(DmdbStatement statement, String sql) throws SQLException {
        DmdbResultSet ret;
        block2: {
            ret = null;
            try {
                ret = this.getCurrent(statement).do_executeQuery(sql);
            }
            catch (SQLException e2) {
                if (!this.doReconnect(statement.connection, e2)) break block2;
                ret = this.getCurrent(statement).do_executeQuery(sql);
            }
        }
        return ret;
    }

    @Override
    public int Statement_executeUpdate(DmdbStatement statement, String sql, int autoGeneratedKeys) throws SQLException {
        int ret;
        block2: {
            ret = 0;
            try {
                ret = this.getCurrent(statement).do_executeUpdate(sql, autoGeneratedKeys);
            }
            catch (SQLException e2) {
                if (!this.doReconnect(statement.connection, e2)) break block2;
                ret = this.getCurrent(statement).do_executeUpdate(sql, autoGeneratedKeys);
            }
        }
        return ret;
    }

    @Override
    public int Statement_executeUpdate(DmdbStatement statement, String sql, String[] columnNames) throws SQLException {
        int ret;
        block2: {
            ret = 0;
            try {
                ret = this.getCurrent(statement).do_executeUpdate(sql, columnNames);
            }
            catch (SQLException e2) {
                if (!this.doReconnect(statement.connection, e2)) break block2;
                ret = this.getCurrent(statement).do_executeUpdate(sql, columnNames);
            }
        }
        return ret;
    }

    @Override
    public int Statement_executeUpdate(DmdbStatement statement, String sql, int[] columnIndexes) throws SQLException {
        int ret;
        block2: {
            ret = 0;
            try {
                ret = this.getCurrent(statement).do_executeUpdate(sql, columnIndexes);
            }
            catch (SQLException e2) {
                if (!this.doReconnect(statement.connection, e2)) break block2;
                ret = this.getCurrent(statement).do_executeUpdate(sql, columnIndexes);
            }
        }
        return ret;
    }

    @Override
    public int Statement_executeUpdate(DmdbStatement statement, String sql) throws SQLException {
        int ret;
        block2: {
            ret = 0;
            try {
                ret = this.getCurrent(statement).do_executeUpdate(sql);
            }
            catch (SQLException e2) {
                if (!this.doReconnect(statement.connection, e2)) break block2;
                ret = this.getCurrent(statement).do_executeUpdate(sql);
            }
        }
        return ret;
    }

    @Override
    public boolean PreparedStatement_execute(DmdbPreparedStatement preparedStatement) throws SQLException {
        boolean ret;
        block2: {
            ret = false;
            try {
                ret = this.getCurrent(preparedStatement).do_execute();
            }
            catch (SQLException e2) {
                if (!this.doReconnect(preparedStatement.connection, e2)) break block2;
                ret = this.getCurrent(preparedStatement).do_execute();
            }
        }
        return ret;
    }

    @Override
    public int[] PreparedStatement_executeBatch(DmdbPreparedStatement preparedStatement) throws SQLException {
        int[] ret;
        block2: {
            ret = null;
            try {
                ret = this.getCurrent(preparedStatement).do_executeBatch();
            }
            catch (SQLException e2) {
                if (!this.doReconnect(preparedStatement.connection, e2)) break block2;
                ret = this.getCurrent(preparedStatement).do_executeBatch();
            }
        }
        return ret;
    }

    @Override
    public long[] PreparedStatement_executeLargeBatch(DmdbPreparedStatement preparedStatement) throws SQLException {
        long[] ret;
        block2: {
            ret = null;
            try {
                ret = this.getCurrent(preparedStatement).do_executeLargeBatch();
            }
            catch (SQLException e2) {
                if (!this.doReconnect(preparedStatement.connection, e2)) break block2;
                ret = this.getCurrent(preparedStatement).do_executeLargeBatch();
            }
        }
        return ret;
    }

    @Override
    public long PreparedStatement_executeLargeUpdate(DmdbPreparedStatement preparedStatement) throws SQLException {
        long ret;
        block2: {
            ret = 0L;
            try {
                ret = this.getCurrent(preparedStatement).do_executeLargeUpdate();
            }
            catch (SQLException e2) {
                if (!this.doReconnect(preparedStatement.connection, e2)) break block2;
                ret = this.getCurrent(preparedStatement).do_executeLargeUpdate();
            }
        }
        return ret;
    }

    @Override
    public ResultSet PreparedStatement_executeQuery(DmdbPreparedStatement preparedStatement) throws SQLException {
        DmdbResultSet ret;
        block2: {
            ret = null;
            try {
                ret = this.getCurrent(preparedStatement).do_executeQuery();
            }
            catch (SQLException e2) {
                if (!this.doReconnect(preparedStatement.connection, e2)) break block2;
                ret = this.getCurrent(preparedStatement).do_executeQuery();
            }
        }
        return ret;
    }

    @Override
    public int PreparedStatement_executeUpdate(DmdbPreparedStatement preparedStatement) throws SQLException {
        int ret;
        block6: {
            ret = 0;
            try {
                ret = this.getCurrent(preparedStatement).do_executeUpdate();
            }
            catch (SQLException e2) {
                if (e2.getErrorCode() == -6111) {
                    System.out.println("Params/execParams: " + Arrays.toString(preparedStatement.serverParameters) + "/" + Arrays.toString(preparedStatement.bindParameters));
                }
                if (!this.doReconnect(preparedStatement.connection, e2)) break block6;
                try {
                    ret = this.getCurrent(preparedStatement).do_executeUpdate();
                }
                catch (SQLException se) {
                    if (se.getErrorCode() == -6111) {
                        System.out.println("reconnect Params/execParams: " + Arrays.toString(preparedStatement.serverParameters) + "/" + Arrays.toString(preparedStatement.bindParameters));
                    }
                    throw se;
                }
            }
        }
        return ret;
    }

    @Override
    public void Statement_close(DmdbStatement statement) throws SQLException {
        DscParallelFilter.doTaskParallel(statement.tempMap.values().toArray(new DmdbStatement[0]), new BaseFilter.FilterCallback<DmdbStatement>(){

            @Override
            public void run(DmdbStatement siteObject) throws SQLException {
                siteObject.do_close();
            }
        });
    }

    @Override
    public void Statement_setCursorName(DmdbStatement statement, final String name) throws SQLException {
        DscParallelFilter.doTaskParallel(statement.tempMap.values().toArray(new DmdbStatement[0]), new BaseFilter.FilterCallback<DmdbStatement>(){

            @Override
            public void run(DmdbStatement siteObject) throws SQLException {
                siteObject.do_setCursorName(name);
            }
        });
    }

    @Override
    public void Statement_setEscapeProcessing(DmdbStatement statement, final boolean enable) throws SQLException {
        DscParallelFilter.doTaskParallel(statement.tempMap.values().toArray(new DmdbStatement[0]), new BaseFilter.FilterCallback<DmdbStatement>(){

            @Override
            public void run(DmdbStatement siteObject) throws SQLException {
                siteObject.do_setEscapeProcessing(enable);
            }
        });
    }

    @Override
    public void Statement_setFetchDirection(DmdbStatement statement, final int direction) throws SQLException {
        DscParallelFilter.doTaskParallel(statement.tempMap.values().toArray(new DmdbStatement[0]), new BaseFilter.FilterCallback<DmdbStatement>(){

            @Override
            public void run(DmdbStatement siteObject) throws SQLException {
                siteObject.do_setFetchDirection(direction);
            }
        });
    }

    @Override
    public void Statement_setFetchSize(DmdbStatement statement, final int rows) throws SQLException {
        DscParallelFilter.doTaskParallel(statement.tempMap.values().toArray(new DmdbStatement[0]), new BaseFilter.FilterCallback<DmdbStatement>(){

            @Override
            public void run(DmdbStatement siteObject) throws SQLException {
                siteObject.do_setFetchSize(rows);
            }
        });
    }

    @Override
    public void Statement_setLargeMaxRows(DmdbStatement statement, final long max) throws SQLException {
        DscParallelFilter.doTaskParallel(statement.tempMap.values().toArray(new DmdbStatement[0]), new BaseFilter.FilterCallback<DmdbStatement>(){

            @Override
            public void run(DmdbStatement siteObject) throws SQLException {
                siteObject.do_setLargeMaxRows(max);
            }
        });
    }

    @Override
    public void Statement_setMaxFieldSize(DmdbStatement statement, final int max) throws SQLException {
        DscParallelFilter.doTaskParallel(statement.tempMap.values().toArray(new DmdbStatement[0]), new BaseFilter.FilterCallback<DmdbStatement>(){

            @Override
            public void run(DmdbStatement siteObject) throws SQLException {
                siteObject.do_setMaxFieldSize(max);
            }
        });
    }

    @Override
    public void Statement_setMaxRows(DmdbStatement statement, final int max) throws SQLException {
        DscParallelFilter.doTaskParallel(statement.tempMap.values().toArray(new DmdbStatement[0]), new BaseFilter.FilterCallback<DmdbStatement>(){

            @Override
            public void run(DmdbStatement siteObject) throws SQLException {
                siteObject.do_setMaxRows(max);
            }
        });
    }

    @Override
    public void Statement_setQueryTimeout(DmdbStatement statement, final int seconds) throws SQLException {
        DscParallelFilter.doTaskParallel(statement.tempMap.values().toArray(new DmdbStatement[0]), new BaseFilter.FilterCallback<DmdbStatement>(){

            @Override
            public void run(DmdbStatement siteObject) throws SQLException {
                siteObject.do_setQueryTimeout(seconds);
            }
        });
    }

    @Override
    public void CallableStatement_registerOutParameter(DmdbCallableStatement callableStatement, int parameterIndex, int sqlType) throws SQLException {
        this.getCurrent(callableStatement).do_registerOutParameter(parameterIndex, sqlType);
    }

    @Override
    public void CallableStatement_registerOutParameter(DmdbCallableStatement callableStatement, int parameterIndex, int sqlType, int scale) throws SQLException {
        this.getCurrent(callableStatement).do_registerOutParameter(parameterIndex, sqlType, scale);
    }

    @Override
    public boolean CallableStatement_wasNull(DmdbCallableStatement callableStatement) throws SQLException {
        return this.getCurrent(callableStatement).do_wasNull();
    }

    @Override
    public String CallableStatement_getString(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return this.getCurrent(callableStatement).do_getString(parameterIndex);
    }

    @Override
    public boolean CallableStatement_getBoolean(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return this.getCurrent(callableStatement).do_getBoolean(parameterIndex);
    }

    @Override
    public byte CallableStatement_getByte(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return this.getCurrent(callableStatement).do_getByte(parameterIndex);
    }

    @Override
    public short CallableStatement_getShort(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return this.getCurrent(callableStatement).do_getShort(parameterIndex);
    }

    @Override
    public int CallableStatement_getInt(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return this.getCurrent(callableStatement).do_getInt(parameterIndex);
    }

    @Override
    public long CallableStatement_getLong(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return this.getCurrent(callableStatement).do_getLong(parameterIndex);
    }

    @Override
    public float CallableStatement_getFloat(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return this.getCurrent(callableStatement).do_getFloat(parameterIndex);
    }

    @Override
    public double CallableStatement_getDouble(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return this.getCurrent(callableStatement).do_getDouble(parameterIndex);
    }

    @Override
    public BigDecimal CallableStatement_getBigDecimal(DmdbCallableStatement callableStatement, int parameterIndex, int scale) throws SQLException {
        return this.getCurrent(callableStatement).do_getBigDecimal(parameterIndex, scale);
    }

    @Override
    public byte[] CallableStatement_getBytes(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return this.getCurrent(callableStatement).do_getBytes(parameterIndex);
    }

    @Override
    public Date CallableStatement_getDate(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return this.getCurrent(callableStatement).do_getDate(parameterIndex);
    }

    @Override
    public Time CallableStatement_getTime(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return this.getCurrent(callableStatement).do_getTime(parameterIndex);
    }

    @Override
    public Timestamp CallableStatement_getTimestamp(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return this.getCurrent(callableStatement).do_getTimestamp(parameterIndex);
    }

    @Override
    public Object CallableStatement_getObject(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return this.getCurrent(callableStatement).do_getObject(parameterIndex);
    }

    @Override
    public BigDecimal CallableStatement_getBigDecimal(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return this.getCurrent(callableStatement).do_getBigDecimal(parameterIndex);
    }

    @Override
    public Object CallableStatement_getObject(DmdbCallableStatement callableStatement, int parameterIndex, Map<String, Class<?>> map) throws SQLException {
        return this.getCurrent(callableStatement).do_getObject(parameterIndex, map);
    }

    @Override
    public Ref CallableStatement_getRef(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return this.getCurrent(callableStatement).do_getRef(parameterIndex);
    }

    @Override
    public Blob CallableStatement_getBlob(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return this.getCurrent(callableStatement).do_getBlob(parameterIndex);
    }

    @Override
    public Clob CallableStatement_getClob(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return this.getCurrent(callableStatement).do_getClob(parameterIndex);
    }

    @Override
    public Array CallableStatement_getArray(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return this.getCurrent(callableStatement).do_getArray(parameterIndex);
    }

    @Override
    public Date CallableStatement_getDate(DmdbCallableStatement callableStatement, int parameterIndex, Calendar cal) throws SQLException {
        return this.getCurrent(callableStatement).do_getDate(parameterIndex, cal);
    }

    @Override
    public Time CallableStatement_getTime(DmdbCallableStatement callableStatement, int parameterIndex, Calendar cal) throws SQLException {
        return this.getCurrent(callableStatement).do_getTime(parameterIndex, cal);
    }

    @Override
    public Timestamp CallableStatement_getTimestamp(DmdbCallableStatement callableStatement, int parameterIndex, Calendar cal) throws SQLException {
        return this.getCurrent(callableStatement).do_getTimestamp(parameterIndex, cal);
    }

    @Override
    public void CallableStatement_registerOutParameter(DmdbCallableStatement callableStatement, int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.getCurrent(callableStatement).do_registerOutParameter(parameterIndex, sqlType, typeName);
    }

    @Override
    public void CallableStatement_registerOutParameter(DmdbCallableStatement callableStatement, String parameterName, int sqlType) throws SQLException {
        this.getCurrent(callableStatement).do_registerOutParameter(parameterName, sqlType);
    }

    @Override
    public void CallableStatement_registerOutParameter(DmdbCallableStatement callableStatement, String parameterName, int sqlType, int scale) throws SQLException {
        this.getCurrent(callableStatement).do_registerOutParameter(parameterName, sqlType, scale);
    }

    @Override
    public void CallableStatement_registerOutParameter(DmdbCallableStatement callableStatement, String parameterName, int sqlType, String typeName) throws SQLException {
        this.getCurrent(callableStatement).do_registerOutParameter(parameterName, sqlType, typeName);
    }

    @Override
    public URL CallableStatement_getURL(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return this.getCurrent(callableStatement).do_getURL(parameterIndex);
    }

    @Override
    public void CallableStatement_setURL(DmdbCallableStatement callableStatement, String parameterName, URL val) throws SQLException {
        this.getCurrent(callableStatement).do_setURL(parameterName, val);
    }

    @Override
    public void CallableStatement_setNull(DmdbCallableStatement callableStatement, String parameterName, int sqlType) throws SQLException {
        this.getCurrent(callableStatement).do_setNull(parameterName, sqlType);
    }

    @Override
    public void CallableStatement_setBoolean(DmdbCallableStatement callableStatement, String parameterName, boolean x2) throws SQLException {
        this.getCurrent(callableStatement).do_setBoolean(parameterName, x2);
    }

    @Override
    public void CallableStatement_setByte(DmdbCallableStatement callableStatement, String parameterName, byte x2) throws SQLException {
        this.getCurrent(callableStatement).do_setByte(parameterName, x2);
    }

    @Override
    public void CallableStatement_setShort(DmdbCallableStatement callableStatement, String parameterName, short x2) throws SQLException {
        this.getCurrent(callableStatement).do_setShort(parameterName, x2);
    }

    @Override
    public void CallableStatement_setInt(DmdbCallableStatement callableStatement, String parameterName, int x2) throws SQLException {
        this.getCurrent(callableStatement).do_setInt(parameterName, x2);
    }

    @Override
    public void CallableStatement_setLong(DmdbCallableStatement callableStatement, String parameterName, long x2) throws SQLException {
        this.getCurrent(callableStatement).do_setLong(parameterName, x2);
    }

    @Override
    public void CallableStatement_setFloat(DmdbCallableStatement callableStatement, String parameterName, float x2) throws SQLException {
        this.getCurrent(callableStatement).do_setFloat(parameterName, x2);
    }

    @Override
    public void CallableStatement_setDouble(DmdbCallableStatement callableStatement, String parameterName, double x2) throws SQLException {
        this.getCurrent(callableStatement).do_setDouble(parameterName, x2);
    }

    @Override
    public void CallableStatement_setBigDecimal(DmdbCallableStatement callableStatement, String parameterName, BigDecimal x2) throws SQLException {
        this.getCurrent(callableStatement).do_setBigDecimal(parameterName, x2);
    }

    @Override
    public void CallableStatement_setString(DmdbCallableStatement callableStatement, String parameterName, String x2) throws SQLException {
        this.getCurrent(callableStatement).do_setString(parameterName, x2);
    }

    @Override
    public void CallableStatement_setBytes(DmdbCallableStatement callableStatement, String parameterName, byte[] x2) throws SQLException {
        this.getCurrent(callableStatement).do_setBytes(parameterName, x2);
    }

    @Override
    public void CallableStatement_setDate(DmdbCallableStatement callableStatement, String parameterName, Date x2) throws SQLException {
        this.getCurrent(callableStatement).do_setDate(parameterName, x2);
    }

    @Override
    public void CallableStatement_setTime(DmdbCallableStatement callableStatement, String parameterName, Time x2) throws SQLException {
        this.getCurrent(callableStatement).do_setTime(parameterName, x2);
    }

    @Override
    public void CallableStatement_setTimestamp(DmdbCallableStatement callableStatement, String parameterName, Timestamp x2) throws SQLException {
        this.getCurrent(callableStatement).do_setTimestamp(parameterName, x2);
    }

    @Override
    public void CallableStatement_setAsciiStream(DmdbCallableStatement callableStatement, String parameterName, InputStream x2, int length) throws SQLException {
        this.getCurrent(callableStatement).do_setAsciiStream(parameterName, x2, length);
    }

    @Override
    public void CallableStatement_setBinaryStream(DmdbCallableStatement callableStatement, String parameterName, InputStream x2, int length) throws SQLException {
        this.getCurrent(callableStatement).do_setBinaryStream(parameterName, x2, length);
    }

    @Override
    public void CallableStatement_setObject(DmdbCallableStatement callableStatement, String parameterName, Object x2, int targetSqlType, int scale) throws SQLException {
        this.getCurrent(callableStatement).do_setObject(parameterName, x2, targetSqlType, scale);
    }

    @Override
    public void CallableStatement_setObject(DmdbCallableStatement callableStatement, String parameterName, Object x2, int targetSqlType) throws SQLException {
        this.getCurrent(callableStatement).do_setObject(parameterName, x2, targetSqlType);
    }

    @Override
    public void CallableStatement_setObject(DmdbCallableStatement callableStatement, String parameterName, Object x2) throws SQLException {
        this.getCurrent(callableStatement).do_setObject(parameterName, x2);
    }

    @Override
    public void CallableStatement_setCharacterStream(DmdbCallableStatement callableStatement, String parameterName, Reader reader, int length) throws SQLException {
        this.getCurrent(callableStatement).do_setCharacterStream(parameterName, reader, length);
    }

    @Override
    public void CallableStatement_setDate(DmdbCallableStatement callableStatement, String parameterName, Date x2, Calendar cal) throws SQLException {
        this.getCurrent(callableStatement).do_setDate(parameterName, x2, cal);
    }

    @Override
    public void CallableStatement_setTime(DmdbCallableStatement callableStatement, String parameterName, Time x2, Calendar cal) throws SQLException {
        this.getCurrent(callableStatement).do_setTime(parameterName, x2, cal);
    }

    @Override
    public void CallableStatement_setTimestamp(DmdbCallableStatement callableStatement, String parameterName, Timestamp x2, Calendar cal) throws SQLException {
        this.getCurrent(callableStatement).do_setTimestamp(parameterName, x2, cal);
    }

    @Override
    public void CallableStatement_setNull(DmdbCallableStatement callableStatement, String parameterName, int sqlType, String typeName) throws SQLException {
        this.getCurrent(callableStatement).do_setNull(parameterName, sqlType, typeName);
    }

    @Override
    public String CallableStatement_getString(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return this.getCurrent(callableStatement).do_getString(parameterName);
    }

    @Override
    public boolean CallableStatement_getBoolean(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return this.getCurrent(callableStatement).do_getBoolean(parameterName);
    }

    @Override
    public byte CallableStatement_getByte(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return this.getCurrent(callableStatement).do_getByte(parameterName);
    }

    @Override
    public short CallableStatement_getShort(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return this.getCurrent(callableStatement).do_getShort(parameterName);
    }

    @Override
    public int CallableStatement_getInt(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return this.getCurrent(callableStatement).do_getInt(parameterName);
    }

    @Override
    public long CallableStatement_getLong(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return this.getCurrent(callableStatement).do_getLong(parameterName);
    }

    @Override
    public float CallableStatement_getFloat(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return this.getCurrent(callableStatement).do_getFloat(parameterName);
    }

    @Override
    public double CallableStatement_getDouble(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return this.getCurrent(callableStatement).do_getDouble(parameterName);
    }

    @Override
    public byte[] CallableStatement_getBytes(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return this.getCurrent(callableStatement).do_getBytes(parameterName);
    }

    @Override
    public Date CallableStatement_getDate(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return this.getCurrent(callableStatement).do_getDate(parameterName);
    }

    @Override
    public Time CallableStatement_getTime(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return this.getCurrent(callableStatement).do_getTime(parameterName);
    }

    @Override
    public Timestamp CallableStatement_getTimestamp(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return this.getCurrent(callableStatement).do_getTimestamp(parameterName);
    }

    @Override
    public Object CallableStatement_getObject(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return this.getCurrent(callableStatement).do_getObject(parameterName);
    }

    @Override
    public BigDecimal CallableStatement_getBigDecimal(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return this.getCurrent(callableStatement).do_getBigDecimal(parameterName);
    }

    @Override
    public Object CallableStatement_getObject(DmdbCallableStatement callableStatement, String parameterName, Map<String, Class<?>> map) throws SQLException {
        return this.getCurrent(callableStatement).do_getObject(parameterName, map);
    }

    @Override
    public Ref CallableStatement_getRef(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return this.getCurrent(callableStatement).do_getRef(parameterName);
    }

    @Override
    public Blob CallableStatement_getBlob(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return this.getCurrent(callableStatement).do_getBlob(parameterName);
    }

    @Override
    public Clob CallableStatement_getClob(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return this.getCurrent(callableStatement).do_getClob(parameterName);
    }

    @Override
    public Array CallableStatement_getArray(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return this.getCurrent(callableStatement).do_getArray(parameterName);
    }

    @Override
    public Date CallableStatement_getDate(DmdbCallableStatement callableStatement, String parameterName, Calendar cal) throws SQLException {
        return this.getCurrent(callableStatement).do_getDate(parameterName, cal);
    }

    @Override
    public Time CallableStatement_getTime(DmdbCallableStatement callableStatement, String parameterName, Calendar cal) throws SQLException {
        return this.getCurrent(callableStatement).do_getTime(parameterName, cal);
    }

    @Override
    public Timestamp CallableStatement_getTimestamp(DmdbCallableStatement callableStatement, String parameterName, Calendar cal) throws SQLException {
        return this.getCurrent(callableStatement).do_getTimestamp(parameterName, cal);
    }

    @Override
    public URL CallableStatement_getURL(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return this.getCurrent(callableStatement).do_getURL(parameterName);
    }

    @Override
    public RowId CallableStatement_getRowId(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return this.getCurrent(callableStatement).do_getRowId(parameterIndex);
    }

    @Override
    public RowId CallableStatement_getRowId(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return this.getCurrent(callableStatement).do_getRowId(parameterName);
    }

    @Override
    public void CallableStatement_setRowId(DmdbCallableStatement callableStatement, String parameterName, RowId x2) throws SQLException {
        this.getCurrent(callableStatement).do_setRowId(parameterName, x2);
    }

    @Override
    public void CallableStatement_setNString(DmdbCallableStatement callableStatement, String parameterName, String value) throws SQLException {
        this.getCurrent(callableStatement).do_setNString(parameterName, value);
    }

    @Override
    public void CallableStatement_setNCharacterStream(DmdbCallableStatement callableStatement, String parameterName, Reader value, long length) throws SQLException {
        this.getCurrent(callableStatement).do_setNCharacterStream(parameterName, value, length);
    }

    @Override
    public void CallableStatement_setNClob(DmdbCallableStatement callableStatement, String parameterName, NClob value) throws SQLException {
        this.getCurrent(callableStatement).do_setNClob(parameterName, value);
    }

    @Override
    public void CallableStatement_setClob(DmdbCallableStatement callableStatement, String parameterName, Reader reader, long length) throws SQLException {
        this.getCurrent(callableStatement).do_setClob(parameterName, reader, length);
    }

    @Override
    public void CallableStatement_setBlob(DmdbCallableStatement callableStatement, String parameterName, InputStream inputStream, long length) throws SQLException {
        this.getCurrent(callableStatement).do_setBlob(parameterName, inputStream, length);
    }

    @Override
    public void CallableStatement_setNClob(DmdbCallableStatement callableStatement, String parameterName, Reader reader, long length) throws SQLException {
        this.getCurrent(callableStatement).do_setNClob(parameterName, reader, length);
    }

    @Override
    public NClob CallableStatement_getNClob(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return this.getCurrent(callableStatement).do_getNClob(parameterIndex);
    }

    @Override
    public NClob CallableStatement_getNClob(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return this.getCurrent(callableStatement).do_getNClob(parameterName);
    }

    @Override
    public void CallableStatement_setSQLXML(DmdbCallableStatement callableStatement, String parameterName, SQLXML xmlObject) throws SQLException {
        this.getCurrent(callableStatement).do_setSQLXML(parameterName, xmlObject);
    }

    @Override
    public SQLXML CallableStatement_getSQLXML(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return this.getCurrent(callableStatement).do_getSQLXML(parameterIndex);
    }

    @Override
    public SQLXML CallableStatement_getSQLXML(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return this.getCurrent(callableStatement).do_getSQLXML(parameterName);
    }

    @Override
    public String CallableStatement_getNString(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return this.getCurrent(callableStatement).do_getNString(parameterIndex);
    }

    @Override
    public String CallableStatement_getNString(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return this.getCurrent(callableStatement).do_getNString(parameterName);
    }

    @Override
    public Reader CallableStatement_getNCharacterStream(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return this.getCurrent(callableStatement).do_getNCharacterStream(parameterIndex);
    }

    @Override
    public Reader CallableStatement_getNCharacterStream(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return this.getCurrent(callableStatement).do_getNCharacterStream(parameterName);
    }

    @Override
    public Reader CallableStatement_getCharacterStream(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return this.getCurrent(callableStatement).do_getCharacterStream(parameterIndex);
    }

    @Override
    public Reader CallableStatement_getCharacterStream(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return this.getCurrent(callableStatement).do_getCharacterStream(parameterName);
    }

    @Override
    public void CallableStatement_setBlob(DmdbCallableStatement callableStatement, String parameterName, Blob x2) throws SQLException {
        this.getCurrent(callableStatement).do_setBlob(parameterName, x2);
    }

    @Override
    public void CallableStatement_setClob(DmdbCallableStatement callableStatement, String parameterName, Clob x2) throws SQLException {
        this.getCurrent(callableStatement).do_setClob(parameterName, x2);
    }

    @Override
    public void CallableStatement_setAsciiStream(DmdbCallableStatement callableStatement, String parameterName, InputStream x2, long length) throws SQLException {
        this.getCurrent(callableStatement).do_setAsciiStream(parameterName, x2, length);
    }

    @Override
    public void CallableStatement_setBinaryStream(DmdbCallableStatement callableStatement, String parameterName, InputStream x2, long length) throws SQLException {
        this.getCurrent(callableStatement).do_setBinaryStream(parameterName, x2, length);
    }

    @Override
    public void CallableStatement_setCharacterStream(DmdbCallableStatement callableStatement, String parameterName, Reader reader, long length) throws SQLException {
        this.getCurrent(callableStatement).do_setCharacterStream(parameterName, reader, length);
    }

    @Override
    public void CallableStatement_setAsciiStream(DmdbCallableStatement callableStatement, String parameterName, InputStream x2) throws SQLException {
        this.getCurrent(callableStatement).do_setAsciiStream(parameterName, x2);
    }

    @Override
    public void CallableStatement_setBinaryStream(DmdbCallableStatement callableStatement, String parameterName, InputStream x2) throws SQLException {
        this.getCurrent(callableStatement).do_setBinaryStream(parameterName, x2);
    }

    @Override
    public void CallableStatement_setCharacterStream(DmdbCallableStatement callableStatement, String parameterName, Reader reader) throws SQLException {
        this.getCurrent(callableStatement).do_setCharacterStream(parameterName, reader);
    }

    @Override
    public void CallableStatement_setNCharacterStream(DmdbCallableStatement callableStatement, String parameterName, Reader value) throws SQLException {
        this.getCurrent(callableStatement).do_setNCharacterStream(parameterName, value);
    }

    @Override
    public void CallableStatement_setClob(DmdbCallableStatement callableStatement, String parameterName, Reader reader) throws SQLException {
        this.getCurrent(callableStatement).do_setClob(parameterName, reader);
    }

    @Override
    public void CallableStatement_setBlob(DmdbCallableStatement callableStatement, String parameterName, InputStream inputStream) throws SQLException {
        this.getCurrent(callableStatement).do_setBlob(parameterName, inputStream);
    }

    @Override
    public void CallableStatement_setNClob(DmdbCallableStatement callableStatement, String parameterName, Reader reader) throws SQLException {
        this.getCurrent(callableStatement).do_setNClob(parameterName, reader);
    }

    @Override
    public <T> T CallableStatement_getObject(DmdbCallableStatement callableStatement, int parameterIndex, Class<T> type) throws SQLException {
        return this.getCurrent(callableStatement).do_getObject(parameterIndex, type);
    }

    @Override
    public <T> T CallableStatement_getObject(DmdbCallableStatement callableStatement, String parameterName, Class<T> type) throws SQLException {
        return this.getCurrent(callableStatement).do_getObject(parameterName, type);
    }

    @Override
    public void CallableStatement_setObject(DmdbCallableStatement callableStatement, String parameterName, Object x2, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        this.getCurrent(callableStatement).do_setObject(parameterName, x2, targetSqlType, scaleOrLength);
    }

    @Override
    public void CallableStatement_setObject(DmdbCallableStatement callableStatement, String parameterName, Object x2, SQLType targetSqlType) throws SQLException {
        this.getCurrent(callableStatement).do_setObject(parameterName, x2, targetSqlType);
    }

    @Override
    public void CallableStatement_registerOutParameter(DmdbCallableStatement callableStatement, int parameterIndex, SQLType sqlType) throws SQLException {
        this.getCurrent(callableStatement).do_registerOutParameter(parameterIndex, sqlType);
    }

    @Override
    public void CallableStatement_registerOutParameter(DmdbCallableStatement callableStatement, int parameterIndex, SQLType sqlType, int scale) throws SQLException {
        this.getCurrent(callableStatement).do_registerOutParameter(parameterIndex, sqlType, scale);
    }

    @Override
    public void CallableStatement_registerOutParameter(DmdbCallableStatement callableStatement, int parameterIndex, SQLType sqlType, String typeName) throws SQLException {
        this.getCurrent(callableStatement).do_registerOutParameter(parameterIndex, sqlType, typeName);
    }

    @Override
    public void CallableStatement_registerOutParameter(DmdbCallableStatement callableStatement, String parameterName, SQLType sqlType) throws SQLException {
        this.getCurrent(callableStatement).do_registerOutParameter(parameterName, sqlType);
    }

    @Override
    public void CallableStatement_registerOutParameter(DmdbCallableStatement callableStatement, String parameterName, SQLType sqlType, int scale) throws SQLException {
        this.getCurrent(callableStatement).do_registerOutParameter(parameterName, sqlType, scale);
    }

    @Override
    public void CallableStatement_registerOutParameter(DmdbCallableStatement callableStatement, String parameterName, SQLType sqlType, String typeName) throws SQLException {
        this.getCurrent(callableStatement).do_registerOutParameter(parameterName, sqlType, typeName);
    }

    @Override
    public DmdbIntervalYM CallableStatement_getINTERVALYM(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return this.getCurrent(callableStatement).do_getINTERVALYM(parameterIndex);
    }

    @Override
    public DmdbIntervalDT CallableStatement_getINTERVALDT(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return this.getCurrent(callableStatement).do_getINTERVALDT(parameterIndex);
    }

    @Override
    public DmdbTimestamp CallableStatement_getTIMESTAMP(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return this.getCurrent(callableStatement).do_getTIMESTAMP(parameterIndex);
    }

    @Override
    public ResultSet CallableStatement_getCursor(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return this.getCurrent(callableStatement).do_getCursor(parameterIndex);
    }

    @Override
    public SQLWarning Connection_getWarnings(DmdbConnection connection) throws SQLException {
        return this.getCurrent(connection).do_getWarnings();
    }

    @Override
    public void Connection_abort(DmdbConnection connection, Executor executor) throws SQLException {
        this.getCurrent(connection).do_abort(executor);
    }

    @Override
    public void Connection_reset(DmdbConnection connection) throws SQLException {
        this.getCurrent(connection).do_reset();
    }

    @Override
    public void PreparedStatement_setNull(DmdbPreparedStatement preparedStatement, int parameterIndex, int sqlType) throws SQLException {
        this.getCurrent(preparedStatement).do_setNull(parameterIndex, sqlType);
    }

    @Override
    public void PreparedStatement_setBoolean(DmdbPreparedStatement preparedStatement, int parameterIndex, boolean x2) throws SQLException {
        this.getCurrent(preparedStatement).do_setBoolean(parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setByte(DmdbPreparedStatement preparedStatement, int parameterIndex, byte x2) throws SQLException {
        this.getCurrent(preparedStatement).do_setByte(parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setShort(DmdbPreparedStatement preparedStatement, int parameterIndex, short x2) throws SQLException {
        this.getCurrent(preparedStatement).do_setShort(parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setInt(DmdbPreparedStatement preparedStatement, int parameterIndex, int x2) throws SQLException {
        this.getCurrent(preparedStatement).do_setInt(parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setLong(DmdbPreparedStatement preparedStatement, int parameterIndex, long x2) throws SQLException {
        this.getCurrent(preparedStatement).do_setLong(parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setFloat(DmdbPreparedStatement preparedStatement, int parameterIndex, float x2) throws SQLException {
        this.getCurrent(preparedStatement).do_setFloat(parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setDouble(DmdbPreparedStatement preparedStatement, int parameterIndex, double x2) throws SQLException {
        this.getCurrent(preparedStatement).do_setDouble(parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setBigDecimal(DmdbPreparedStatement preparedStatement, int parameterIndex, BigDecimal x2) throws SQLException {
        this.getCurrent(preparedStatement).do_setBigDecimal(parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setString(DmdbPreparedStatement preparedStatement, int parameterIndex, String x2) throws SQLException {
        this.getCurrent(preparedStatement).do_setString(parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setBytes(DmdbPreparedStatement preparedStatement, int parameterIndex, byte[] x2) throws SQLException {
        this.getCurrent(preparedStatement).do_setBytes(parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setDate(DmdbPreparedStatement preparedStatement, int parameterIndex, Date x2) throws SQLException {
        this.getCurrent(preparedStatement).do_setDate(parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setTime(DmdbPreparedStatement preparedStatement, int parameterIndex, Time x2) throws SQLException {
        this.getCurrent(preparedStatement).do_setTime(parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setTimestamp(DmdbPreparedStatement preparedStatement, int parameterIndex, Timestamp x2) throws SQLException {
        this.getCurrent(preparedStatement).do_setTimestamp(parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setAsciiStream(DmdbPreparedStatement preparedStatement, int parameterIndex, InputStream x2, int length) throws SQLException {
        this.getCurrent(preparedStatement).do_setAsciiStream(parameterIndex, x2, length);
    }

    @Override
    public void PreparedStatement_setUnicodeStream(DmdbPreparedStatement preparedStatement, int parameterIndex, InputStream x2, int length) throws SQLException {
        this.getCurrent(preparedStatement).do_setUnicodeStream(parameterIndex, x2, length);
    }

    @Override
    public void PreparedStatement_setBinaryStream(DmdbPreparedStatement preparedStatement, int parameterIndex, InputStream x2, int length) throws SQLException {
        this.getCurrent(preparedStatement).do_setBinaryStream(parameterIndex, x2, length);
    }

    @Override
    public void PreparedStatement_setObject(DmdbPreparedStatement preparedStatement, int parameterIndex, Object x2, int targetSqlType) throws SQLException {
        this.getCurrent(preparedStatement).do_setObject(parameterIndex, x2, targetSqlType);
    }

    @Override
    public void PreparedStatement_setObject(DmdbPreparedStatement preparedStatement, int parameterIndex, Object x2) throws SQLException {
        this.getCurrent(preparedStatement).do_setObject(parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_addBatch(DmdbPreparedStatement preparedStatement) throws SQLException {
        this.getCurrent(preparedStatement).do_addBatch();
    }

    @Override
    public void PreparedStatement_setCharacterStream(DmdbPreparedStatement preparedStatement, int parameterIndex, Reader reader, int length) throws SQLException {
        this.getCurrent(preparedStatement).do_setCharacterStream(parameterIndex, reader, length);
    }

    @Override
    public void PreparedStatement_setRef(DmdbPreparedStatement preparedStatement, int parameterIndex, Ref x2) throws SQLException {
        this.getCurrent(preparedStatement).do_setRef(parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setBlob(DmdbPreparedStatement preparedStatement, int parameterIndex, Blob x2) throws SQLException {
        this.getCurrent(preparedStatement).do_setBlob(parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setClob(DmdbPreparedStatement preparedStatement, int parameterIndex, Clob x2) throws SQLException {
        this.getCurrent(preparedStatement).do_setClob(parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setArray(DmdbPreparedStatement preparedStatement, int parameterIndex, Array x2) throws SQLException {
        this.getCurrent(preparedStatement).do_setArray(parameterIndex, x2);
    }

    @Override
    public ResultSetMetaData PreparedStatement_getMetaData(DmdbPreparedStatement preparedStatement) throws SQLException {
        return this.getCurrent(preparedStatement).do_getMetaData();
    }

    @Override
    public void PreparedStatement_setDate(DmdbPreparedStatement preparedStatement, int parameterIndex, Date x2, Calendar cal) throws SQLException {
        this.getCurrent(preparedStatement).do_setDate(parameterIndex, x2, cal);
    }

    @Override
    public void PreparedStatement_setTime(DmdbPreparedStatement preparedStatement, int parameterIndex, Time x2, Calendar cal) throws SQLException {
        this.getCurrent(preparedStatement).do_setTime(parameterIndex, x2, cal);
    }

    @Override
    public void PreparedStatement_setTimestamp(DmdbPreparedStatement preparedStatement, int parameterIndex, Timestamp x2, Calendar cal) throws SQLException {
        this.getCurrent(preparedStatement).do_setTimestamp(parameterIndex, x2, cal);
    }

    @Override
    public void PreparedStatement_setNull(DmdbPreparedStatement preparedStatement, int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.getCurrent(preparedStatement).do_setNull(parameterIndex, sqlType, typeName);
    }

    @Override
    public void PreparedStatement_setURL(DmdbPreparedStatement preparedStatement, int parameterIndex, URL x2) throws SQLException {
        this.getCurrent(preparedStatement).do_setURL(parameterIndex, x2);
    }

    @Override
    public ParameterMetaData PreparedStatement_getParameterMetaData(DmdbPreparedStatement preparedStatement) throws SQLException {
        return this.getCurrent(preparedStatement).do_getParameterMetaData();
    }

    @Override
    public void PreparedStatement_setRowId(DmdbPreparedStatement preparedStatement, int parameterIndex, RowId x2) throws SQLException {
        this.getCurrent(preparedStatement).do_setRowId(parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setNString(DmdbPreparedStatement preparedStatement, int parameterIndex, String value) throws SQLException {
        this.getCurrent(preparedStatement).do_setNString(parameterIndex, value);
    }

    @Override
    public void PreparedStatement_setNCharacterStream(DmdbPreparedStatement preparedStatement, int parameterIndex, Reader value, long length) throws SQLException {
        this.getCurrent(preparedStatement).do_setNCharacterStream(parameterIndex, value, length);
    }

    @Override
    public void PreparedStatement_setNClob(DmdbPreparedStatement preparedStatement, int parameterIndex, NClob value) throws SQLException {
        this.getCurrent(preparedStatement).do_setNClob(parameterIndex, value);
    }

    @Override
    public void PreparedStatement_setClob(DmdbPreparedStatement preparedStatement, int parameterIndex, Reader reader, long length) throws SQLException {
        this.getCurrent(preparedStatement).do_setClob(parameterIndex, reader, length);
    }

    @Override
    public void PreparedStatement_setBlob(DmdbPreparedStatement preparedStatement, int parameterIndex, InputStream inputStream, long length) throws SQLException {
        this.getCurrent(preparedStatement).do_setBlob(parameterIndex, inputStream, length);
    }

    @Override
    public void PreparedStatement_setNClob(DmdbPreparedStatement preparedStatement, int parameterIndex, Reader reader, long length) throws SQLException {
        this.getCurrent(preparedStatement).do_setNClob(parameterIndex, reader, length);
    }

    @Override
    public void PreparedStatement_setSQLXML(DmdbPreparedStatement preparedStatement, int parameterIndex, SQLXML xmlObject) throws SQLException {
        this.getCurrent(preparedStatement).do_setSQLXML(parameterIndex, xmlObject);
    }

    @Override
    public void PreparedStatement_setObject(DmdbPreparedStatement preparedStatement, int parameterIndex, Object x2, int targetSqlType, int scaleOrLength) throws SQLException {
        this.getCurrent(preparedStatement).do_setObject(parameterIndex, x2, targetSqlType, scaleOrLength);
    }

    @Override
    public void PreparedStatement_setAsciiStream(DmdbPreparedStatement preparedStatement, int parameterIndex, InputStream x2, long length) throws SQLException {
        this.getCurrent(preparedStatement).do_setAsciiStream(parameterIndex, x2, length);
    }

    @Override
    public void PreparedStatement_setBinaryStream(DmdbPreparedStatement preparedStatement, int parameterIndex, InputStream x2, long length) throws SQLException {
        this.getCurrent(preparedStatement).do_setBinaryStream(parameterIndex, x2, length);
    }

    @Override
    public void PreparedStatement_setCharacterStream(DmdbPreparedStatement preparedStatement, int parameterIndex, Reader reader, long length) throws SQLException {
        this.getCurrent(preparedStatement).do_setCharacterStream(parameterIndex, reader, length);
    }

    @Override
    public void PreparedStatement_setAsciiStream(DmdbPreparedStatement preparedStatement, int parameterIndex, InputStream x2) throws SQLException {
        this.getCurrent(preparedStatement).do_setAsciiStream(parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setBinaryStream(DmdbPreparedStatement preparedStatement, int parameterIndex, InputStream x2) throws SQLException {
        this.getCurrent(preparedStatement).do_setBinaryStream(parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setCharacterStream(DmdbPreparedStatement preparedStatement, int parameterIndex, Reader reader) throws SQLException {
        this.getCurrent(preparedStatement).do_setCharacterStream(parameterIndex, reader);
    }

    @Override
    public void PreparedStatement_setNCharacterStream(DmdbPreparedStatement preparedStatement, int parameterIndex, Reader value) throws SQLException {
        this.getCurrent(preparedStatement).do_setNCharacterStream(parameterIndex, value);
    }

    @Override
    public void PreparedStatement_setClob(DmdbPreparedStatement preparedStatement, int parameterIndex, Reader reader) throws SQLException {
        this.getCurrent(preparedStatement).do_setClob(parameterIndex, reader);
    }

    @Override
    public void PreparedStatement_setBlob(DmdbPreparedStatement preparedStatement, int parameterIndex, InputStream inputStream) throws SQLException {
        this.getCurrent(preparedStatement).do_setBlob(parameterIndex, inputStream);
    }

    @Override
    public void PreparedStatement_setNClob(DmdbPreparedStatement preparedStatement, int parameterIndex, Reader reader) throws SQLException {
        this.getCurrent(preparedStatement).do_setNClob(parameterIndex, reader);
    }

    @Override
    public void PreparedStatement_setObject(DmdbPreparedStatement preparedStatement, int parameterIndex, Object x2, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        this.getCurrent(preparedStatement).do_setObject(parameterIndex, x2, targetSqlType, scaleOrLength);
    }

    @Override
    public void PreparedStatement_setObject(DmdbPreparedStatement preparedStatement, int parameterIndex, Object x2, SQLType targetSqlType) throws SQLException {
        this.getCurrent(preparedStatement).do_setObject(parameterIndex, x2, targetSqlType);
    }

    @Override
    public void PreparedStatement_preCompile(DmdbPreparedStatement preparedStatement, String sql) throws SQLException {
        this.getCurrent(preparedStatement).do_preCompile(sql);
    }

    @Override
    public void PreparedStatement_setTIMESTAMP(DmdbPreparedStatement preparedStatement, int parameterIndex, DmdbTimestamp x2) throws SQLException {
        this.getCurrent(preparedStatement).do_setTIMESTAMP(parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setINTERVALYM(DmdbPreparedStatement preparedStatement, int parameterIndex, DmdbIntervalYM x2) throws SQLException {
        this.getCurrent(preparedStatement).do_setINTERVALYM(parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setINTERVALDT(DmdbPreparedStatement preparedStatement, int parameterIndex, DmdbIntervalDT x2) throws SQLException {
        this.getCurrent(preparedStatement).do_setINTERVALDT(parameterIndex, x2);
    }

    @Override
    public int Statement_getMaxFieldSize(DmdbStatement statement) throws SQLException {
        return this.getCurrent(statement).do_getMaxFieldSize();
    }

    @Override
    public int Statement_getMaxRows(DmdbStatement statement) throws SQLException {
        return this.getCurrent(statement).do_getMaxRows();
    }

    @Override
    public int Statement_getQueryTimeout(DmdbStatement statement) throws SQLException {
        return this.getCurrent(statement).do_getQueryTimeout();
    }

    @Override
    public void Statement_cancel(DmdbStatement statement) throws SQLException {
        this.getCurrent(statement).do_cancel();
    }

    @Override
    public SQLWarning Statement_getWarnings(DmdbStatement statement) throws SQLException {
        return this.getCurrent(statement).do_getWarnings();
    }

    @Override
    public void Statement_clearWarnings(DmdbStatement statement) throws SQLException {
        this.getCurrent(statement).do_clearWarnings();
    }

    @Override
    public ResultSet Statement_getResultSet(DmdbStatement statement) throws SQLException {
        return this.getCurrent(statement).do_getResultSet();
    }

    @Override
    public int Statement_getUpdateCount(DmdbStatement statement) throws SQLException {
        return this.getCurrent(statement).do_getUpdateCount();
    }

    @Override
    public boolean Statement_getMoreResults(DmdbStatement statement) throws SQLException {
        return this.getCurrent(statement).do_getMoreResults();
    }

    @Override
    public int Statement_getFetchDirection(DmdbStatement statement) throws SQLException {
        return this.getCurrent(statement).do_getFetchDirection();
    }

    @Override
    public int Statement_getFetchSize(DmdbStatement statement) throws SQLException {
        return this.getCurrent(statement).do_getFetchSize();
    }

    @Override
    public int Statement_getResultSetConcurrency(DmdbStatement statement) throws SQLException {
        return this.getCurrent(statement).do_getResultSetConcurrency();
    }

    @Override
    public int Statement_getResultSetType(DmdbStatement statement) throws SQLException {
        return this.getCurrent(statement).do_getResultSetType();
    }

    @Override
    public void Statement_addBatch(DmdbStatement statement, String sql) throws SQLException {
        this.getCurrent(statement).do_addBatch(sql);
    }

    @Override
    public void Statement_clearBatch(DmdbStatement statement) throws SQLException {
        DscParallelFilter.doTaskParallel(statement.tempMap.values().toArray(new DmdbStatement[0]), new BaseFilter.FilterCallback<DmdbStatement>(){

            @Override
            public void run(DmdbStatement siteObject) throws SQLException {
                siteObject.do_clearBatch();
            }
        });
    }

    @Override
    public boolean Statement_getMoreResults(DmdbStatement statement, int current) throws SQLException {
        return this.getCurrent(statement).do_getMoreResults(current);
    }

    @Override
    public ResultSet Statement_getGeneratedKeys(DmdbStatement statement) throws SQLException {
        return this.getCurrent(statement).do_getGeneratedKeys();
    }

    @Override
    public int Statement_getResultSetHoldability(DmdbStatement statement) throws SQLException {
        return this.getCurrent(statement).do_getResultSetHoldability();
    }

    @Override
    public boolean Statement_isClosed(DmdbStatement statement) throws SQLException {
        return this.getCurrent(statement).do_isClosed();
    }

    @Override
    public long Statement_getLargeUpdateCount(DmdbStatement statement) throws SQLException {
        return this.getCurrent(statement).do_getLargeUpdateCount();
    }

    @Override
    public long Statement_getLargeMaxRows(DmdbStatement statement) throws SQLException {
        return this.getCurrent(statement).do_getLargeMaxRows();
    }

    @Override
    public long Statement_getExecuteId(DmdbStatement statement) {
        return this.getCurrent(statement).do_getExecuteId();
    }

    @Override
    public String Statement_getPrintMsg(DmdbStatement statement) {
        return this.getCurrent(statement).do_getPrintMsg();
    }

    @Override
    public int Statement_getSqlType(DmdbStatement statement) throws SQLException {
        return this.getCurrent(statement).do_getSqlType();
    }

    @Override
    public ResultSet[] Statement_getResultSets(DmdbStatement statement) {
        return this.getCurrent(statement).do_getResultSets();
    }
}

