/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.util;

import dm.jdbc.driver.DBError;
import dm.jdbc.util.ByteArrayQueue;
import java.io.InputStream;
import java.io.Reader;
import java.sql.SQLException;

public class StreamUtil {
    public static String readString(Reader reader, int len) throws SQLException {
        block4: {
            try {
                if (len != 0) break block4;
                return "";
            }
            catch (Exception e2) {
                DBError.throwException("read error", e2);
                return null;
            }
        }
        if (len > 0) {
            char[] cbuf = new char[len];
            int readLen = reader.read(cbuf, 0, cbuf.length);
            return readLen > 0 ? new String(cbuf, 0, readLen) : "";
        }
        return StreamUtil.readString(reader);
    }

    public static String readString(Reader reader) throws SQLException {
        try {
            StringBuilder sb = new StringBuilder();
            char[] cbuf = new char[10000];
            int readLen = 0;
            while ((readLen = reader.read(cbuf, 0, cbuf.length)) > 0) {
                sb.append(new String(cbuf, 0, readLen));
            }
            return sb.toString();
        }
        catch (Exception e2) {
            DBError.throwException("read error", e2);
            return null;
        }
    }

    public static byte[] readBytes(InputStream in, int length) throws SQLException {
        try {
            if (length == 0) {
                return new byte[0];
            }
            if (length > 0) {
                byte[] bytes = new byte[length];
                int iLen = 0;
                int off = 0;
                while (off < length) {
                    iLen = in.read(bytes, off, length - off);
                    if (iLen <= 0) break;
                    off += iLen;
                }
                int readLen = off;
                if (readLen < bytes.length) {
                    byte[] tmp = new byte[readLen];
                    System.arraycopy(bytes, 0, tmp, 0, readLen);
                    bytes = tmp;
                }
                return bytes;
            }
            return StreamUtil.readBytes(in);
        }
        catch (Exception e2) {
            DBError.throwException("read error", e2);
            return null;
        }
    }

    public static byte[] readBytes(InputStream in) throws SQLException {
        try {
            ByteArrayQueue buf = new ByteArrayQueue();
            byte[] bytes = new byte[10000];
            int readLen = 0;
            while ((readLen = in.read(bytes, 0, bytes.length)) > 0) {
                buf.putBytes(bytes, 0, readLen);
                bytes = new byte[10000];
            }
            return buf.toBytes();
        }
        catch (Exception e2) {
            DBError.throwException("read error", e2);
            return null;
        }
    }
}

