/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.driver.DBError;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbType;
import dm.jdbc.filter.Filterable;
import dm.jdbc.internal.desc.Column;
import dm.jdbc.internal.desc.TypeDesc;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.concurrent.atomic.AtomicLong;

public class DmdbResultSetMetaData
extends Filterable
implements ResultSetMetaData {
    public DmdbConnection connection;
    private Column[] columns;
    private TypeDesc[] typeDescs;
    public static AtomicLong IDGenerator = new AtomicLong(0L);

    @Override
    public long getID() {
        if (this.ID < 0L) {
            this.ID = IDGenerator.incrementAndGet();
        }
        return this.ID;
    }

    public DmdbResultSetMetaData(DmdbConnection connection, Column[] columns) {
        super(connection, null);
        this.connection = connection;
        this.columns = columns;
        this.typeDescs = new TypeDesc[columns.length];
    }

    private Column checkIndex(int column) throws SQLException {
        if (column < 1 || column > this.columns.length) {
            DBError.ECJDBC_INVALID_SEQUENCE_NUMBER.throwz(new Object[0]);
        }
        if (this.typeDescs[column - 1] == null) {
            this.typeDescs[column - 1] = DmdbType.getTypeDesc(this.columns[column - 1], this.connection);
        }
        return this.columns[column - 1];
    }

    public int do_getColumnCount() throws SQLException {
        return this.columns.length;
    }

    public boolean do_isAutoIncrement(int column) throws SQLException {
        Column columnDesc = this.checkIndex(column);
        return columnDesc.identity;
    }

    public boolean do_isCaseSensitive(int column) throws SQLException {
        Column columnDesc = this.checkIndex(column);
        boolean cs = false;
        switch (columnDesc.type) {
            case 0: 
            case 1: 
            case 2: 
            case 19: {
                cs = true;
                break;
            }
            default: {
                cs = false;
            }
        }
        return cs;
    }

    public boolean do_isSearchable(int column) throws SQLException {
        Column columnDesc = this.checkIndex(column);
        boolean searchable = true;
        switch (columnDesc.type) {
            case 12: 
            case 17: 
            case 18: 
            case 19: {
                searchable = false;
                break;
            }
            default: {
                searchable = true;
            }
        }
        return searchable;
    }

    public boolean do_isCurrency(int column) throws SQLException {
        Column columnDesc = this.checkIndex(column);
        return columnDesc.type == 9 && columnDesc.prec == 19 && columnDesc.scale == 4;
    }

    public int do_isNullable(int column) throws SQLException {
        Column columnDesc = this.checkIndex(column);
        return columnDesc.nullable ? 1 : 0;
    }

    public boolean do_isSigned(int column) throws SQLException {
        Column columnDesc = this.checkIndex(column);
        return DmdbType.isNumber(columnDesc.type);
    }

    public int do_getColumnDisplaySize(int column) throws SQLException {
        this.checkIndex(column);
        return this.typeDescs[column - 1].jdisplaySize;
    }

    public String do_getColumnLabel(int column) throws SQLException {
        return this.do_getColumnName(column);
    }

    public String do_getColumnName(int column) throws SQLException {
        Column columnDesc = this.checkIndex(column);
        String colName = columnDesc.name;
        if (colName == null) {
            return colName;
        }
        if (this.connection.isColumnNameUpperCase()) {
            return colName.toUpperCase();
        }
        if (this.connection.isColumnNameLowerCase()) {
            return colName.toLowerCase();
        }
        return colName;
    }

    public String do_getSchemaName(int column) throws SQLException {
        Column columnDesc = this.checkIndex(column);
        String schName = columnDesc.schemaName;
        return schName == null ? "" : schName;
    }

    public int do_getPrecision(int column) throws SQLException {
        this.checkIndex(column);
        return this.typeDescs[column - 1].jprec;
    }

    public int do_getScale(int column) throws SQLException {
        this.checkIndex(column);
        return this.typeDescs[column - 1].jscale;
    }

    public String do_getTableName(int column) throws SQLException {
        Column columnDesc = this.checkIndex(column);
        return columnDesc.tableName;
    }

    public String do_getCatalogName(int column) throws SQLException {
        return "";
    }

    public int do_getColumnType(int column) throws SQLException {
        this.checkIndex(column);
        return this.typeDescs[column - 1].jtype;
    }

    public String do_getColumnTypeName(int column) throws SQLException {
        this.checkIndex(column);
        return this.typeDescs[column - 1].dtypeName;
    }

    public boolean do_isReadOnly(int column) throws SQLException {
        Column columnDesc = this.checkIndex(column);
        return !this.connection.compatibleOracle() && columnDesc.readonly;
    }

    public boolean do_isWritable(int column) throws SQLException {
        return !this.do_isReadOnly(column);
    }

    public boolean do_isDefinitelyWritable(int column) throws SQLException {
        return this.do_isWritable(column);
    }

    public String do_getColumnClassName(int column) throws SQLException {
        this.checkIndex(column);
        return this.typeDescs[column - 1].jclassName;
    }

    @Override
    @Deprecated
    public int getColumnCount() throws SQLException {
        if (this.filterChain == null) {
            return this.do_getColumnCount();
        }
        return this.filterChain.reset().ResultSetMetaData_getColumnCount(this);
    }

    @Override
    @Deprecated
    public boolean isAutoIncrement(int column) throws SQLException {
        if (this.filterChain == null) {
            return this.do_isAutoIncrement(column);
        }
        return this.filterChain.reset().ResultSetMetaData_isAutoIncrement(this, column);
    }

    @Override
    @Deprecated
    public boolean isCaseSensitive(int column) throws SQLException {
        if (this.filterChain == null) {
            return this.do_isCaseSensitive(column);
        }
        return this.filterChain.reset().ResultSetMetaData_isCaseSensitive(this, column);
    }

    @Override
    @Deprecated
    public boolean isSearchable(int column) throws SQLException {
        if (this.filterChain == null) {
            return this.do_isSearchable(column);
        }
        return this.filterChain.reset().ResultSetMetaData_isSearchable(this, column);
    }

    @Override
    @Deprecated
    public boolean isCurrency(int column) throws SQLException {
        if (this.filterChain == null) {
            return this.do_isCurrency(column);
        }
        return this.filterChain.reset().ResultSetMetaData_isCurrency(this, column);
    }

    @Override
    @Deprecated
    public int isNullable(int column) throws SQLException {
        if (this.filterChain == null) {
            return this.do_isNullable(column);
        }
        return this.filterChain.reset().ResultSetMetaData_isNullable(this, column);
    }

    @Override
    @Deprecated
    public boolean isSigned(int column) throws SQLException {
        if (this.filterChain == null) {
            return this.do_isSigned(column);
        }
        return this.filterChain.reset().ResultSetMetaData_isSigned(this, column);
    }

    @Override
    @Deprecated
    public int getColumnDisplaySize(int column) throws SQLException {
        if (this.filterChain == null) {
            return this.do_getColumnDisplaySize(column);
        }
        return this.filterChain.reset().ResultSetMetaData_getColumnDisplaySize(this, column);
    }

    @Override
    @Deprecated
    public String getColumnLabel(int column) throws SQLException {
        if (this.filterChain == null) {
            return this.do_getColumnLabel(column);
        }
        return this.filterChain.reset().ResultSetMetaData_getColumnLabel(this, column);
    }

    @Override
    @Deprecated
    public String getColumnName(int column) throws SQLException {
        if (this.filterChain == null) {
            return this.do_getColumnName(column);
        }
        return this.filterChain.reset().ResultSetMetaData_getColumnName(this, column);
    }

    @Override
    @Deprecated
    public String getSchemaName(int column) throws SQLException {
        if (this.filterChain == null) {
            return this.do_getSchemaName(column);
        }
        return this.filterChain.reset().ResultSetMetaData_getSchemaName(this, column);
    }

    @Override
    @Deprecated
    public int getPrecision(int column) throws SQLException {
        if (this.filterChain == null) {
            return this.do_getPrecision(column);
        }
        return this.filterChain.reset().ResultSetMetaData_getPrecision(this, column);
    }

    @Override
    @Deprecated
    public int getScale(int column) throws SQLException {
        if (this.filterChain == null) {
            return this.do_getScale(column);
        }
        return this.filterChain.reset().ResultSetMetaData_getScale(this, column);
    }

    @Override
    @Deprecated
    public String getTableName(int column) throws SQLException {
        if (this.filterChain == null) {
            return this.do_getTableName(column);
        }
        return this.filterChain.reset().ResultSetMetaData_getTableName(this, column);
    }

    @Override
    @Deprecated
    public String getCatalogName(int column) throws SQLException {
        if (this.filterChain == null) {
            return this.do_getCatalogName(column);
        }
        return this.filterChain.reset().ResultSetMetaData_getCatalogName(this, column);
    }

    @Override
    @Deprecated
    public int getColumnType(int column) throws SQLException {
        if (this.filterChain == null) {
            return this.do_getColumnType(column);
        }
        return this.filterChain.reset().ResultSetMetaData_getColumnType(this, column);
    }

    @Override
    @Deprecated
    public String getColumnTypeName(int column) throws SQLException {
        if (this.filterChain == null) {
            return this.do_getColumnTypeName(column);
        }
        return this.filterChain.reset().ResultSetMetaData_getColumnTypeName(this, column);
    }

    @Override
    @Deprecated
    public boolean isReadOnly(int column) throws SQLException {
        if (this.filterChain == null) {
            return this.do_isReadOnly(column);
        }
        return this.filterChain.reset().ResultSetMetaData_isReadOnly(this, column);
    }

    @Override
    @Deprecated
    public boolean isWritable(int column) throws SQLException {
        if (this.filterChain == null) {
            return this.do_isWritable(column);
        }
        return this.filterChain.reset().ResultSetMetaData_isWritable(this, column);
    }

    @Override
    @Deprecated
    public boolean isDefinitelyWritable(int column) throws SQLException {
        if (this.filterChain == null) {
            return this.do_isDefinitelyWritable(column);
        }
        return this.filterChain.reset().ResultSetMetaData_isDefinitelyWritable(this, column);
    }

    @Override
    @Deprecated
    public String getColumnClassName(int column) throws SQLException {
        if (this.filterChain == null) {
            return this.do_getColumnClassName(column);
        }
        return this.filterChain.reset().ResultSetMetaData_getColumnClassName(this, column);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return iface.cast(this);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }
}

