/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.internal.desc;

import dm.jdbc.driver.DmdbBFile;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbIntervalDT;
import dm.jdbc.driver.DmdbIntervalYM;
import dm.jdbc.driver.DmdbTimestamp;
import dm.jdbc.driver.DmdbType;
import dm.jdbc.internal.IDmdbConnection;
import dm.jdbc.internal.desc.Column;
import dm.jdbc.util.StringUtil;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;

public class TypeDesc {
    public static final int JAVA_REF_CURSOR = 2012;
    public static final int JAVA_TIME_WITH_TIMEZONE = 2013;
    public static final int JAVA_TIMESTAMP_WITH_TIMEZONE = 2014;
    public int dtype;
    public String dtypeName;
    public int jtype;
    public int jscale;
    public int jprec;
    public String jclassName;
    public int jdisplaySize;

    public static TypeDesc bitDesc(Column column, IDmdbConnection connection) {
        TypeDesc typeDesc = new TypeDesc();
        typeDesc.dtype = column.type;
        typeDesc.dtypeName = "BIT";
        typeDesc.jtype = -7;
        typeDesc.jprec = 1;
        typeDesc.jscale = column.scale;
        typeDesc.jclassName = Boolean.class.getName();
        typeDesc.jdisplaySize = 1;
        return typeDesc;
    }

    public static TypeDesc booleanDesc(Column column, DmdbConnection connection) {
        TypeDesc typeDesc = new TypeDesc();
        typeDesc.dtype = column.type;
        typeDesc.dtypeName = "BIT";
        typeDesc.jtype = 16;
        typeDesc.jprec = 1;
        typeDesc.jscale = column.scale;
        typeDesc.jclassName = Boolean.class.getName();
        typeDesc.jdisplaySize = 1;
        return typeDesc;
    }

    public static TypeDesc tinyintDesc(Column column, DmdbConnection connection) {
        TypeDesc typeDesc = new TypeDesc();
        typeDesc.dtype = column.type;
        typeDesc.dtypeName = "TINYINT";
        typeDesc.jtype = -6;
        typeDesc.jprec = 3;
        typeDesc.jscale = column.scale;
        typeDesc.jclassName = Byte.class.getName();
        typeDesc.jdisplaySize = 4;
        return typeDesc;
    }

    public static TypeDesc smallintDesc(Column column, DmdbConnection connection) {
        TypeDesc typeDesc = new TypeDesc();
        typeDesc.dtype = column.type;
        typeDesc.dtypeName = "SMALLINT";
        typeDesc.jtype = 5;
        typeDesc.jprec = 5;
        typeDesc.jscale = column.scale;
        typeDesc.jclassName = Short.class.getName();
        typeDesc.jdisplaySize = 6;
        return typeDesc;
    }

    public static TypeDesc integerDesc(Column column, DmdbConnection connection) {
        TypeDesc typeDesc = new TypeDesc();
        typeDesc.dtype = column.type;
        typeDesc.dtypeName = "INTEGER";
        typeDesc.jtype = 4;
        typeDesc.jprec = 10;
        typeDesc.jscale = column.scale;
        typeDesc.jclassName = Integer.class.getName();
        typeDesc.jdisplaySize = 11;
        return typeDesc;
    }

    public static TypeDesc bigintDesc(Column column, DmdbConnection connection) {
        TypeDesc typeDesc = new TypeDesc();
        typeDesc.dtype = column.type;
        typeDesc.dtypeName = "BIGINT";
        typeDesc.jtype = -5;
        typeDesc.jprec = 19;
        typeDesc.jscale = column.scale;
        typeDesc.jclassName = Long.class.getName();
        typeDesc.jdisplaySize = 20;
        return typeDesc;
    }

    public static TypeDesc realDesc(Column column, DmdbConnection connection) {
        TypeDesc typeDesc = new TypeDesc();
        typeDesc.dtype = column.type;
        typeDesc.dtypeName = "REAL";
        typeDesc.jtype = 7;
        typeDesc.jprec = 24;
        typeDesc.jscale = column.scale;
        typeDesc.jclassName = Float.class.getName();
        typeDesc.jdisplaySize = 25;
        return typeDesc;
    }

    public static TypeDesc floatDesc(Column column, DmdbConnection connection) {
        TypeDesc typeDesc = new TypeDesc();
        typeDesc.dtype = column.type;
        typeDesc.dtypeName = "FLOAT";
        typeDesc.jtype = 6;
        typeDesc.jprec = column.prec;
        typeDesc.jscale = column.scale;
        typeDesc.jclassName = Float.class.getName();
        typeDesc.jdisplaySize = column.prec == 0 ? 22 : column.prec + 2;
        return typeDesc;
    }

    public static TypeDesc doubleDesc(Column column, DmdbConnection connection) {
        TypeDesc typeDesc = new TypeDesc();
        typeDesc.dtype = column.type;
        typeDesc.dtypeName = "DOUBLE";
        typeDesc.jtype = 8;
        typeDesc.jprec = 53;
        typeDesc.jscale = column.scale;
        typeDesc.jclassName = Double.class.getName();
        typeDesc.jdisplaySize = 53;
        return typeDesc;
    }

    public static TypeDesc decimalDesc(Column column, DmdbConnection connection) {
        TypeDesc typeDesc = new TypeDesc();
        typeDesc.dtype = column.type;
        typeDesc.dtypeName = "DECIMAL";
        typeDesc.jtype = 3;
        if (column.scale == -1) {
            typeDesc.jprec = 0;
            typeDesc.jscale = -1;
            typeDesc.jdisplaySize = 39;
        } else {
            typeDesc.jprec = column.prec;
            typeDesc.jscale = column.scale;
            typeDesc.jdisplaySize = typeDesc.jprec + 2;
        }
        typeDesc.jclassName = BigDecimal.class.getName();
        return typeDesc;
    }

    public static TypeDesc oracleNumberDesc(Column column, DmdbConnection connection) {
        TypeDesc typeDesc = new TypeDesc();
        typeDesc.dtype = column.type;
        typeDesc.dtypeName = "NUMBER";
        typeDesc.jtype = 2;
        if (column.scale == -1 || StringUtil.isEmpty(column.baseName)) {
            typeDesc.jprec = 0;
            typeDesc.jscale = -127;
            typeDesc.jdisplaySize = 39;
        } else if (DmdbType.isInteger(column.type)) {
            typeDesc.jprec = 38;
            typeDesc.jscale = 0;
            typeDesc.jdisplaySize = 39;
        } else {
            typeDesc.jprec = column.prec;
            typeDesc.jscale = column.scale;
            typeDesc.jdisplaySize = typeDesc.jprec + 2;
        }
        typeDesc.jclassName = BigDecimal.class.getName();
        return typeDesc;
    }

    public static TypeDesc numericDesc(Column column, DmdbConnection connection) {
        TypeDesc typeDesc = new TypeDesc();
        typeDesc.dtype = column.type;
        typeDesc.dtypeName = "NUMERIC";
        typeDesc.jtype = 2;
        if (column.scale == -1) {
            typeDesc.jprec = 0;
            typeDesc.jscale = -1;
            typeDesc.jdisplaySize = 39;
        } else {
            typeDesc.jprec = column.prec;
            typeDesc.jscale = column.scale;
            typeDesc.jdisplaySize = typeDesc.jprec + 2;
        }
        typeDesc.jclassName = BigDecimal.class.getName();
        return typeDesc;
    }

    public static TypeDesc charDesc(Column column, DmdbConnection connection) {
        TypeDesc typeDesc = new TypeDesc();
        typeDesc.dtype = column.type;
        typeDesc.dtypeName = "CHAR";
        typeDesc.jtype = 1;
        typeDesc.jprec = column.prec;
        typeDesc.jscale = column.scale;
        typeDesc.jclassName = String.class.getName();
        typeDesc.jdisplaySize = column.prec;
        return typeDesc;
    }

    public static TypeDesc varcharDesc(Column column, DmdbConnection connection) {
        TypeDesc typeDesc = new TypeDesc();
        typeDesc.dtype = column.type;
        typeDesc.dtypeName = "VARCHAR";
        typeDesc.jtype = 12;
        typeDesc.jprec = column.prec;
        typeDesc.jscale = column.scale;
        typeDesc.jdisplaySize = column.prec;
        typeDesc.jclassName = String.class.getName();
        return typeDesc;
    }

    public static TypeDesc varchar2Desc(Column column, DmdbConnection connection) {
        TypeDesc typeDesc = new TypeDesc();
        typeDesc.dtype = column.type;
        typeDesc.dtypeName = "VARCHAR2";
        typeDesc.jtype = 1;
        typeDesc.jprec = column.prec;
        typeDesc.jscale = column.scale;
        typeDesc.jclassName = String.class.getName();
        typeDesc.jdisplaySize = column.prec;
        return typeDesc;
    }

    public static TypeDesc longvarcharDesc(Column column, DmdbConnection connection) {
        TypeDesc typeDesc = new TypeDesc();
        typeDesc.dtype = column.type;
        typeDesc.dtypeName = "LONGVARCHAR";
        typeDesc.jtype = -1;
        typeDesc.jprec = column.prec;
        typeDesc.jscale = column.scale;
        typeDesc.jclassName = String.class.getName();
        typeDesc.jdisplaySize = column.prec;
        return typeDesc;
    }

    public static TypeDesc clobDesc(Column column, DmdbConnection connection) {
        TypeDesc typeDesc = new TypeDesc();
        typeDesc.dtype = column.type;
        typeDesc.dtypeName = "CLOB";
        typeDesc.jtype = 2005;
        typeDesc.jprec = column.prec;
        typeDesc.jscale = column.scale;
        typeDesc.jclassName = Clob.class.getName();
        typeDesc.jdisplaySize = column.prec;
        return typeDesc;
    }

    public static TypeDesc bfileDesc(Column column, DmdbConnection connection) {
        TypeDesc typeDesc = new TypeDesc();
        typeDesc.dtype = column.type;
        typeDesc.dtypeName = "BFILE";
        typeDesc.jtype = 12;
        typeDesc.jprec = column.prec;
        typeDesc.jscale = column.scale;
        typeDesc.jclassName = DmdbBFile.class.getName();
        typeDesc.jdisplaySize = column.prec;
        return typeDesc;
    }

    public static TypeDesc binaryDesc(Column column, DmdbConnection connection) {
        TypeDesc typeDesc = new TypeDesc();
        typeDesc.dtype = column.type;
        typeDesc.dtypeName = "BINARY";
        typeDesc.jtype = -2;
        typeDesc.jprec = column.prec;
        typeDesc.jscale = column.scale;
        typeDesc.jclassName = byte[].class.getName();
        typeDesc.jdisplaySize = column.prec * 2;
        return typeDesc;
    }

    public static TypeDesc varbinaryDesc(Column column, DmdbConnection connection) {
        TypeDesc typeDesc = new TypeDesc();
        typeDesc.dtype = column.type;
        typeDesc.dtypeName = "VARBINARY";
        typeDesc.jtype = -3;
        typeDesc.jprec = column.prec;
        typeDesc.jscale = column.scale;
        typeDesc.jclassName = byte[].class.getName();
        typeDesc.jdisplaySize = column.prec * 2;
        return typeDesc;
    }

    public static TypeDesc longvarbinaryDesc(Column column, DmdbConnection connection) {
        TypeDesc typeDesc = new TypeDesc();
        typeDesc.dtype = column.type;
        typeDesc.dtypeName = "LONGVARBINARY";
        typeDesc.jtype = -4;
        typeDesc.jprec = column.prec;
        typeDesc.jscale = column.scale;
        typeDesc.jclassName = byte[].class.getName();
        typeDesc.jdisplaySize = column.prec * 2;
        return typeDesc;
    }

    public static TypeDesc blobDesc(Column column, DmdbConnection connection) {
        TypeDesc typeDesc = new TypeDesc();
        typeDesc.dtype = column.type;
        typeDesc.dtypeName = "BLOB";
        typeDesc.jtype = 2004;
        typeDesc.jprec = column.prec;
        typeDesc.jscale = column.scale;
        typeDesc.jclassName = Blob.class.getName();
        typeDesc.jdisplaySize = column.prec;
        return typeDesc;
    }

    public static TypeDesc dateDesc(Column column, DmdbConnection connection) {
        TypeDesc typeDesc = new TypeDesc();
        typeDesc.dtype = column.type;
        typeDesc.dtypeName = "DATE";
        typeDesc.jtype = 91;
        typeDesc.jprec = 10;
        typeDesc.jscale = column.scale;
        typeDesc.jclassName = Date.class.getName();
        typeDesc.jdisplaySize = 10;
        return typeDesc;
    }

    public static TypeDesc timeDesc(Column column, DmdbConnection connection) {
        TypeDesc typeDesc = new TypeDesc();
        typeDesc.dtype = column.type;
        typeDesc.dtypeName = "TIME";
        typeDesc.jtype = 92;
        typeDesc.jprec = column.scale != 0 ? 9 + column.scale : 8;
        typeDesc.jscale = column.scale;
        typeDesc.jclassName = Time.class.getName();
        typeDesc.jdisplaySize = column.scale != 0 ? 9 + column.scale : 8;
        return typeDesc;
    }

    public static TypeDesc timeTZDesc(Column column, DmdbConnection connection) {
        TypeDesc typeDesc = new TypeDesc();
        typeDesc.dtype = column.type;
        typeDesc.dtypeName = "TIME WITH TIME ZONE";
        typeDesc.jtype = 2013;
        typeDesc.jprec = column.prec;
        typeDesc.jscale = column.scale;
        typeDesc.jclassName = DmdbTimestamp.class.getName();
        typeDesc.jdisplaySize = column.prec;
        return typeDesc;
    }

    public static TypeDesc timestampDesc(Column column, DmdbConnection connection) {
        TypeDesc typeDesc = new TypeDesc();
        typeDesc.dtype = column.type;
        typeDesc.dtypeName = "TIMESTAMP";
        typeDesc.jtype = 93;
        typeDesc.jprec = column.scale != 0 ? 20 + column.scale : 19;
        typeDesc.jscale = column.scale;
        typeDesc.jclassName = Timestamp.class.getName();
        typeDesc.jdisplaySize = column.scale != 0 ? 20 + column.scale : 19;
        return typeDesc;
    }

    public static TypeDesc timestampLocalTZDesc(Column column, DmdbConnection connection) {
        TypeDesc typeDesc = TypeDesc.timestampDesc(column, connection);
        typeDesc.dtypeName = "TIMESTAMP WITH LOCAL TIME ZONE";
        return typeDesc;
    }

    public static TypeDesc timestampTZDesc(Column column, DmdbConnection connection) {
        TypeDesc typeDesc = new TypeDesc();
        typeDesc.dtype = column.type;
        typeDesc.dtypeName = "TIMESTAMP WITH TIME ZONE";
        typeDesc.jtype = 2014;
        typeDesc.jprec = column.prec;
        typeDesc.jscale = column.scale;
        typeDesc.jclassName = DmdbTimestamp.class.getName();
        typeDesc.jdisplaySize = column.prec;
        return typeDesc;
    }

    public static TypeDesc intervalYMDesc(Column column, DmdbConnection connection) {
        TypeDesc typeDesc = new TypeDesc();
        typeDesc.dtype = column.type;
        int destType = (column.scale & 0xFF00) >> 8;
        switch (destType) {
            case 0: {
                typeDesc.dtypeName = "INTERVAL YEAR";
                break;
            }
            case 1: {
                typeDesc.dtypeName = "INTERVAL YEAR TO MONTH";
                break;
            }
            case 2: {
                typeDesc.dtypeName = "INTERVAL MONTH";
                break;
            }
            default: {
                typeDesc.dtypeName = "INTERVAL YEAR TO MONTH";
            }
        }
        typeDesc.jtype = 1111;
        typeDesc.jprec = column.scale >> 4 & 0xF;
        typeDesc.jscale = column.scale & 0xF;
        typeDesc.jclassName = DmdbIntervalYM.class.getName();
        typeDesc.jdisplaySize = column.prec;
        return typeDesc;
    }

    public static TypeDesc intervalDTDesc(Column column, DmdbConnection connection) {
        TypeDesc typeDesc = new TypeDesc();
        typeDesc.dtype = column.type;
        int destType = (column.scale & 0xFF00) >> 8;
        switch (destType) {
            case 3: {
                typeDesc.dtypeName = "INTERVAL DAY";
                break;
            }
            case 4: {
                typeDesc.dtypeName = "INTERVAL DAY TO HOUR";
                break;
            }
            case 5: {
                typeDesc.dtypeName = "INTERVAL DAY TO MINUTE";
                break;
            }
            case 6: {
                typeDesc.dtypeName = "INTERVAL DAY TO SECOND";
                break;
            }
            case 7: {
                typeDesc.dtypeName = "INTERVAL HOUR";
                break;
            }
            case 8: {
                typeDesc.dtypeName = "INTERVAL HOUR TO MINUTE";
                break;
            }
            case 9: {
                typeDesc.dtypeName = "INTERVAL HOUR TO SECOND";
                break;
            }
            case 10: {
                typeDesc.dtypeName = "INTERVAL MINUTE";
                break;
            }
            case 11: {
                typeDesc.dtypeName = "INTERVAL MINUTE TO SECOND";
                break;
            }
            case 12: {
                typeDesc.dtypeName = "INTERVAL SECOND";
                break;
            }
            default: {
                typeDesc.dtypeName = "INTERVAL YEAR TO MONTH";
            }
        }
        typeDesc.jtype = 1111;
        typeDesc.jprec = column.scale >> 4 & 0xF;
        typeDesc.jscale = column.scale & 0xF;
        typeDesc.jclassName = DmdbIntervalDT.class.getName();
        typeDesc.jdisplaySize = column.prec;
        return typeDesc;
    }

    public static TypeDesc rowidDesc(Column column, DmdbConnection connection) {
        TypeDesc typeDesc = new TypeDesc();
        typeDesc.dtype = column.type;
        typeDesc.dtypeName = "ROWID";
        typeDesc.jtype = -8;
        typeDesc.jprec = column.prec;
        typeDesc.jscale = column.scale;
        typeDesc.jclassName = RowId.class.getName();
        typeDesc.jdisplaySize = column.prec;
        return typeDesc;
    }

    public static TypeDesc arrayDesc(Column column, DmdbConnection connection) throws SQLException {
        TypeDesc typeDesc = new TypeDesc();
        typeDesc.dtype = column.type;
        typeDesc.dtypeName = column.typeDescriptor != null ? column.typeDescriptor.getFulName() : "ARRAY";
        typeDesc.jtype = 2003;
        typeDesc.jprec = column.prec;
        typeDesc.jscale = column.scale;
        typeDesc.jclassName = Array.class.getName();
        typeDesc.jdisplaySize = column.prec;
        return typeDesc;
    }

    public static TypeDesc structDesc(Column column, DmdbConnection connection) throws SQLException {
        TypeDesc typeDesc = new TypeDesc();
        typeDesc.dtype = column.type;
        typeDesc.dtypeName = column.typeDescriptor != null ? column.typeDescriptor.getFulName() : "STRUCT";
        typeDesc.jtype = 2002;
        typeDesc.jprec = column.prec;
        typeDesc.jscale = column.scale;
        typeDesc.jclassName = Struct.class.getName();
        typeDesc.jdisplaySize = column.prec;
        return typeDesc;
    }

    public static TypeDesc cursorDesc(Column column, DmdbConnection connection) {
        TypeDesc typeDesc = new TypeDesc();
        typeDesc.dtype = column.type;
        typeDesc.dtypeName = "CURSOR";
        typeDesc.jtype = 2012;
        typeDesc.jprec = column.prec;
        typeDesc.jscale = column.scale;
        typeDesc.jclassName = Object.class.getName();
        typeDesc.jdisplaySize = column.prec;
        return typeDesc;
    }
}

