/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.plugin.fldr;

import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbIntervalDT;
import dm.jdbc.driver.DmdbIntervalYM;
import dm.jdbc.driver.DmdbTimestamp;
import dm.jdbc.internal.IDmdbConnection;
import dm.jdbc.internal.convert.J2DB;
import dm.jdbc.internal.desc.Column;
import dm.jdbc.internal.desc.Parameter;
import dm.jdbc.plugin.fldr.FldrUtil;
import dm.jdbc.util.ByteUtil;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class FldrHashCode {
    private static final long HC_MASK = 0xFFFFFFFFL;
    private static final int TZ_INVALID_VALUE = 1000;
    private static final int TZ_DEFAULT_VALUE = 480;
    private static int[] global_days_befor_month;
    private static final Calendar cal;
    static final int MAXIMUM_CAPACITY = 0x40000000;

    static {
        int[] nArray = new int[12];
        nArray[1] = 31;
        nArray[2] = 59;
        nArray[3] = 90;
        nArray[4] = 120;
        nArray[5] = 151;
        nArray[6] = 181;
        nArray[7] = 212;
        nArray[8] = 243;
        nArray[9] = 273;
        nArray[10] = 304;
        nArray[11] = 334;
        global_days_befor_month = nArray;
        cal = Calendar.getInstance();
    }

    public static final int tableSizeFor(int cap) {
        int n2 = cap - 1;
        n2 |= n2 >>> 1;
        n2 |= n2 >>> 2;
        n2 |= n2 >>> 4;
        n2 |= n2 >>> 8;
        return (n2 |= n2 >>> 16) < 0 ? 1 : (n2 >= 0x40000000 ? 0x40000000 : n2 + 1);
    }

    public static long hc_get_fold_fun(int destType, int hashSize, Object data, DmdbConnection conn) throws SQLException {
        Parameter paramDesc = new Parameter();
        paramDesc.resetType(destType);
        byte[] value = null;
        boolean caseSensitive = conn.caseSensitive;
        switch (destType) {
            case 3: 
            case 5: 
            case 6: 
            case 29: {
                return FldrHashCode.hc_get_l4_fold(data);
            }
            case 7: 
            case 10: {
                return FldrHashCode.hc_get_int_fold(data);
            }
            case 8: 
            case 28: {
                if (data != null) {
                    value = J2DB.fromObject(data, paramDesc, conn);
                }
                return FldrHashCode.hc_get_int64_fold(value);
            }
            case 11: {
                if (data != null) {
                    value = J2DB.fromObject(data, paramDesc, conn);
                }
                return FldrHashCode.hc_get_double_fold(value);
            }
            case 14: 
            case 16: 
            case 26: {
                if (data != null) {
                    value = FldrUtil.fromDate((Date)data);
                }
                return FldrHashCode.hc_get_datetime_fold(value);
            }
            case 23: 
            case 27: {
                return FldrHashCode.hc_get_datetime_with_tz_fold(data, conn);
            }
            case 20: {
                return FldrHashCode.hc_get_ivym_fold((DmdbIntervalYM)data);
            }
            case 21: {
                return FldrHashCode.hc_get_ivdt_fold((DmdbIntervalDT)data);
            }
            case 9: {
                if (data != null) {
                    value = J2DB.fromObject(data, paramDesc, conn);
                }
                return FldrHashCode.hc_get_dec_fold(value);
            }
            case 15: {
                if (data != null) {
                    value = FldrUtil.fromDate((Date)data);
                }
                return FldrHashCode.hc_get_time_fold(value);
            }
            case 22: {
                if (data != null) {
                    value = J2DB.fromObject(data, paramDesc, conn);
                    int[] dt = DmdbTimestamp.valueOf((byte[])value, (Column)paramDesc, (IDmdbConnection)conn).dt;
                    return FldrHashCode.hc_get_time_with_tz_fold(dt);
                }
                return (hashSize << 1) - 1;
            }
            case 0: 
            case 1: 
            case 2: 
            case 12: 
            case 19: {
                if (data != null) {
                    value = J2DB.fromObject(data, paramDesc, conn);
                }
                if (caseSensitive) {
                    return FldrHashCode.hc_get_varlen_cs_fold_fnv1a(value);
                }
                return FldrHashCode.hc_get_varlen_ncs_fold_fnv1a(value);
            }
            case 17: 
            case 18: {
                if (data != null) {
                    value = J2DB.fromObject(data, paramDesc, conn);
                }
                if (!conn.compatibleMysql()) {
                    return FldrHashCode.hc_get_varlen_cs_fold_fnv1a(value);
                }
                return FldrHashCode.hc_get_binary_fold_in_sqlserver_mode(value);
            }
        }
        return 0L;
    }

    public static int compareNumHash(int hashSize, int subTableNums, Object value) {
        if (value == null) {
            return 0;
        }
        long tmp = (Long)value % (long)hashSize;
        while (tmp >= (long)subTableNums) {
            tmp -= (long)(hashSize / 2);
        }
        return (int)tmp;
    }

    private static long hc_get_l4_fold(Object value) throws SQLException {
        if (value == null) {
            return 0L;
        }
        int val = value instanceof Byte ? (Byte)value : (value instanceof Short ? ((Short)value).shortValue() : ((Integer)value).intValue());
        return (long)val & 0xFFFFFFFFL;
    }

    private static long hc_get_int_fold(Object value) {
        if (value == null) {
            return 0L;
        }
        int val = value instanceof Float ? Float.floatToIntBits(((Float)value).floatValue()) : (Integer)value;
        return (long)val & 0xFFFFFFFFL;
    }

    private static long hc_get_int64_fold(byte[] value) {
        if (value == null) {
            return 0L;
        }
        return (long)ByteUtil.getInt(value, 0) & 0xFFFFFFFFL;
    }

    private static long hc_get_double_fold(byte[] value) {
        if (value == null) {
            return 0L;
        }
        long firstPart = (long)ByteUtil.getInt(value, 0) & 0xFFFFFFFFL;
        long secondPart = (long)ByteUtil.getInt(value, 4) & 0xFFFFFFFFL;
        return firstPart + secondPart;
    }

    private static long hc_get_time_fold(byte[] value) {
        if (value == null) {
            return 0L;
        }
        return (long)ByteUtil.getInt(value, 4) & 0xFFFFFFFFL;
    }

    private static long hc_get_datetime_fold(byte[] value) {
        if (value == null) {
            return 0L;
        }
        int retValue = value[6] + value[3] | value[5] << 6 | value[4] << 12 | value[3] << 17 | value[2] << 22 | (value[0] & 7) << 26 | (value[7] & 7) << 29;
        return (long)retValue & 0xFFFFFFFFL;
    }

    private static long hc_get_ivym_fold(DmdbIntervalYM value) {
        if (value == null) {
            return 0L;
        }
        return (long)(value.getYear() << 4 | value.getMonth()) & 0xFFFFFFFFL;
    }

    private static long hc_get_ivdt_fold(DmdbIntervalDT value) {
        if (value == null) {
            return 0L;
        }
        return (long)(value.getDay() << 18 | value.getHour() << 12 | value.getMinute() << 6 | value.getSecond()) & 0xFFFFFFFFL;
    }

    private static long hc_get_varlen_cs_fold_fnv1a(byte[] value) {
        if (value == null) {
            return 0L;
        }
        int alen = value.length;
        if (alen == 0) {
            return 0L;
        }
        int pdata = 0;
        if (alen == 1) {
            return ByteUtil.getByte(value, pdata);
        }
        if (alen > 0) {
            pdata = pdata + alen - 1;
            while (value[pdata] == 32 && alen != 0) {
                --pdata;
                --alen;
            }
        }
        return FldrHashCode.hc_get_varlen_fold_cs_low_fnv1a(value, alen);
    }

    private static long hc_get_varlen_fold_cs_low_fnv1a(byte[] value, int length) {
        if (length == 2) {
            return ByteUtil.getUB2(value, 0);
        }
        int ret_value = 0;
        int i2 = 0;
        while (i2 < length) {
            ret_value ^= value[i2];
            ret_value += (ret_value << 1) + (ret_value << 4) + (ret_value << 7) + (ret_value << 8) + (ret_value << 24);
            ++i2;
        }
        return (long)ret_value & 0xFFFFFFFFL;
    }

    private static long hc_get_varlen_ncs_fold_fnv1a(byte[] value) {
        if (value == null) {
            return 0L;
        }
        int alen = value.length;
        if (alen == 0) {
            return 0L;
        }
        int pdata = 0;
        if (alen > 0) {
            pdata = pdata + alen - 1;
            while (value[pdata] == 32 && alen != 0) {
                --pdata;
                --alen;
            }
        }
        return FldrHashCode.hc_get_varlen_fold_ncs_low_fnv1a(value, alen);
    }

    private static long hc_get_varlen_fold_ncs_low_fnv1a(byte[] value, int length) {
        int ret_value = 0;
        if (length == 1) {
            byte key_tmp = ByteUtil.getByte(value, 0);
            if (key_tmp > 96) {
                return key_tmp - 32;
            }
            return key_tmp;
        }
        if (length == 2) {
            byte key_tmp2;
            byte key_tmp = value[0];
            if (key_tmp > 96) {
                key_tmp = (byte)(key_tmp - 32);
            }
            if ((key_tmp2 = value[1]) > 96) {
                key_tmp2 = (byte)(key_tmp2 - 32);
            }
            return (key_tmp2 << 8) + key_tmp;
        }
        int i2 = 0;
        while (i2 < length) {
            ret_value = value[i2] > 96 ? (ret_value ^= value[i2] - 32) : (ret_value ^= value[i2]);
            ret_value += (ret_value << 1) + (ret_value << 4) + (ret_value << 7) + (ret_value << 8) + (ret_value << 24);
            ++i2;
        }
        return (long)ret_value & 0xFFFFFFFFL;
    }

    private static long hc_get_datetime_with_tz_fold(Object value, DmdbConnection conn) {
        int msec;
        if (value == null) {
            return 0L;
        }
        Date date = (Date)value;
        cal.setTime(date);
        int year = cal.get(1);
        int leapDays = 0;
        int days = year * 365 + global_days_befor_month[cal.get(2)] + cal.get(5);
        if (cal.get(2) <= 1) {
            --year;
        }
        leapDays = year < 1600 ? year / 4 : 400 + (year - 1600) / 4 - (year - 1600) / 100 + (year - 1600) / 400;
        if (year >= 0) {
            ++leapDays;
        }
        days += leapDays;
        int tz = TimeZone.getDefault().getRawOffset() / 60000;
        if (tz == 1000) {
            tz = 480;
        }
        int hourToMin = cal.get(11) * 60 + cal.get(12) - tz;
        int tmp = hourToMin / 1440;
        days += tmp;
        if ((hourToMin -= tmp * 24 * 60) < 0) {
            --days;
            hourToMin += 1440;
        }
        if (value instanceof Timestamp) {
            Timestamp ts = (Timestamp)value;
            msec = ts.getNanos() / 1000;
        } else {
            msec = cal.get(14);
        }
        return days + hourToMin + msec + cal.get(13);
    }

    private static long hc_get_time_with_tz_fold(int[] dt) {
        int hour_to_min1;
        int hour1 = dt[3];
        int min1 = dt[4];
        int sec1 = dt[5];
        int msec1 = dt[6];
        int tz1 = dt[7];
        if (tz1 == 1000) {
            tz1 = 480;
        }
        if ((hour_to_min1 = hour1 * 60 + min1 - tz1) < 0) {
            hour_to_min1 += 1440;
        }
        return (long)(hour_to_min1 + msec1 + sec1) & 0xFFFFFFFFL;
    }

    private static long hc_get_dec_fold(byte[] value) throws SQLException {
        if (value == null) {
            return 0L;
        }
        int pdata = 1;
        int ret = 0;
        int fold = 0;
        int alen = value.length - 1;
        while (alen > 4) {
            fold += ByteUtil.getInt(value, pdata);
            pdata += 4;
            alen -= 4;
        }
        if (alen > 0) {
            byte[] temp = new byte[4];
            System.arraycopy(value, pdata, temp, 0, alen);
            ret = ByteUtil.getInt(temp, 0);
        }
        return (long)(ret + fold) & 0xFFFFFFFFL;
    }

    private static long hc_get_varlen_fold_cs_low(byte[] value, int length) {
        int nr = 1;
        int nr2 = 4;
        byte key_tmp = 0;
        if (length == 0) {
            return nr;
        }
        if (length == 2) {
            return ByteUtil.getUB2(value, 0);
        }
        if (length > 64) {
            return FldrHashCode.bfd_varlen_low_cs_max(value, length);
        }
        int i2 = 0;
        while (i2 < length) {
            key_tmp = value[i2];
            nr ^= ((nr & 0x3F) + nr2) * key_tmp + (nr << 8);
            nr2 += 3;
            ++i2;
        }
        return (long)nr & 0xFFFFFFFFL;
    }

    private static long bfd_varlen_low_cs_max(byte[] value, int length) {
        int nr = 1;
        int nr2 = 4;
        int left = 0;
        int right = 0;
        int key_tmp = 0;
        int step = length >> 6;
        left = 0 + (length >> 1) - 1;
        right = left + 1;
        int sample_cnt = 32 + length % 64 / step / 2;
        int i2 = 0;
        while (i2 < sample_cnt) {
            key_tmp = left;
            nr ^= ((nr & 0x3F) + nr2) * value[key_tmp] + (nr << 8);
            left -= step;
            key_tmp = right;
            nr ^= ((nr & 0x3F) + (nr2 += 3)) * value[key_tmp] + (nr << 8);
            nr2 += 3;
            right += step;
            ++i2;
        }
        return (long)nr & 0xFFFFFFFFL;
    }

    private static long hc_get_binary_fold_in_sqlserver_mode(byte[] value) {
        if (value == null) {
            return 0L;
        }
        int alen = value.length;
        if (alen == 0) {
            return 0L;
        }
        int pdata = 0;
        if (alen == 1) {
            return ByteUtil.getByte(value, pdata);
        }
        if (alen > 0) {
            pdata = pdata + alen - 1;
            while ((value[pdata] == 32 || value[pdata] == 0) && alen != 0) {
                --pdata;
                --alen;
            }
        }
        return FldrHashCode.hc_get_varlen_fold_cs_low(value, alen);
    }
}

