/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.util;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class CacheMap<K, T> {
    private LinkedHashMap<K, T> map = null;
    public int maxSize;

    public CacheMap(final int maxSize) {
        this.map = new LinkedHashMap<K, T>(maxSize, 0.75f, true){
            private static final long serialVersionUID = 1L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<K, T> eldest) {
                boolean bool;
                boolean bl = bool = this.size() > maxSize;
                if (bool) {
                    CacheMap.this.beforeRemove(eldest);
                }
                return bool;
            }
        };
        this.maxSize = maxSize;
    }

    protected boolean needRemove(T element) {
        return false;
    }

    public void beforeRemove(Map.Entry<K, T> eldest) {
    }

    public synchronized T get(K key) {
        Object value = this.map.remove(key);
        return value != null && !this.needRemove(value) ? (T)value : null;
    }

    public synchronized void put(K key, T value) {
        this.map.put(key, value);
    }

    public int size() {
        return this.map.size();
    }

    public synchronized void clear() {
        this.map.clear();
    }

    public Set<Map.Entry<K, T>> values() {
        return this.map.entrySet();
    }

    public Object clone() {
        CacheMap<K, T> newObject = new CacheMap<K, T>(this.maxSize);
        for (Map.Entry<K, T> element : this.values()) {
            newObject.put(element.getKey(), element.getValue());
        }
        return newObject;
    }
}

