/*
 * Decompiled with CFR 0.152.
 */
package com.damnhandy.uri.template;

import com.damnhandy.uri.template.impl.RFC6570UriTemplate;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.BitSet;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public abstract class UriTemplate {
    private DateFormat defaultDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    public static final char[] OPERATORS = new char[]{'+', '#', '.', '/', ';', '?', '&'};
    private static final BitSet OPERATOR_BITSET = new BitSet();
    private StringBuilder expressionBuffer;
    protected Map<String, Object> values = new HashMap<String, Object>();

    public static final UriTemplate fromExpression(String expression) {
        return new RFC6570UriTemplate(expression);
    }

    public static UriTemplate fromTemplate(UriTemplate base) {
        UriTemplate template = UriTemplate.fromExpression(base.getExpression());
        template.set(base.getValues());
        return template;
    }

    public static String expand(String expression, Map<String, Object> values) {
        UriTemplate template = UriTemplate.fromExpression(expression);
        template.set(values);
        return template.expand();
    }

    public String getExpression() {
        return this.expressionBuffer.toString();
    }

    public UriTemplate expression(String expression) {
        if (expression == null) {
            return this;
        }
        this.expressionBuffer.append(expression.trim());
        return this;
    }

    protected void setExpression(String expression) {
        this.expressionBuffer = new StringBuilder(expression);
    }

    public Map<String, Object> getValues() {
        return this.values;
    }

    public UriTemplate withDefaultDateFormat(String dateFormatString) {
        return this.withDefaultDateFormat(new SimpleDateFormat(dateFormatString));
    }

    public UriTemplate withDefaultDateFormat(DateFormat dateFormat) {
        this.defaultDateFormat = dateFormat;
        return this;
    }

    public UriTemplate set(String variableName, Object value) {
        this.values.put(variableName, value);
        return this;
    }

    public UriTemplate set(String variableName, Date value) {
        String date = this.defaultDateFormat.format(value);
        this.values.put(variableName, date);
        return this;
    }

    public UriTemplate set(String variableName, Date value, DateFormat format) {
        this.values.put(variableName, format.format(value));
        return this;
    }

    public UriTemplate set(Map<String, Object> values) {
        this.values.putAll(values);
        return this;
    }

    public abstract String expand(Map<String, Object> var1);

    public abstract String expand();

    protected boolean containsOperator(String op) {
        return OPERATOR_BITSET.get(op.toCharArray()[0]);
    }

    static {
        for (int i = 0; i < OPERATORS.length; ++i) {
            OPERATOR_BITSET.set(OPERATORS[i]);
        }
    }
}

