/*
 * Decompiled with CFR 0.152.
 */
package com.damnhandy.uri.template.impl;

public enum Operator {
    NONE("", ",", ",", false, false),
    RESERVED("+", ",", ",", false, false),
    FRAGMENT("#", ",", ",", false, false),
    NAME_LABEL(".", ",", ".", false, false),
    PATH("/", "/", "/", false, false),
    MATRIX(";", ";", ";", true, true),
    QUERY("?", "&", "&", true, true),
    CONTINUATION("&", "&", "&", true, true);

    private String operator;
    private String separator;
    private boolean queryString;
    private String explodeSeparator;
    private boolean varNameWhenExploded;

    private Operator(String operator, String separator, String explodeJoiner, boolean queryString, boolean varNameWhenExploded) {
        this.operator = operator;
        this.separator = separator;
        this.queryString = queryString;
        this.explodeSeparator = explodeJoiner;
        this.varNameWhenExploded = varNameWhenExploded;
    }

    public String getOperator() {
        return this.operator;
    }

    public String getSeparator() {
        return this.separator;
    }

    public String getExplodeSeparator() {
        return this.explodeSeparator;
    }

    public boolean useQueryString() {
        return this.queryString;
    }

    public String getListSeparator() {
        return ",";
    }

    public boolean useVarNameWhenExploded() {
        return this.varNameWhenExploded;
    }

    public String getPrefix() {
        return this.operator;
    }

    public static Operator fromOpCode(String opCode) {
        for (Operator op : Operator.values()) {
            if (!op.getOperator().equalsIgnoreCase(opCode)) continue;
            return op;
        }
        return null;
    }
}

