/*
 * Decompiled with CFR 0.152.
 */
package com.damnhandy.uri.template.impl;

import com.damnhandy.uri.template.UriTemplate;
import com.damnhandy.uri.template.UriUtil;
import com.damnhandy.uri.template.VarExploder;
import com.damnhandy.uri.template.impl.Modifier;
import com.damnhandy.uri.template.impl.Operator;
import com.damnhandy.uri.template.impl.VarExploderFactory;
import com.damnhandy.uri.template.impl.VarSpec;
import com.damnhandy.uri.template.impl.VariableExpansionException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class RFC6570UriTemplate
extends UriTemplate {
    private static final Pattern URI_TEMPLATE_REGEX = Pattern.compile("\\{[^{}]+\\}");

    public RFC6570UriTemplate(String expression) {
        this.setExpression(expression);
    }

    @Override
    public String expand(Map<String, Object> vars) {
        this.values = vars;
        return this.expand();
    }

    @Override
    public String expand() {
        Matcher matcher = URI_TEMPLATE_REGEX.matcher(this.getExpression());
        StringBuffer buffer = new StringBuffer();
        while (matcher.find()) {
            String token = matcher.group();
            String value = this.buildVarSpecs(token.substring(1, token.length() - 1));
            matcher.appendReplacement(buffer, value);
        }
        matcher.appendTail(buffer);
        return buffer.toString();
    }

    private String findExpressions(Operator operator, List<VarSpec> varSpecs) {
        List<String> replacements = this.expandVariables(operator, varSpecs);
        String result = this.joinParts(operator.getSeparator(), replacements);
        if (result != null) {
            if (operator == Operator.RESERVED || operator == Operator.NAME_LABEL) {
                return result;
            }
            return operator.getPrefix() + result;
        }
        return "";
    }

    private List<String> expandVariables(Operator operator, List<VarSpec> varSpecs) {
        ArrayList<String> replacements = new ArrayList<String>();
        for (VarSpec varSpec : varSpecs) {
            if (!this.values.containsKey(varSpec.getVariableName())) continue;
            Object value = this.values.get(varSpec.getVariableName());
            String expanded = null;
            boolean explodable = this.isExplodable(value);
            if (value != null && value.getClass().isArray()) {
                if (value instanceof char[][]) {
                    char[][] chars = (char[][])value;
                    ArrayList<String> strings = new ArrayList<String>();
                    for (char[] c : chars) {
                        strings.add(String.valueOf(c));
                    }
                    value = strings;
                } else {
                    value = value instanceof char[] ? String.valueOf((char[])value) : this.arrayToList(value);
                }
            }
            if (explodable && varSpec.getModifier() == Modifier.EXPLODE) {
                VarExploder exploder = VarExploderFactory.getExploder(value, varSpec);
                expanded = this.expandMap(operator, varSpec, exploder.getNameValuePairs());
            }
            if (varSpec.getModifier() != Modifier.EXPLODE && value instanceof VarExploder) {
                throw new VariableExpansionException(varSpec.getVariableName() + " was passed a " + VarExploder.class.getSimpleName() + " but the variable did not include the explode modifer.");
            }
            if (value instanceof Date) {
                value = this.defaultDateFormat.format((Date)value);
            }
            if (value instanceof Collection) {
                expanded = this.expandCollection(operator, varSpec, (Collection)value);
            } else if (value instanceof Map) {
                expanded = this.expandMap(operator, varSpec, (Map)value);
            } else if (value == null) {
                expanded = null;
            } else if (expanded == null) {
                expanded = this.expandStringValue(operator, varSpec, value.toString(), VarSpec.VarFormat.SINGLE);
            }
            if (expanded == null) continue;
            replacements.add(expanded);
        }
        return replacements;
    }

    private boolean isExplodable(Object value) {
        if (value == null) {
            return false;
        }
        if (value instanceof Collection || value instanceof Map || value.getClass().isArray()) {
            return true;
        }
        return !value.getClass().isPrimitive() && !value.getClass().isAssignableFrom(CharSequence.class);
    }

    private String expandCollection(Operator operator, VarSpec varSpec, Collection<?> variable) {
        ArrayList<String> stringValues = new ArrayList<String>();
        Iterator<?> i = variable.iterator();
        String joiner = operator.getSeparator();
        joiner = varSpec.getModifier() == Modifier.EXPLODE ? operator.getExplodeSeparator() : operator.getListSeparator();
        while (i.hasNext()) {
            Object obj = i.next();
            this.checkValue(obj);
            String value = obj.toString();
            stringValues.add(this.expandStringValue(operator, varSpec, value, VarSpec.VarFormat.ARRAY));
        }
        if (varSpec.getModifier() != Modifier.EXPLODE && operator.useVarNameWhenExploded()) {
            return varSpec.getVariableName() + "=" + this.joinParts(joiner, stringValues);
        }
        return this.joinParts(joiner, stringValues);
    }

    private void checkValue(Object obj) {
        if (obj instanceof Collection || obj instanceof Map || obj.getClass().isArray()) {
            throw new VariableExpansionException("Nested data structures are not supported.");
        }
    }

    private String expandMap(Operator operator, VarSpec varSpec, Map<String, Object> variable) {
        ArrayList<String> stringValues = new ArrayList<String>();
        String pairJoiner = "=";
        if (varSpec.getModifier() != Modifier.EXPLODE) {
            pairJoiner = ",";
        }
        String joiner = operator.getSeparator();
        if (varSpec.getModifier() != Modifier.EXPLODE) {
            joiner = operator.getListSeparator();
        }
        for (Map.Entry<String, Object> entry : variable.entrySet()) {
            String key = entry.getKey();
            this.checkValue(entry.getValue());
            String pair = this.expandStringValue(operator, varSpec, key, VarSpec.VarFormat.PAIRS) + pairJoiner + this.expandStringValue(operator, varSpec, entry.getValue().toString(), VarSpec.VarFormat.PAIRS);
            stringValues.add(pair);
        }
        if (varSpec.getModifier() != Modifier.EXPLODE && (operator == Operator.MATRIX || operator == Operator.QUERY || operator == Operator.CONTINUATION)) {
            return varSpec.getVariableName() + "=" + this.joinParts(joiner, stringValues);
        }
        return this.joinParts(joiner, stringValues);
    }

    private String expandStringValue(Operator operator, VarSpec varSpec, String variable, VarSpec.VarFormat format) {
        int position;
        String expanded = "";
        if (varSpec.getModifier() == Modifier.PREFIX && (position = varSpec.getPosition().intValue()) < variable.length()) {
            variable = variable.substring(0, position);
        }
        expanded = operator == Operator.FRAGMENT || operator == Operator.RESERVED ? UriUtil.encodeFragment(variable) : UriUtil.encode(variable);
        if (operator.useQueryString()) {
            if (expanded.isEmpty() && !operator.getSeparator().equals("&")) {
                expanded = varSpec.getValue();
            } else if (format == VarSpec.VarFormat.SINGLE) {
                expanded = varSpec.getVariableName() + "=" + expanded;
            } else if (varSpec.getModifier() == Modifier.EXPLODE && operator.useVarNameWhenExploded() && format != VarSpec.VarFormat.PAIRS) {
                expanded = varSpec.getVariableName() + "=" + expanded;
            }
        }
        return expanded;
    }

    private String joinParts(String joiner, List<String> parts) {
        if (parts.size() == 0) {
            return null;
        }
        if (parts.size() == 1) {
            return parts.get(0);
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < parts.size(); ++i) {
            String part = parts.get(i);
            if (part.isEmpty()) continue;
            builder.append(part);
            if (parts.size() <= 0 || i == parts.size() - 1) continue;
            builder.append(joiner);
        }
        return builder.toString();
    }

    private String buildVarSpecs(String token) {
        Operator operator = Operator.NONE;
        String firstChar = token.substring(0, 1);
        if (this.containsOperator(firstChar)) {
            operator = Operator.fromOpCode(firstChar);
            token = token.substring(1, token.length());
        }
        String[] values = token.split(",");
        ArrayList<VarSpec> vars = new ArrayList<VarSpec>();
        for (String value : values) {
            int subStrPos = (value = value.trim()).indexOf(Modifier.PREFIX.getValue());
            if (subStrPos > 0) {
                String[] pair = value.split(Modifier.PREFIX.getValue());
                Integer pos = Integer.valueOf(value.substring(subStrPos + 1));
                vars.add(new VarSpec(pair[0], Modifier.PREFIX, pos));
                continue;
            }
            if (value.lastIndexOf(Modifier.EXPLODE.getValue()) > 0) {
                vars.add(new VarSpec(value, Modifier.EXPLODE));
                continue;
            }
            vars.add(new VarSpec(value, Modifier.NONE));
        }
        return this.findExpressions(operator, vars);
    }

    private List<Object> arrayToList(Object array) {
        ArrayList<Object> list = new ArrayList<Object>();
        int length = Array.getLength(array);
        for (int i = 0; i < length; ++i) {
            Object element = Array.get(array, i);
            if (element.getClass().isArray()) {
                throw new VariableExpansionException("Multi-dimenesional arrays are not supported.");
            }
            list.add(element);
        }
        return list;
    }
}

