/*
 * Decompiled with CFR 0.152.
 */
package com.damnhandy.uri.template;

import com.damnhandy.uri.template.impl.RFC6570UriTemplate;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.BitSet;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public abstract class UriTemplate {
    public static final String DEFAULT_SEPARATOR = ",";
    protected DateFormat defaultDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    static final char[] OPERATORS = new char[]{'+', '#', '.', '/', ';', '?', '&'};
    private static final BitSet OPERATOR_BITSET = new BitSet();
    private StringBuilder templateBuffer;
    protected Map<String, Object> values = new HashMap<String, Object>();

    @Deprecated
    public static final UriTemplate fromExpression(String expression) {
        return new RFC6570UriTemplate(expression);
    }

    public static final UriTemplate fromTemplate(String template) {
        return new RFC6570UriTemplate(template);
    }

    public static UriTemplate fromTemplate(UriTemplate base) {
        UriTemplate template = UriTemplate.fromTemplate(base.getTemplate());
        template.set(base.getValues());
        return template;
    }

    public static String expand(String expression, Map<String, Object> values) {
        UriTemplate template = UriTemplate.fromTemplate(expression);
        template.set(values);
        return template.expand();
    }

    @Deprecated
    public String getExpression() {
        return this.getTemplate();
    }

    public String getTemplate() {
        return this.templateBuffer.toString();
    }

    public UriTemplate append(String template) {
        if (template == null) {
            return this;
        }
        this.templateBuffer.append(template.trim());
        return this;
    }

    @Deprecated
    public UriTemplate expression(String expression) {
        return this.append(expression);
    }

    protected void setTemplate(String template) {
        this.templateBuffer = new StringBuilder(template);
    }

    public Map<String, Object> getValues() {
        return this.values;
    }

    public UriTemplate withDefaultDateFormat(String dateFormatString) {
        return this.withDefaultDateFormat(new SimpleDateFormat(dateFormatString));
    }

    public UriTemplate withDefaultDateFormat(DateFormat dateFormat) {
        this.defaultDateFormat = dateFormat;
        return this;
    }

    public UriTemplate set(String variableName, Object value) {
        this.values.put(variableName, value);
        return this;
    }

    public UriTemplate set(String variableName, Date value) {
        this.values.put(variableName, value);
        return this;
    }

    public UriTemplate set(Map<String, Object> values) {
        this.values.putAll(values);
        return this;
    }

    public abstract String expand(Map<String, Object> var1);

    public abstract String expand();

    public static boolean containsOperator(String op) {
        return OPERATOR_BITSET.get(op.toCharArray()[0]);
    }

    static {
        for (int i = 0; i < OPERATORS.length; ++i) {
            OPERATOR_BITSET.set(OPERATORS[i]);
        }
    }

    public static enum Encoding {
        U,
        UR;

    }
}

