/*
 * Decompiled with CFR 0.152.
 */
package com.damnhandy.uri.template;

import java.io.ByteArrayOutputStream;
import java.nio.charset.Charset;
import java.util.BitSet;

public final class UriUtil {
    private static final BitSet GENERAL_ALLOWED_CHARS = new BitSet();
    private static final BitSet FRAGMENT_ALLOWED_CHARS = new BitSet();
    private static final BitSet RESERVED_ALLOWED_CHARS = new BitSet();

    private static void add(BitSet destination, String toAdd) {
        for (char character : toAdd.toCharArray()) {
            if (character >= '\u007f') {
                throw new IllegalArgumentException("Bitset only works correct with one byte");
            }
            destination.set(character);
        }
    }

    private UriUtil() {
    }

    public static String encodeFragment(String sourceValue) {
        return UriUtil.encode(sourceValue, FRAGMENT_ALLOWED_CHARS);
    }

    public static String encodeReserved(String sourceValue) {
        return UriUtil.encode(sourceValue, RESERVED_ALLOWED_CHARS);
    }

    public static String encode(String sourceValue) {
        return UriUtil.encode(sourceValue, GENERAL_ALLOWED_CHARS);
    }

    private static String encode(String sourceValue, BitSet allowedCharacters) {
        ByteArrayOutputStream out = new ByteArrayOutputStream(sourceValue.length());
        Charset utf8 = Charset.forName("UTF-8");
        byte[] source = sourceValue.getBytes(utf8);
        for (int i = 0; i < source.length; ++i) {
            byte c = source[i];
            if (allowedCharacters.get(c & 0xFF)) {
                out.write(c);
                continue;
            }
            out.write(37);
            char hex1 = Character.toUpperCase(Character.forDigit(c >> 4 & 0xF, 16));
            char hex2 = Character.toUpperCase(Character.forDigit(c & 0xF, 16));
            out.write(hex1);
            out.write(hex2);
        }
        return new String(out.toByteArray(), utf8);
    }

    static {
        String alpha = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
        String digit = "0123456789";
        String unreserved = alpha + digit + "-._~";
        String gendelims = ":/?#[]@";
        String subdelims = "!$&'()*+,;=";
        String reserved = subdelims + gendelims;
        String fragment = unreserved + subdelims + ":@/?";
        UriUtil.add(GENERAL_ALLOWED_CHARS, unreserved);
        UriUtil.add(FRAGMENT_ALLOWED_CHARS, fragment);
        UriUtil.add(RESERVED_ALLOWED_CHARS, unreserved);
        UriUtil.add(RESERVED_ALLOWED_CHARS, reserved);
    }
}

