/*
 * Decompiled with CFR 0.152.
 */
package com.damnhandy.uri.template;

import com.damnhandy.uri.template.Expression;
import com.damnhandy.uri.template.Literal;
import com.damnhandy.uri.template.MalformedUriTemplateException;
import com.damnhandy.uri.template.UriTemplate;
import com.damnhandy.uri.template.UriTemplateComponent;
import com.damnhandy.uri.template.impl.Modifier;
import com.damnhandy.uri.template.impl.UriTemplateParser;
import com.damnhandy.uri.template.impl.VarSpec;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.LinkedList;
import java.util.Map;

public final class UriTemplateBuilder {
    private LinkedList<UriTemplateComponent> components = new LinkedList();
    private DateFormat defaultDateFormat = null;
    private Map<String, Object> values = null;

    UriTemplateBuilder(String templateString) throws MalformedUriTemplateException {
        this.components = new UriTemplateParser().scan(templateString);
    }

    UriTemplateBuilder(UriTemplate template) throws MalformedUriTemplateException {
        this(template.getTemplate());
        this.values = template.getValues();
        this.defaultDateFormat = template.defaultDateFormat;
    }

    public UriTemplateBuilder withDefaultDateFormat(String dateFormatString) {
        return this.withDefaultDateFormat(new SimpleDateFormat(dateFormatString));
    }

    public UriTemplateBuilder withDefaultDateFormat(DateFormat dateFormat) {
        this.defaultDateFormat = dateFormat;
        return this;
    }

    private void addComponent(UriTemplateComponent component) {
        this.components.add(component);
    }

    public UriTemplateBuilder literal(String string) {
        if (string == null) {
            return this;
        }
        this.addComponent(new Literal(string, 0));
        return this;
    }

    private static VarSpec[] toVarSpec(String ... varSpec) {
        VarSpec[] vars = new VarSpec[varSpec.length];
        for (int i = 0; i < varSpec.length; ++i) {
            vars[i] = UriTemplateBuilder.var(varSpec[i]);
        }
        return vars;
    }

    public UriTemplateBuilder simple(String ... var) {
        this.simple(UriTemplateBuilder.toVarSpec(var));
        return this;
    }

    public UriTemplateBuilder simple(VarSpec ... var) {
        this.addComponent(Expression.simple(var).build());
        return this;
    }

    public UriTemplateBuilder reserved(String ... var) {
        this.reserved(UriTemplateBuilder.toVarSpec(var));
        return this;
    }

    public UriTemplateBuilder reserved(VarSpec ... var) {
        this.addComponent(Expression.reserved(var).build());
        return this;
    }

    public UriTemplateBuilder fragment(String ... var) {
        this.fragment(UriTemplateBuilder.toVarSpec(var));
        return this;
    }

    public UriTemplateBuilder fragment(VarSpec ... var) {
        this.addComponent(Expression.fragment(var).build());
        return this;
    }

    public UriTemplateBuilder label(String ... var) {
        this.label(UriTemplateBuilder.toVarSpec(var));
        return this;
    }

    public UriTemplateBuilder label(VarSpec ... var) {
        this.addComponent(Expression.label(var).build());
        return this;
    }

    public UriTemplateBuilder matrix(String ... var) {
        this.matrix(UriTemplateBuilder.toVarSpec(var));
        return this;
    }

    public UriTemplateBuilder matrix(VarSpec ... var) {
        this.addComponent(Expression.matrix(var).build());
        return this;
    }

    public UriTemplateBuilder path(String ... var) {
        this.path(UriTemplateBuilder.toVarSpec(var));
        return this;
    }

    public UriTemplateBuilder path(VarSpec ... var) {
        this.addComponent(Expression.path(var).build());
        return this;
    }

    public UriTemplateBuilder query(String ... var) {
        this.query(UriTemplateBuilder.toVarSpec(var));
        return this;
    }

    public UriTemplateBuilder query(VarSpec ... var) {
        this.addComponent(Expression.query(var).build());
        return this;
    }

    public UriTemplate build() throws MalformedUriTemplateException {
        UriTemplate template = new UriTemplate(this.components);
        if (this.values != null) {
            template.set(this.values);
        }
        if (this.defaultDateFormat != null) {
            template.defaultDateFormat = this.defaultDateFormat;
        }
        return template;
    }

    public static VarSpec var(String varName) {
        return UriTemplateBuilder.var(varName, Modifier.NONE, null);
    }

    public static VarSpec var(String varName, boolean explode) {
        if (explode) {
            return UriTemplateBuilder.var(varName, Modifier.EXPLODE, null);
        }
        return UriTemplateBuilder.var(varName, Modifier.NONE, null);
    }

    public static VarSpec var(String varName, int prefix) {
        return UriTemplateBuilder.var(varName, Modifier.PREFIX, prefix);
    }

    private static VarSpec var(String varName, Modifier modifier, Integer position) {
        return new VarSpec(varName, modifier, position);
    }
}

