/*
 * Decompiled with CFR 0.152.
 */
package com.damnhandy.uri.template.impl;

import com.damnhandy.uri.template.Expression;
import com.damnhandy.uri.template.Literal;
import com.damnhandy.uri.template.MalformedUriTemplateException;
import com.damnhandy.uri.template.UriTemplateComponent;
import java.util.LinkedList;

public final class UriTemplateParser {
    private static final char EXPR_START = '{';
    private static final char EXPR_END = '}';
    private boolean startedTemplate = false;
    private boolean expressionCaptureOn = false;
    private boolean literalCaptureOn = false;
    private LinkedList<UriTemplateComponent> components = new LinkedList();
    private StringBuilder buffer;
    private int startPosition;
    private char[] template;

    public LinkedList<UriTemplateComponent> scan(String templateString) throws MalformedUriTemplateException {
        int i;
        this.template = templateString.toCharArray();
        this.startTemplate();
        for (i = 0; i < this.template.length; ++i) {
            char c = this.template[i];
            if (c == '{') {
                if (this.literalCaptureOn) {
                    this.endLiteral(i);
                }
                this.startExpression(i);
            }
            if (c != '{' || c != '}') {
                this.startLiteral(i);
            }
            if (this.expressionCaptureOn || this.literalCaptureOn) {
                this.capture(c);
            }
            if (c != '}') continue;
            this.endExpression(i);
            this.startLiteral(i);
        }
        if (this.literalCaptureOn) {
            this.endLiteral(i);
        }
        this.endTemplate(i);
        return this.components;
    }

    private void capture(char currentChar) {
        if (this.buffer == null) {
            this.buffer = new StringBuilder();
        }
        this.buffer.append(currentChar);
    }

    private void startTemplate() {
        this.startedTemplate = true;
    }

    private void endTemplate(int position) throws MalformedUriTemplateException {
        this.startedTemplate = false;
        if (this.expressionCaptureOn) {
            throw new MalformedUriTemplateException("Template scanning complete, but the start of an expression at " + this.startPosition + " was never terminated");
        }
    }

    private void startLiteral(int position) throws MalformedUriTemplateException {
        if (this.startedTemplate) {
            if (!this.literalCaptureOn) {
                this.literalCaptureOn = true;
                this.startPosition = position;
            }
        } else {
            throw new IllegalStateException("Cannot start a literal without beginning the template");
        }
    }

    private void endLiteral(int position) throws MalformedUriTemplateException {
        if (this.startedTemplate) {
            if (!this.literalCaptureOn) {
                throw new IllegalStateException("Can't end a literal without starting it first");
            }
            if (this.buffer != null) {
                this.components.add(new Literal(this.buffer.toString(), this.startPosition));
                this.literalCaptureOn = false;
                this.buffer = null;
            }
        } else {
            throw new IllegalStateException("Cannot end a literal without beginning the template");
        }
    }

    private void startExpression(int position) throws MalformedUriTemplateException {
        if (this.startedTemplate) {
            if (this.expressionCaptureOn) {
                throw new MalformedUriTemplateException("A new expression start brace found at " + position + " but another unclosed expression was found at " + this.startPosition);
            }
        } else {
            throw new IllegalStateException("Cannot start an expression without beginning the template");
        }
        this.literalCaptureOn = false;
        this.expressionCaptureOn = true;
        this.startPosition = position;
    }

    private void endExpression(int position) throws MalformedUriTemplateException {
        if (this.startedTemplate) {
            if (!this.expressionCaptureOn) {
                throw new MalformedUriTemplateException("Expression close brace was found at position " + position + " yet there was no start brace.");
            }
        } else {
            throw new IllegalStateException("Cannot end an expression without beginning the template");
        }
        this.expressionCaptureOn = false;
        this.components.add(new Expression(this.buffer.toString(), this.startPosition));
        this.buffer = null;
    }
}

