/*
 * Decompiled with CFR 0.152.
 */
package com.dampcake.bencode;

import com.dampcake.bencode.BencodeException;
import com.dampcake.bencode.BencodeInputStream;
import com.dampcake.bencode.BencodeOutputStream;
import com.dampcake.bencode.Type;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.nio.charset.Charset;
import java.util.Map;

public final class Bencode {
    static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");
    static final char NUMBER = 'i';
    static final char LIST = 'l';
    static final char DICTIONARY = 'd';
    static final char TERMINATOR = 'e';
    static final char SEPARATOR = ':';
    private final Charset charset;
    private final boolean useBytes;

    public Bencode() {
        this(DEFAULT_CHARSET);
    }

    public Bencode(Charset charset) {
        this(charset, false);
    }

    public Bencode(boolean useBytes) {
        this(DEFAULT_CHARSET, useBytes);
    }

    public Bencode(Charset charset, boolean useBytes) {
        if (charset == null) {
            throw new NullPointerException("charset cannot be null");
        }
        this.charset = charset;
        this.useBytes = useBytes;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public Type type(byte[] bytes) {
        if (bytes == null) {
            throw new NullPointerException("bytes cannot be null");
        }
        BencodeInputStream in = new BencodeInputStream(new ByteArrayInputStream(bytes), this.charset, this.useBytes);
        try {
            return in.nextType();
        }
        catch (Throwable t) {
            throw new BencodeException("Exception thrown during type detection", t);
        }
    }

    public <T> T decode(byte[] bytes, Type<T> type) {
        if (bytes == null) {
            throw new NullPointerException("bytes cannot be null");
        }
        if (type == null) {
            throw new NullPointerException("type cannot be null");
        }
        if (type == Type.UNKNOWN) {
            throw new IllegalArgumentException("type cannot be UNKNOWN");
        }
        BencodeInputStream in = new BencodeInputStream(new ByteArrayInputStream(bytes), this.charset, this.useBytes);
        try {
            if (type == Type.NUMBER) {
                return (T)in.readNumber();
            }
            if (type == Type.LIST) {
                return (T)in.readList();
            }
            if (type == Type.DICTIONARY) {
                return (T)in.readDictionary();
            }
            return (T)in.readString();
        }
        catch (Throwable t) {
            throw new BencodeException("Exception thrown during decoding", t);
        }
    }

    public byte[] encode(String s) {
        if (s == null) {
            throw new NullPointerException("s cannot be null");
        }
        return this.encode(s, Type.STRING);
    }

    public byte[] encode(Number n) {
        if (n == null) {
            throw new NullPointerException("n cannot be null");
        }
        return this.encode(n, Type.NUMBER);
    }

    public byte[] encode(Iterable<?> l) {
        if (l == null) {
            throw new NullPointerException("l cannot be null");
        }
        return this.encode(l, Type.LIST);
    }

    public byte[] encode(Map<?, ?> m) {
        if (m == null) {
            throw new NullPointerException("m cannot be null");
        }
        return this.encode(m, Type.DICTIONARY);
    }

    private byte[] encode(Object o, Type type) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        BencodeOutputStream bencode = new BencodeOutputStream(out, this.charset);
        try {
            if (type == Type.STRING) {
                bencode.writeString((String)o);
            } else if (type == Type.NUMBER) {
                bencode.writeNumber((Number)o);
            } else if (type == Type.LIST) {
                bencode.writeList((Iterable)o);
            } else if (type == Type.DICTIONARY) {
                bencode.writeDictionary((Map)o);
            }
        }
        catch (Throwable t) {
            throw new BencodeException("Exception thrown during encoding", t);
        }
        return out.toByteArray();
    }
}

