/*
 * Decompiled with CFR 0.152.
 */
package com.dampcake.bencode;

import com.dampcake.bencode.Bencode;
import com.dampcake.bencode.Type;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.io.PushbackInputStream;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class BencodeInputStream
extends FilterInputStream {
    private static final int EOF = -1;
    private final Charset charset;
    private final boolean useBytes;
    private final PushbackInputStream in;

    public BencodeInputStream(InputStream in, Charset charset, boolean useBytes) {
        super(new PushbackInputStream(in));
        this.in = (PushbackInputStream)((FilterInputStream)this).in;
        if (charset == null) {
            throw new NullPointerException("charset cannot be null");
        }
        this.charset = charset;
        this.useBytes = useBytes;
    }

    public BencodeInputStream(InputStream in, Charset charset) {
        this(in, charset, false);
    }

    public BencodeInputStream(InputStream in) {
        this(in, Bencode.DEFAULT_CHARSET);
    }

    public Charset getCharset() {
        return this.charset;
    }

    private int peek() throws IOException {
        int b = this.in.read();
        this.in.unread(b);
        return b;
    }

    public Type nextType() throws IOException {
        int token = this.peek();
        this.checkEOF(token);
        return this.typeForToken(token);
    }

    private Type typeForToken(int token) {
        for (Type type : Type.values()) {
            if (!type.validate(token)) continue;
            return type;
        }
        return Type.UNKNOWN;
    }

    public String readString() throws IOException {
        return new String(this.readStringBytesInternal(), this.getCharset());
    }

    public ByteBuffer readStringBytes() throws IOException {
        return ByteBuffer.wrap(this.readStringBytesInternal());
    }

    private byte[] readStringBytesInternal() throws IOException {
        int token = this.in.read();
        this.validateToken(token, Type.STRING);
        StringBuilder buffer = new StringBuilder();
        buffer.append((char)token);
        while ((token = this.in.read()) != 58) {
            this.validateToken(token, Type.STRING);
            buffer.append((char)token);
        }
        int length = Integer.parseInt(buffer.toString());
        byte[] bytes = new byte[length];
        this.read(bytes);
        return bytes;
    }

    public Long readNumber() throws IOException {
        int token = this.in.read();
        this.validateToken(token, Type.NUMBER);
        StringBuilder buffer = new StringBuilder();
        while ((token = this.in.read()) != 101) {
            this.checkEOF(token);
            buffer.append((char)token);
        }
        return new BigDecimal(buffer.toString()).longValue();
    }

    public List<Object> readList() throws IOException {
        int token = this.in.read();
        this.validateToken(token, Type.LIST);
        ArrayList<Object> list = new ArrayList<Object>();
        while ((token = this.in.read()) != 101) {
            this.checkEOF(token);
            list.add(this.readObject(token));
        }
        return list;
    }

    public Map<String, Object> readDictionary() throws IOException {
        int token = this.in.read();
        this.validateToken(token, Type.DICTIONARY);
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        while ((token = this.in.read()) != 101) {
            this.checkEOF(token);
            this.in.unread(token);
            map.put(this.readString(), this.readObject(this.in.read()));
        }
        return map;
    }

    private Object readObject(int token) throws IOException {
        this.in.unread(token);
        Type type = this.typeForToken(token);
        if (type == Type.STRING && !this.useBytes) {
            return this.readString();
        }
        if (type == Type.STRING && this.useBytes) {
            return this.readStringBytes();
        }
        if (type == Type.NUMBER) {
            return this.readNumber();
        }
        if (type == Type.LIST) {
            return this.readList();
        }
        if (type == Type.DICTIONARY) {
            return this.readDictionary();
        }
        throw new InvalidObjectException("Unexpected token '" + new String(Character.toChars(token)) + "'");
    }

    private void validateToken(int token, Type type) throws IOException {
        this.checkEOF(token);
        if (!type.validate(token)) {
            this.in.unread(token);
            throw new InvalidObjectException("Unexpected token '" + new String(Character.toChars(token)) + "'");
        }
    }

    private void checkEOF(int b) throws EOFException {
        if (b == -1) {
            throw new EOFException();
        }
    }
}

