/*
 * Decompiled with CFR 0.152.
 */
package com.dampcake.bencode;

import com.dampcake.bencode.StringValidator;
import com.dampcake.bencode.TypeValidator;
import com.dampcake.bencode.Validator;
import java.util.List;
import java.util.Map;

public class Type<T> {
    public static final Type<String> STRING = new Type(new StringValidator());
    public static final Type<Long> NUMBER = new Type(new TypeValidator('i'));
    public static final Type<List<Object>> LIST = new Type(new TypeValidator('l'));
    public static final Type<Map<String, Object>> DICTIONARY = new Type(new TypeValidator('d'));
    public static final Type<Void> UNKNOWN = new Type(new Validator(){

        @Override
        public boolean validate(int token) {
            return false;
        }
    });
    private final Validator validator;

    private Type(Validator validator) {
        this.validator = validator;
    }

    boolean validate(int token) {
        return this.validator.validate(token);
    }

    public static Type[] values() {
        return new Type[]{STRING, NUMBER, LIST, DICTIONARY, UNKNOWN};
    }
}

