/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.event.rdb;

import com.dangdang.ddframe.job.context.ExecutionType;
import com.dangdang.ddframe.job.event.type.JobExecutionEvent;
import com.dangdang.ddframe.job.event.type.JobStatusTraceEvent;
import com.google.common.base.Strings;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JobEventRdbStorage {
    private static final Logger log = LoggerFactory.getLogger(JobEventRdbStorage.class);
    private static final String TABLE_JOB_EXECUTION_LOG = "JOB_EXECUTION_LOG";
    private static final String TABLE_JOB_STATUS_TRACE_LOG = "JOB_STATUS_TRACE_LOG";
    private static final String TASK_ID_STATE_INDEX = "TASK_ID_STATE_INDEX";
    private final DataSource dataSource;

    JobEventRdbStorage(DataSource dataSource) throws SQLException {
        this.dataSource = dataSource;
        this.initTablesAndIndexes();
    }

    private void initTablesAndIndexes() throws SQLException {
        try (Connection conn = this.dataSource.getConnection();){
            this.createJobExecutionTableAndIndexIfNeeded(conn);
            this.createJobStatusTraceTableAndIndexIfNeeded(conn);
        }
    }

    private void createJobExecutionTableAndIndexIfNeeded(Connection conn) throws SQLException {
        DatabaseMetaData dbMetaData = conn.getMetaData();
        try (ResultSet resultSet = dbMetaData.getTables(null, null, TABLE_JOB_EXECUTION_LOG, new String[]{"TABLE"});){
            if (!resultSet.next()) {
                this.createJobExecutionTable(conn);
            }
        }
    }

    private void createJobStatusTraceTableAndIndexIfNeeded(Connection conn) throws SQLException {
        DatabaseMetaData dbMetaData = conn.getMetaData();
        try (ResultSet resultSet = dbMetaData.getTables(null, null, TABLE_JOB_STATUS_TRACE_LOG, new String[]{"TABLE"});){
            if (!resultSet.next()) {
                this.createJobStatusTraceTable(conn);
            }
        }
        this.createTaskIdIndexIfNeeded(conn, TABLE_JOB_STATUS_TRACE_LOG, TASK_ID_STATE_INDEX);
    }

    private void createTaskIdIndexIfNeeded(Connection conn, String tableName, String indexName) throws SQLException {
        DatabaseMetaData dbMetaData = conn.getMetaData();
        try (ResultSet resultSet = dbMetaData.getIndexInfo(null, null, tableName, false, false);){
            boolean hasTaskIdIndex = false;
            while (resultSet.next()) {
                if (!indexName.equals(resultSet.getString("INDEX_NAME"))) continue;
                hasTaskIdIndex = true;
            }
            if (!hasTaskIdIndex) {
                this.createTaskIdAndStateIndex(conn, tableName);
            }
        }
    }

    private void createJobExecutionTable(Connection conn) throws SQLException {
        String dbSchema = "CREATE TABLE `JOB_EXECUTION_LOG` (`id` VARCHAR(40) NOT NULL, `job_name` VARCHAR(100) NOT NULL, `task_id` VARCHAR(255) NOT NULL, `hostname` VARCHAR(255) NOT NULL, `ip` VARCHAR(50) NOT NULL, `sharding_item` INT NOT NULL, `execution_source` VARCHAR(20) NOT NULL, `failure_cause` VARCHAR(4000) NULL, `is_success` BIT NOT NULL, `start_time` TIMESTAMP NOT NULL, `complete_time` TIMESTAMP NULL, PRIMARY KEY (`id`));";
        try (PreparedStatement preparedStatement = conn.prepareStatement(dbSchema);){
            preparedStatement.execute();
        }
    }

    private void createJobStatusTraceTable(Connection conn) throws SQLException {
        String dbSchema = "CREATE TABLE `JOB_STATUS_TRACE_LOG` (`id` VARCHAR(40) NOT NULL, `job_name` VARCHAR(100) NOT NULL, `original_task_id` VARCHAR(255) NOT NULL, `task_id` VARCHAR(255) NOT NULL, `slave_id` VARCHAR(50) NOT NULL, `source` VARCHAR(50) NOT NULL, `execution_type` VARCHAR(20) NOT NULL, `sharding_item` VARCHAR(100) NOT NULL, `state` VARCHAR(20) NOT NULL, `message` VARCHAR(4000) NULL, `creation_time` TIMESTAMP NULL, PRIMARY KEY (`id`));";
        try (PreparedStatement preparedStatement = conn.prepareStatement(dbSchema);){
            preparedStatement.execute();
        }
    }

    private void createTaskIdAndStateIndex(Connection conn, String tableName) throws SQLException {
        String sql = "CREATE INDEX TASK_ID_STATE_INDEX ON " + tableName + " (`task_id`, `state`);";
        try (PreparedStatement preparedStatement = conn.prepareStatement(sql);){
            preparedStatement.execute();
        }
    }

    boolean addJobExecutionEvent(JobExecutionEvent jobExecutionEvent) {
        boolean result = false;
        if (null == jobExecutionEvent.getCompleteTime()) {
            String sql = "INSERT INTO `JOB_EXECUTION_LOG` (`id`, `job_name`, `task_id`, `hostname`, `ip`, `sharding_item`, `execution_source`, `is_success`, `start_time`) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?);";
            try (Connection conn = this.dataSource.getConnection();
                 PreparedStatement preparedStatement = conn.prepareStatement(sql);){
                preparedStatement.setString(1, jobExecutionEvent.getId());
                preparedStatement.setString(2, jobExecutionEvent.getJobName());
                preparedStatement.setString(3, jobExecutionEvent.getTaskId());
                preparedStatement.setString(4, jobExecutionEvent.getHostname());
                preparedStatement.setString(5, jobExecutionEvent.getIp());
                preparedStatement.setInt(6, jobExecutionEvent.getShardingItem());
                preparedStatement.setString(7, jobExecutionEvent.getSource().toString());
                preparedStatement.setBoolean(8, jobExecutionEvent.isSuccess());
                preparedStatement.setTimestamp(9, new Timestamp(jobExecutionEvent.getStartTime().getTime()));
                preparedStatement.execute();
                result = true;
            }
            catch (SQLException ex) {
                log.error(ex.getMessage());
            }
        } else if (jobExecutionEvent.isSuccess()) {
            String sql = "UPDATE `JOB_EXECUTION_LOG` SET `is_success` = ?, `complete_time` = ? WHERE id = ?";
            try (Connection conn = this.dataSource.getConnection();
                 PreparedStatement preparedStatement = conn.prepareStatement(sql);){
                preparedStatement.setBoolean(1, jobExecutionEvent.isSuccess());
                preparedStatement.setTimestamp(2, new Timestamp(jobExecutionEvent.getCompleteTime().getTime()));
                preparedStatement.setString(3, jobExecutionEvent.getId());
                preparedStatement.execute();
                result = true;
            }
            catch (SQLException ex) {
                log.error(ex.getMessage());
            }
        } else {
            String sql = "UPDATE `JOB_EXECUTION_LOG` SET `is_success` = ?, `failure_cause` = ? WHERE id = ?";
            try (Connection conn = this.dataSource.getConnection();
                 PreparedStatement preparedStatement = conn.prepareStatement(sql);){
                preparedStatement.setBoolean(1, jobExecutionEvent.isSuccess());
                preparedStatement.setString(2, this.truncateString(jobExecutionEvent.getFailureCause()));
                preparedStatement.setString(3, jobExecutionEvent.getId());
                preparedStatement.execute();
                result = true;
            }
            catch (SQLException ex) {
                log.error(ex.getMessage());
            }
        }
        return result;
    }

    boolean addJobStatusTraceEvent(JobStatusTraceEvent jobStatusTraceEvent) {
        String originalTaskId = jobStatusTraceEvent.getOriginalTaskId();
        if (JobStatusTraceEvent.State.TASK_STAGING != jobStatusTraceEvent.getState()) {
            originalTaskId = this.getOriginalTaskId(jobStatusTraceEvent.getTaskId());
        }
        boolean result = false;
        String sql = "INSERT INTO `JOB_STATUS_TRACE_LOG` (`id`, `job_name`, `original_task_id`, `task_id`, `slave_id`, `source`, `execution_type`, `sharding_item`,  `state`, `message`, `creation_time`) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);";
        try (Connection conn = this.dataSource.getConnection();
             PreparedStatement preparedStatement = conn.prepareStatement(sql);){
            preparedStatement.setString(1, UUID.randomUUID().toString());
            preparedStatement.setString(2, jobStatusTraceEvent.getJobName());
            preparedStatement.setString(3, originalTaskId);
            preparedStatement.setString(4, jobStatusTraceEvent.getTaskId());
            preparedStatement.setString(5, jobStatusTraceEvent.getSlaveId());
            preparedStatement.setString(6, jobStatusTraceEvent.getSource().toString());
            preparedStatement.setString(7, jobStatusTraceEvent.getExecutionType().name());
            preparedStatement.setString(8, jobStatusTraceEvent.getShardingItems());
            preparedStatement.setString(9, jobStatusTraceEvent.getState().toString());
            preparedStatement.setString(10, this.truncateString(jobStatusTraceEvent.getMessage()));
            preparedStatement.setTimestamp(11, new Timestamp(jobStatusTraceEvent.getCreationTime().getTime()));
            preparedStatement.execute();
            result = true;
        }
        catch (SQLException ex) {
            log.error(ex.getMessage());
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getOriginalTaskId(String taskId) {
        String sql = String.format("SELECT original_task_id FROM %s WHERE task_id = '%s' and state='%s'", new Object[]{TABLE_JOB_STATUS_TRACE_LOG, taskId, JobStatusTraceEvent.State.TASK_STAGING});
        String result = "";
        try (Connection conn = this.dataSource.getConnection();
             PreparedStatement preparedStatement = conn.prepareStatement(sql);
             ResultSet resultSet = preparedStatement.executeQuery();){
            if (!resultSet.next()) return result;
            String string = resultSet.getString("original_task_id");
            return string;
        }
        catch (SQLException ex) {
            log.error(ex.getMessage());
        }
        return result;
    }

    private String truncateString(String str) {
        return !Strings.isNullOrEmpty((String)str) && str.length() > 4000 ? str.substring(0, 4000) : str;
    }

    List<JobStatusTraceEvent> getJobStatusTraceEvents(String taskId) {
        String sql = String.format("SELECT * FROM %s WHERE task_id = '%s'", TABLE_JOB_STATUS_TRACE_LOG, taskId);
        ArrayList<JobStatusTraceEvent> result = new ArrayList<JobStatusTraceEvent>();
        try (Connection conn = this.dataSource.getConnection();
             PreparedStatement preparedStatement = conn.prepareStatement(sql);
             ResultSet resultSet = preparedStatement.executeQuery();){
            while (resultSet.next()) {
                JobStatusTraceEvent jobStatusTraceEvent = new JobStatusTraceEvent(resultSet.getString(1), resultSet.getString(2), resultSet.getString(3), resultSet.getString(4), resultSet.getString(5), JobStatusTraceEvent.Source.valueOf(resultSet.getString(6)), ExecutionType.valueOf(resultSet.getString(7)), resultSet.getString(8), JobStatusTraceEvent.State.valueOf(resultSet.getString(9)), resultSet.getString(10), new SimpleDateFormat("yyyy-mm-dd HH:MM:SS").parse(resultSet.getString(11)));
                result.add(jobStatusTraceEvent);
            }
        }
        catch (SQLException | ParseException ex) {
            log.error(ex.getMessage());
        }
        return result;
    }
}

