/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.event.type;

import com.dangdang.ddframe.job.event.JobEvent;
import com.dangdang.ddframe.job.event.type.JobExecutionEventThrowable;
import com.dangdang.ddframe.job.exception.ExceptionUtil;
import com.dangdang.ddframe.job.util.env.LocalHostService;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.UUID;

public class JobExecutionEvent
implements JobEvent {
    private static LocalHostService localHostService = new LocalHostService();
    private String id = UUID.randomUUID().toString();
    private String hostname = localHostService.getHostName();
    private String ip = localHostService.getIp();
    private final String taskId;
    private final String jobName;
    private final ExecutionSource source;
    private final int shardingItem;
    private Date startTime = new Date();
    private Date completeTime;
    private boolean success;
    private JobExecutionEventThrowable failureCause;

    public JobExecutionEvent executionSuccess() {
        JobExecutionEvent result = new JobExecutionEvent(this.id, this.hostname, this.ip, this.taskId, this.jobName, this.source, this.shardingItem, this.startTime, this.completeTime, this.success, this.failureCause);
        result.setCompleteTime(new Date());
        result.setSuccess(true);
        return result;
    }

    public JobExecutionEvent executionFailure(Throwable failureCause) {
        JobExecutionEvent result = new JobExecutionEvent(this.id, this.hostname, this.ip, this.taskId, this.jobName, this.source, this.shardingItem, this.startTime, this.completeTime, this.success, new JobExecutionEventThrowable(failureCause));
        result.setCompleteTime(new Date());
        result.setSuccess(false);
        return result;
    }

    public String getFailureCause() {
        return ExceptionUtil.transform(this.failureCause == null ? null : this.failureCause.getThrowable());
    }

    @ConstructorProperties(value={"taskId", "jobName", "source", "shardingItem"})
    public JobExecutionEvent(String taskId, String jobName, ExecutionSource source, int shardingItem) {
        this.taskId = taskId;
        this.jobName = jobName;
        this.source = source;
        this.shardingItem = shardingItem;
    }

    @ConstructorProperties(value={"id", "hostname", "ip", "taskId", "jobName", "source", "shardingItem", "startTime", "completeTime", "success", "failureCause"})
    public JobExecutionEvent(String id, String hostname, String ip, String taskId, String jobName, ExecutionSource source, int shardingItem, Date startTime, Date completeTime, boolean success, JobExecutionEventThrowable failureCause) {
        this.id = id;
        this.hostname = hostname;
        this.ip = ip;
        this.taskId = taskId;
        this.jobName = jobName;
        this.source = source;
        this.shardingItem = shardingItem;
        this.startTime = startTime;
        this.completeTime = completeTime;
        this.success = success;
        this.failureCause = failureCause;
    }

    public String getId() {
        return this.id;
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getIp() {
        return this.ip;
    }

    public String getTaskId() {
        return this.taskId;
    }

    @Override
    public String getJobName() {
        return this.jobName;
    }

    public ExecutionSource getSource() {
        return this.source;
    }

    public int getShardingItem() {
        return this.shardingItem;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getCompleteTime() {
        return this.completeTime;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setCompleteTime(Date completeTime) {
        this.completeTime = completeTime;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public void setFailureCause(JobExecutionEventThrowable failureCause) {
        this.failureCause = failureCause;
    }

    public static enum ExecutionSource {
        NORMAL_TRIGGER,
        MISFIRE,
        FAILOVER;

    }
}

