/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.event;

import com.dangdang.ddframe.job.event.JobEvent;
import com.dangdang.ddframe.job.event.JobEventConfiguration;
import com.dangdang.ddframe.job.event.JobEventListenerConfigurationException;
import com.dangdang.ddframe.job.util.concurrent.ExecutorServiceObject;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.EventBus;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobEventBus {
    private static final Logger log = LoggerFactory.getLogger(JobEventBus.class);
    private final JobEventConfiguration jobEventConfig;
    private final ExecutorServiceObject executorServiceObject;
    private final EventBus eventBus;
    private boolean isRegistered;

    public JobEventBus() {
        this.jobEventConfig = null;
        this.executorServiceObject = null;
        this.eventBus = null;
    }

    public JobEventBus(JobEventConfiguration jobEventConfig) {
        this.jobEventConfig = jobEventConfig;
        this.executorServiceObject = new ExecutorServiceObject("job-event", Runtime.getRuntime().availableProcessors() * 2);
        this.eventBus = new AsyncEventBus((Executor)this.executorServiceObject.createExecutorService());
        this.register();
    }

    private void register() {
        try {
            this.eventBus.register((Object)this.jobEventConfig.createJobEventListener());
            this.isRegistered = true;
        }
        catch (JobEventListenerConfigurationException ex) {
            log.error("Elastic job: create JobEventListener failure, error is: ", (Throwable)ex);
        }
    }

    public void post(JobEvent event) {
        if (this.isRegistered && !this.executorServiceObject.isShutdown()) {
            this.eventBus.post((Object)event);
        }
    }
}

