/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.reg.zookeeper;

import com.dangdang.ddframe.job.reg.base.ElectionCandidate;
import java.util.concurrent.CountDownLatch;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.leader.LeaderSelector;
import org.apache.curator.framework.recipes.leader.LeaderSelectorListener;
import org.apache.curator.framework.recipes.leader.LeaderSelectorListenerAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZookeeperElectionService {
    private static final Logger log = LoggerFactory.getLogger(ZookeeperElectionService.class);
    private final CountDownLatch leaderLatch = new CountDownLatch(1);
    private final LeaderSelector leaderSelector;

    public ZookeeperElectionService(final String identity, CuratorFramework client, String electionPath, final ElectionCandidate electionCandidate) {
        this.leaderSelector = new LeaderSelector(client, electionPath, (LeaderSelectorListener)new LeaderSelectorListenerAdapter(){

            public void takeLeadership(CuratorFramework client) throws Exception {
                log.info("Elastic job: {} has leadership", (Object)identity);
                try {
                    electionCandidate.startLeadership();
                    ZookeeperElectionService.this.leaderLatch.await();
                }
                catch (InterruptedException ex) {
                    log.warn("Elastic job: {} lost leadership.", (Object)identity);
                }
                finally {
                    electionCandidate.stopLeadership();
                }
            }
        });
        this.leaderSelector.autoRequeue();
        this.leaderSelector.setId(identity);
    }

    public void start() {
        log.debug("Elastic job: {} start to elect leadership", (Object)this.leaderSelector.getId());
        this.leaderSelector.start();
    }

    public void stop() {
        log.info("Elastic job: stop leadership election");
        this.leaderLatch.countDown();
        try {
            this.leaderSelector.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

