/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.util.env;

import com.dangdang.ddframe.job.util.env.HostException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;

public class LocalHostService {
    private static volatile String cachedIpAddress;

    public String getIp() {
        Enumeration<NetworkInterface> netInterfaces;
        if (null != cachedIpAddress) {
            return cachedIpAddress;
        }
        try {
            netInterfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException ex) {
            throw new HostException(ex);
        }
        String localIpAddress = null;
        while (netInterfaces.hasMoreElements()) {
            NetworkInterface netInterface = netInterfaces.nextElement();
            Enumeration<InetAddress> ipAddresses = netInterface.getInetAddresses();
            while (ipAddresses.hasMoreElements()) {
                InetAddress ipAddress = ipAddresses.nextElement();
                if (this.isPublicIpAddress(ipAddress)) {
                    String publicIpAddress;
                    cachedIpAddress = publicIpAddress = ipAddress.getHostAddress();
                    return publicIpAddress;
                }
                if (!this.isLocalIpAddress(ipAddress)) continue;
                localIpAddress = ipAddress.getHostAddress();
            }
        }
        cachedIpAddress = localIpAddress;
        return localIpAddress;
    }

    private boolean isPublicIpAddress(InetAddress ipAddress) {
        return !ipAddress.isSiteLocalAddress() && !ipAddress.isLoopbackAddress() && !this.isV6IpAddress(ipAddress);
    }

    private boolean isLocalIpAddress(InetAddress ipAddress) {
        return ipAddress.isSiteLocalAddress() && !ipAddress.isLoopbackAddress() && !this.isV6IpAddress(ipAddress);
    }

    private boolean isV6IpAddress(InetAddress ipAddress) {
        return ipAddress.getHostAddress().contains(":");
    }

    public String getHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException ex) {
            throw new HostException(ex);
        }
    }
}

