/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.event.type;

import com.dangdang.ddframe.job.context.ExecutionType;
import com.dangdang.ddframe.job.event.JobEvent;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.UUID;

public final class JobStatusTraceEvent
implements JobEvent {
    private String id = UUID.randomUUID().toString();
    private final String jobName;
    private String originalTaskId = "";
    private final String taskId;
    private final String slaveId;
    private final Source source;
    private final ExecutionType executionType;
    private final String shardingItems;
    private final State state;
    private final String message;
    private Date creationTime = new Date();

    @ConstructorProperties(value={"jobName", "taskId", "slaveId", "source", "executionType", "shardingItems", "state", "message"})
    public JobStatusTraceEvent(String jobName, String taskId, String slaveId, Source source, ExecutionType executionType, String shardingItems, State state, String message) {
        this.jobName = jobName;
        this.taskId = taskId;
        this.slaveId = slaveId;
        this.source = source;
        this.executionType = executionType;
        this.shardingItems = shardingItems;
        this.state = state;
        this.message = message;
    }

    @ConstructorProperties(value={"id", "jobName", "originalTaskId", "taskId", "slaveId", "source", "executionType", "shardingItems", "state", "message", "creationTime"})
    public JobStatusTraceEvent(String id, String jobName, String originalTaskId, String taskId, String slaveId, Source source, ExecutionType executionType, String shardingItems, State state, String message, Date creationTime) {
        this.id = id;
        this.jobName = jobName;
        this.originalTaskId = originalTaskId;
        this.taskId = taskId;
        this.slaveId = slaveId;
        this.source = source;
        this.executionType = executionType;
        this.shardingItems = shardingItems;
        this.state = state;
        this.message = message;
        this.creationTime = creationTime;
    }

    public String getId() {
        return this.id;
    }

    @Override
    public String getJobName() {
        return this.jobName;
    }

    public String getOriginalTaskId() {
        return this.originalTaskId;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public String getSlaveId() {
        return this.slaveId;
    }

    public Source getSource() {
        return this.source;
    }

    public ExecutionType getExecutionType() {
        return this.executionType;
    }

    public String getShardingItems() {
        return this.shardingItems;
    }

    public State getState() {
        return this.state;
    }

    public String getMessage() {
        return this.message;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public void setOriginalTaskId(String originalTaskId) {
        this.originalTaskId = originalTaskId;
    }

    public static enum Source {
        CLOUD_SCHEDULER,
        CLOUD_EXECUTOR,
        LITE_EXECUTOR;

    }

    public static enum State {
        TASK_STAGING,
        TASK_RUNNING,
        TASK_FINISHED,
        TASK_KILLED,
        TASK_LOST,
        TASK_FAILED,
        TASK_ERROR;

    }
}

