/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.security;

import com.google.common.base.Strings;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WwwAuthFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(WwwAuthFilter.class);
    private static final String AUTH_PREFIX = "Basic ";
    private static final String GUEST = "guest";
    private static final String ROOT = "root";
    private String rootUsername;
    private String rootPassword;
    private String guestUsername;
    private String guestPassword;

    public void init(FilterConfig filterConfig) throws ServletException {
        String fileSeparator = System.getProperty("file.separator");
        String configFilePath = Thread.currentThread().getContextClassLoader().getResource("").getPath() + fileSeparator + "conf" + fileSeparator + "auth.properties";
        Properties props = new Properties();
        try {
            props.load(new FileInputStream(configFilePath));
        }
        catch (IOException ex) {
            log.warn("Cannot found auth config file, use default auth config.");
        }
        this.rootUsername = Strings.isNullOrEmpty((String)props.getProperty("root.username")) ? ROOT : props.getProperty("root.username");
        this.guestUsername = Strings.isNullOrEmpty((String)props.getProperty("guest.username")) ? GUEST : props.getProperty("guest.username");
        this.rootPassword = props.getProperty("root.password", ROOT);
        this.guestPassword = props.getProperty("guest.password", GUEST);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String authorization = httpRequest.getHeader("authorization");
        if (null != authorization && authorization.length() > AUTH_PREFIX.length()) {
            authorization = authorization.substring(AUTH_PREFIX.length(), authorization.length());
            if ((this.rootUsername + ":" + this.rootPassword).equals(new String(Base64.decodeBase64((String)authorization)))) {
                this.authenticateSuccess(httpResponse, false);
                chain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
            } else if ((this.guestUsername + ":" + this.guestPassword).equals(new String(Base64.decodeBase64((String)authorization)))) {
                this.authenticateSuccess(httpResponse, true);
                chain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
            } else {
                this.needAuthenticate(httpRequest, httpResponse);
            }
        } else {
            this.needAuthenticate(httpRequest, httpResponse);
        }
    }

    private void authenticateSuccess(HttpServletResponse response, boolean isGuest) {
        response.setStatus(200);
        response.setHeader("Pragma", "No-cache");
        response.setHeader("Cache-Control", "no-store");
        response.setDateHeader("Expires", 0L);
        response.setHeader("identify", true == isGuest ? GUEST : ROOT);
    }

    private void needAuthenticate(HttpServletRequest request, HttpServletResponse response) {
        response.setStatus(401);
        response.setHeader("Cache-Control", "no-store");
        response.setDateHeader("Expires", 0L);
        response.setHeader("WWW-authenticate", "Basic Realm=\"Elastic Job Console Auth\"");
    }

    public void destroy() {
    }
}

