/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.lite.internal.instance;

import com.dangdang.ddframe.job.lite.api.strategy.JobInstance;
import com.dangdang.ddframe.job.lite.internal.instance.InstanceNode;
import com.dangdang.ddframe.job.lite.internal.server.ServerService;
import com.dangdang.ddframe.job.lite.internal.storage.JobNodeStorage;
import com.dangdang.ddframe.job.reg.base.CoordinatorRegistryCenter;
import java.util.LinkedList;
import java.util.List;

public final class InstanceService {
    private final JobNodeStorage jobNodeStorage;
    private final InstanceNode instanceNode;
    private final ServerService serverService;

    public InstanceService(CoordinatorRegistryCenter regCenter, String jobName) {
        this.jobNodeStorage = new JobNodeStorage(regCenter, jobName);
        this.instanceNode = new InstanceNode(jobName);
        this.serverService = new ServerService(regCenter, jobName);
    }

    public void persistOnline() {
        this.jobNodeStorage.fillEphemeralJobNode(this.instanceNode.getLocalInstanceNode(), "");
    }

    public void removeInstance() {
        this.jobNodeStorage.removeJobNodeIfExisted(this.instanceNode.getLocalInstanceNode());
    }

    public void clearTriggerFlag() {
        this.jobNodeStorage.updateJobNode(this.instanceNode.getLocalInstanceNode(), "");
    }

    public List<JobInstance> getAvailableJobInstances() {
        LinkedList<JobInstance> result = new LinkedList<JobInstance>();
        for (String each : this.jobNodeStorage.getJobNodeChildrenKeys("instances")) {
            JobInstance jobInstance = new JobInstance(each);
            if (!this.serverService.isEnableServer(jobInstance.getIp())) continue;
            result.add(new JobInstance(each));
        }
        return result;
    }

    public boolean isLocalJobInstanceExisted() {
        return this.jobNodeStorage.isJobNodeExisted(this.instanceNode.getLocalInstanceNode());
    }
}

