/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.lite.internal.sharding;

import com.dangdang.ddframe.job.executor.ShardingContexts;
import com.dangdang.ddframe.job.lite.config.LiteJobConfiguration;
import com.dangdang.ddframe.job.lite.internal.config.ConfigurationService;
import com.dangdang.ddframe.job.lite.internal.schedule.JobRegistry;
import com.dangdang.ddframe.job.lite.internal.sharding.ShardingNode;
import com.dangdang.ddframe.job.lite.internal.storage.JobNodeStorage;
import com.dangdang.ddframe.job.reg.base.CoordinatorRegistryCenter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public final class ExecutionService {
    private final String jobName;
    private final JobNodeStorage jobNodeStorage;
    private final ConfigurationService configService;

    public ExecutionService(CoordinatorRegistryCenter regCenter, String jobName) {
        this.jobName = jobName;
        this.jobNodeStorage = new JobNodeStorage(regCenter, jobName);
        this.configService = new ConfigurationService(regCenter, jobName);
    }

    public void registerJobBegin(ShardingContexts shardingContexts) {
        JobRegistry.getInstance().setJobRunning(this.jobName, true);
        if (!this.configService.load(true).isMonitorExecution()) {
            return;
        }
        Iterator iterator = shardingContexts.getShardingItemParameters().keySet().iterator();
        while (iterator.hasNext()) {
            int each = (Integer)iterator.next();
            this.jobNodeStorage.fillEphemeralJobNode(ShardingNode.getRunningNode(each), "");
        }
    }

    public void registerJobCompleted(ShardingContexts shardingContexts) {
        JobRegistry.getInstance().setJobRunning(this.jobName, false);
        if (!this.configService.load(true).isMonitorExecution()) {
            return;
        }
        Iterator iterator = shardingContexts.getShardingItemParameters().keySet().iterator();
        while (iterator.hasNext()) {
            int each = (Integer)iterator.next();
            this.jobNodeStorage.removeJobNodeIfExisted(ShardingNode.getRunningNode(each));
        }
    }

    public void clearAllRunningInfo() {
        this.clearRunningInfo(this.getAllItems());
    }

    public void clearRunningInfo(List<Integer> items) {
        for (int each : items) {
            this.jobNodeStorage.removeJobNodeIfExisted(ShardingNode.getRunningNode(each));
        }
    }

    public boolean hasRunningItems(Collection<Integer> items) {
        LiteJobConfiguration jobConfig = this.configService.load(true);
        if (null == jobConfig || !jobConfig.isMonitorExecution()) {
            return false;
        }
        for (int each : items) {
            if (!this.jobNodeStorage.isJobNodeExisted(ShardingNode.getRunningNode(each))) continue;
            return true;
        }
        return false;
    }

    public boolean hasRunningItems() {
        return this.hasRunningItems(this.getAllItems());
    }

    private List<Integer> getAllItems() {
        int shardingTotalCount = this.configService.load(true).getTypeConfig().getCoreConfig().getShardingTotalCount();
        ArrayList<Integer> result = new ArrayList<Integer>(shardingTotalCount);
        for (int i = 0; i < shardingTotalCount; ++i) {
            result.add(i);
        }
        return result;
    }

    public boolean misfireIfHasRunningItems(Collection<Integer> items) {
        if (!this.hasRunningItems(items)) {
            return false;
        }
        this.setMisfire(items);
        return true;
    }

    public void setMisfire(Collection<Integer> items) {
        for (int each : items) {
            this.jobNodeStorage.createJobNodeIfNeeded(ShardingNode.getMisfireNode(each));
        }
    }

    public List<Integer> getMisfiredJobItems(Collection<Integer> items) {
        ArrayList<Integer> result = new ArrayList<Integer>(items.size());
        for (int each : items) {
            if (!this.jobNodeStorage.isJobNodeExisted(ShardingNode.getMisfireNode(each))) continue;
            result.add(each);
        }
        return result;
    }

    public void clearMisfire(Collection<Integer> items) {
        for (int each : items) {
            this.jobNodeStorage.removeJobNodeIfExisted(ShardingNode.getMisfireNode(each));
        }
    }

    public List<Integer> getDisabledItems(List<Integer> items) {
        ArrayList<Integer> result = new ArrayList<Integer>(items.size());
        for (int each : items) {
            if (!this.jobNodeStorage.isJobNodeExisted(ShardingNode.getDisabledNode(each))) continue;
            result.add(each);
        }
        return result;
    }
}

